/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.FDv2DataSourceConditions;
import com.launchdarkly.sdk.server.SourceManager;
import com.launchdarkly.sdk.server.SynchronizerFactoryWithState;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSinkV2;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

class FDv2DataSource
implements DataSource {
    private static final int defaultFallbackTimeoutSeconds = 120;
    private static final long defaultRecoveryTimeout = 300L;
    private final SourceManager sourceManager;
    private final List<FDv2DataSourceConditions.ConditionFactory> conditionFactories;
    private final DataSourceUpdateSinkV2 dataSourceUpdates;
    private final CompletableFuture<Boolean> startFuture = new CompletableFuture();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final int threadPriority;
    private final LDLogger logger;
    private volatile boolean closed = false;

    public FDv2DataSource(ImmutableList<DataSourceFactory<Initializer>> initializers, ImmutableList<DataSourceFactory<Synchronizer>> synchronizers, DataSourceFactory<Synchronizer> fdv1DataSourceFactory, DataSourceUpdateSinkV2 dataSourceUpdates, int threadPriority, LDLogger logger, ScheduledExecutorService sharedExecutor) {
        this(initializers, synchronizers, fdv1DataSourceFactory, dataSourceUpdates, threadPriority, logger, sharedExecutor, 120L, 300L);
    }

    public FDv2DataSource(ImmutableList<DataSourceFactory<Initializer>> initializers, ImmutableList<DataSourceFactory<Synchronizer>> synchronizers, DataSourceFactory<Synchronizer> fdv1DataSourceFactory, DataSourceUpdateSinkV2 dataSourceUpdates, int threadPriority, LDLogger logger, ScheduledExecutorService sharedExecutor, long fallbackTimeout, long recoveryTimeout) {
        List synchronizerFactories = synchronizers.stream().map(SynchronizerFactoryWithState::new).collect(Collectors.toCollection(ArrayList::new));
        if (fdv1DataSourceFactory != null) {
            SynchronizerFactoryWithState wrapped = new SynchronizerFactoryWithState(fdv1DataSourceFactory, true);
            wrapped.block();
            synchronizerFactories.add(wrapped);
        }
        this.sourceManager = new SourceManager(synchronizerFactories, initializers);
        this.dataSourceUpdates = dataSourceUpdates;
        this.threadPriority = threadPriority;
        this.logger = logger;
        this.conditionFactories = new ArrayList<FDv2DataSourceConditions.ConditionFactory>();
        this.conditionFactories.add(new FDv2DataSourceConditions.FallbackCondition.Factory(sharedExecutor, fallbackTimeout));
        this.conditionFactories.add(new FDv2DataSourceConditions.RecoveryCondition.Factory(sharedExecutor, recoveryTimeout));
    }

    private void run() {
        Thread runThread = new Thread(() -> {
            if (!this.sourceManager.hasAvailableSources()) {
                this.logger.info("LaunchDarkly client will not connect to Launchdarkly for feature flag data due to no initializers or synchronizers");
                this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
                this.startFuture.complete(true);
                return;
            }
            if (this.sourceManager.hasInitializers()) {
                this.runInitializers();
            }
            if (!this.sourceManager.hasAvailableSynchronizers()) {
                if (!this.isInitialized()) {
                    this.maybeReportUnexpectedExhaustion("All initializers exhausted and there are no available synchronizers.");
                }
                this.startFuture.complete(false);
                return;
            }
            this.runSynchronizers();
            this.maybeReportUnexpectedExhaustion("All data source acquisition methods have been exhausted.");
            this.startFuture.complete(false);
        });
        runThread.setName("LaunchDarkly-SDK-Server-FDv2DataSource");
        runThread.setDaemon(true);
        runThread.setPriority(this.threadPriority);
        runThread.start();
    }

    /*
     * Unable to fully structure code
     */
    private void runInitializers() {
        anyDataReceived = false;
        initializer = this.sourceManager.getNextInitializerAndSetActive();
        while (initializer != null) {
            block27: {
                try {
                    result = initializer.run().get();
                    var4_5 = null;
                    try {
                        switch (1.$SwitchMap$com$launchdarkly$sdk$server$datasources$FDv2SourceResult$ResultType[result.getResultType().ordinal()]) {
                            case 1: {
                                this.dataSourceUpdates.apply(result.getChangeSet());
                                anyDataReceived = true;
                                if (result.getChangeSet().getSelector().isEmpty()) ** break;
                                this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
                                this.startFuture.complete(true);
                                return;
                            }
                            case 2: {
                                status = result.getStatus();
                                switch (1.$SwitchMap$com$launchdarkly$sdk$server$datasources$FDv2SourceResult$State[status.getState().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, status.getErrorInfo());
                                        ** break;
                                    }
                                    case 3: 
                                    case 4: {
                                        this.logger.debug("Ignoring status {} from initializer", (Object)result.getStatus().getState());
                                    }
lbl26:
                                    // 3 sources

                                    ** default:
lbl27:
                                    // 1 sources

                                    break block27;
                                }
                            }
                            ** default:
lbl29:
                            // 1 sources

                            break;
                        }
                    }
                    catch (Throwable var5_9) {
                        var4_5 = var5_9;
                        throw var5_9;
                    }
                    finally {
                        if (result != null) {
                            if (var4_5 != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable var5_7) {
                                    var4_5.addSuppressed(var5_7);
                                }
                            } else {
                                result.close();
                            }
                        }
                    }
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, e.toString(), new Date().toInstant()));
                    this.logger.warn("Error running initializer: {}", (Object)e.toString());
                }
            }
            initializer = this.sourceManager.getNextInitializerAndSetActive();
        }
        if (anyDataReceived) {
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            this.startFuture.complete(true);
        }
    }

    private List<FDv2DataSourceConditions.Condition> getConditions() {
        int availableSynchronizers = this.sourceManager.getAvailableSynchronizerCount();
        boolean isPrimeSynchronizer = this.sourceManager.isPrimeSynchronizer();
        if (availableSynchronizers == 1) {
            return Collections.emptyList();
        }
        if (isPrimeSynchronizer) {
            return this.conditionFactories.stream().filter(factory2 -> factory2.getType() != FDv2DataSourceConditions.Condition.ConditionType.RECOVERY).map(FDv2DataSourceConditions.ConditionFactory::build).collect(Collectors.toList());
        }
        return this.conditionFactories.stream().map(FDv2DataSourceConditions.ConditionFactory::build).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private void runSynchronizers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 27[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Future<Void> start() {
        if (!this.started.getAndSet(true)) {
            this.run();
        }
        return this.startFuture.thenApply(x -> null);
    }

    @Override
    public boolean isInitialized() {
        try {
            return this.startFuture.isDone() && this.startFuture.get() != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.sourceManager.close();
        this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, null);
        this.startFuture.complete(false);
    }

    private void maybeReportUnexpectedExhaustion(String message) {
        if (!this.closed) {
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.OFF, new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, message, new Date().toInstant()));
        }
    }

    private static class Conditions
    implements AutoCloseable {
        private final List<FDv2DataSourceConditions.Condition> conditions;
        private final CompletableFuture<Object> conditionsFuture;

        public Conditions(List<FDv2DataSourceConditions.Condition> conditions) {
            this.conditions = conditions;
            this.conditionsFuture = conditions.isEmpty() ? new CompletableFuture() : CompletableFuture.anyOf((CompletableFuture[])conditions.stream().map(FDv2DataSourceConditions.Condition::execute).toArray(CompletableFuture[]::new));
        }

        public CompletableFuture<Object> getFuture() {
            return this.conditionsFuture;
        }

        public void inform(FDv2SourceResult result) {
            this.conditions.forEach(c -> c.inform(result));
        }

        @Override
        public void close() {
            this.conditions.forEach(FDv2DataSourceConditions.Condition::close);
        }
    }

    public static interface DataSourceFactory<T> {
        public T build();
    }
}

