/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.FDv2ChangeSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class FDv2ChangeSetTranslator {
    private FDv2ChangeSetTranslator() {
    }

    public static DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> toChangeSet(FDv2ChangeSet changeset, LDLogger logger, String environmentId, boolean shouldPersist) {
        DataStoreTypes.ChangeSetType changeSetType;
        switch (changeset.getType()) {
            case FULL: {
                changeSetType = DataStoreTypes.ChangeSetType.Full;
                break;
            }
            case PARTIAL: {
                changeSetType = DataStoreTypes.ChangeSetType.Partial;
                break;
            }
            case NONE: {
                changeSetType = DataStoreTypes.ChangeSetType.None;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown FDv2ChangeSetType: " + (Object)((Object)changeset.getType()) + ". This is an implementation error.");
            }
        }
        LinkedHashMap<DataStoreTypes.DataKind, List> kindToItems = new LinkedHashMap<DataStoreTypes.DataKind, List>();
        for (FDv2ChangeSet.FDv2Change change : changeset.getChanges()) {
            DataStoreTypes.ItemDescriptor item;
            DataStoreTypes.DataKind dataKind = FDv2ChangeSetTranslator.getDataKind(change.getKind());
            if (dataKind == null) {
                logger.warn("Unknown data kind '{}' in changeset, skipping", (Object)change.getKind());
                continue;
            }
            if (change.getType() == FDv2ChangeSet.FDv2ChangeType.PUT) {
                if (change.getObject() == null) {
                    logger.warn("Put operation for {}/{} missing object data, skipping", (Object)change.getKind(), (Object)change.getKey());
                    continue;
                }
                item = dataKind.deserialize(change.getObject().toString());
            } else if (change.getType() == FDv2ChangeSet.FDv2ChangeType.DELETE) {
                item = DataStoreTypes.ItemDescriptor.deletedItem(change.getVersion());
            } else {
                throw new IllegalArgumentException("Unknown FDv2ChangeType: " + (Object)((Object)change.getType()) + ". This is an implementation error.");
            }
            List itemsList = kindToItems.computeIfAbsent(dataKind, k -> new ArrayList());
            itemsList.add(new AbstractMap.SimpleImmutableEntry<String, DataStoreTypes.ItemDescriptor>(change.getKey(), item));
        }
        ImmutableList.Builder dataBuilder = ImmutableList.builder();
        for (Map.Entry entry : kindToItems.entrySet()) {
            dataBuilder.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), new DataStoreTypes.KeyedItems((Iterable)entry.getValue())));
        }
        return new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(changeSetType, changeset.getSelector(), dataBuilder.build(), environmentId, shouldPersist);
    }

    private static DataStoreTypes.DataKind getDataKind(String kind) {
        switch (kind) {
            case "flag": {
                return DataModel.FEATURES;
            }
            case "segment": {
                return DataModel.SEGMENTS;
            }
        }
        return null;
    }
}

