/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.DataSystem;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.FlagChangeNotifier;
import com.launchdarkly.sdk.server.FlagChangedFacade;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ReadOnlyStore;
import com.launchdarkly.sdk.server.ReadonlyStoreFacade;
import com.launchdarkly.sdk.server.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;

final class FDv1DataSystem
implements DataSystem,
Closeable {
    private final DataSource dataSource;
    private final DataStore dataStore;
    private final ReadOnlyStore store;
    private final FlagChangeNotifier flagChanged;
    private final DataSourceStatusProvider dataSourceStatusProvider;
    private final DataStoreStatusProvider dataStoreStatusProvider;
    private boolean disposed = false;
    final TestingAccess testing;

    DataStore getUnderlyingStore() {
        return this.dataStore;
    }

    private FDv1DataSystem(DataStore store, DataStoreStatusProvider dataStoreStatusProvider, DataSourceStatusProvider dataSourceStatusProvider, DataSource dataSource, FlagChangeNotifier flagChanged) {
        this.dataStoreStatusProvider = dataStoreStatusProvider;
        this.dataSourceStatusProvider = dataSourceStatusProvider;
        this.store = new ReadonlyStoreFacade(store);
        this.flagChanged = flagChanged;
        this.dataSource = dataSource;
        this.dataStore = store;
        this.testing = new TestingAccess(dataSource);
    }

    static FDv1DataSystem create(LDLogger logger, LDConfig config, ClientContextImpl clientContext, LoggingConfiguration logConfig) {
        DataStoreUpdatesImpl dataStoreUpdates = new DataStoreUpdatesImpl(EventBroadcasterImpl.forDataStoreStatus(clientContext.sharedExecutor, logger));
        DataStore dataStore = (config.dataStore == null ? Components.inMemoryDataStore() : config.dataStore).build(clientContext.withDataStoreUpdateSink(dataStoreUpdates));
        DataStoreStatusProviderImpl dataStoreStatusProvider = new DataStoreStatusProviderImpl(dataStore, dataStoreUpdates);
        EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster = EventBroadcasterImpl.forFlagChangeEvents(clientContext.sharedExecutor, logger);
        EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusBroadcaster = EventBroadcasterImpl.forDataSourceStatus(clientContext.sharedExecutor, logger);
        DataSourceUpdatesImpl dataSourceUpdates = new DataSourceUpdatesImpl(dataStore, dataStoreStatusProvider, flagChangeBroadcaster, dataSourceStatusBroadcaster, clientContext.sharedExecutor, logConfig.getLogDataSourceOutageAsErrorAfter(), logger);
        StreamingDataSourceBuilder dataSourceFactory = config.offline ? Components.externalUpdatesOnly() : (config.dataSource == null ? Components.streamingDataSource() : config.dataSource);
        DataSource dataSource = (DataSource)dataSourceFactory.build(clientContext.withDataSourceUpdateSink(dataSourceUpdates));
        DataSourceStatusProviderImpl dataSourceStatusProvider = new DataSourceStatusProviderImpl(dataSourceStatusBroadcaster, dataSourceUpdates);
        FlagChangedFacade flagChanged = new FlagChangedFacade(dataSourceUpdates);
        return new FDv1DataSystem(dataStore, dataStoreStatusProvider, dataSourceStatusProvider, dataSource, flagChanged);
    }

    @Override
    public ReadOnlyStore getStore() {
        return this.store;
    }

    @Override
    public Future<Void> start() {
        return this.dataSource.start();
    }

    @Override
    public boolean isInitialized() {
        return this.dataSource.isInitialized();
    }

    @Override
    public FlagChangeNotifier getFlagChanged() {
        return this.flagChanged;
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.dataSourceStatusProvider;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    @Override
    public void close() throws IOException {
        if (this.disposed) {
            return;
        }
        try {
            if (this.dataSource instanceof Closeable) {
                this.dataSource.close();
            }
            if (this.dataStore instanceof Closeable) {
                this.dataStore.close();
            }
        }
        finally {
            this.disposed = true;
        }
    }

    static final class TestingAccess {
        final DataSource dataSource;

        TestingAccess(DataSource dataSource) {
            this.dataSource = dataSource;
        }
    }
}

