/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.PrerequisiteEvalRecord;
import java.util.ArrayList;
import java.util.List;

final class EvalResult {
    private static final EvaluationDetail<Boolean> WRONG_TYPE_BOOLEAN = EvalResult.wrongTypeWithValue(false);
    private static final EvaluationDetail<Integer> WRONG_TYPE_INTEGER = EvalResult.wrongTypeWithValue(0);
    private static final EvaluationDetail<Double> WRONG_TYPE_DOUBLE = EvalResult.wrongTypeWithValue(0.0);
    private static final EvaluationDetail<String> WRONG_TYPE_STRING = EvalResult.wrongTypeWithValue(null);
    private final EvaluationDetail<LDValue> anyType;
    private final EvaluationDetail<Boolean> asBoolean;
    private final EvaluationDetail<Integer> asInteger;
    private final EvaluationDetail<Double> asDouble;
    private final EvaluationDetail<String> asString;
    private final boolean forceReasonTracking;
    private List<PrerequisiteEvalRecord> prerequisiteEvalRecords = new ArrayList<PrerequisiteEvalRecord>(0);

    static EvalResult of(EvaluationDetail<LDValue> original) {
        return new EvalResult(original);
    }

    static EvalResult of(LDValue value, int variationIndex, EvaluationReason reason) {
        return EvalResult.of(EvaluationDetail.fromValue(value, variationIndex, reason));
    }

    static EvalResult error(EvaluationReason.ErrorKind errorKind) {
        return EvalResult.of(LDValue.ofNull(), -1, EvaluationReason.error(errorKind));
    }

    static EvalResult error(EvaluationReason.ErrorKind errorKind, LDValue defaultValue) {
        return EvalResult.of(defaultValue, -1, EvaluationReason.error(errorKind));
    }

    private EvalResult(EvaluationDetail<LDValue> original) {
        this.anyType = original.getValue() == null ? EvaluationDetail.fromValue(LDValue.ofNull(), original.getVariationIndex(), original.getReason()) : original;
        this.forceReasonTracking = original.getReason().isInExperiment();
        LDValue value = this.anyType.getValue();
        int index = this.anyType.getVariationIndex();
        EvaluationReason reason = this.anyType.getReason();
        this.asBoolean = value.getType() == LDValueType.BOOLEAN ? EvaluationDetail.fromValue(value.booleanValue(), index, reason) : WRONG_TYPE_BOOLEAN;
        this.asInteger = value.isNumber() ? EvaluationDetail.fromValue(value.intValue(), index, reason) : WRONG_TYPE_INTEGER;
        this.asDouble = value.isNumber() ? EvaluationDetail.fromValue(value.doubleValue(), index, reason) : WRONG_TYPE_DOUBLE;
        this.asString = value.isString() || value.isNull() ? EvaluationDetail.fromValue(value.stringValue(), index, reason) : WRONG_TYPE_STRING;
    }

    private EvalResult(EvalResult from, EvaluationReason newReason) {
        this.anyType = EvalResult.transformReason(from.anyType, newReason);
        this.asBoolean = EvalResult.transformReason(from.asBoolean, newReason);
        this.asInteger = EvalResult.transformReason(from.asInteger, newReason);
        this.asDouble = EvalResult.transformReason(from.asDouble, newReason);
        this.asString = EvalResult.transformReason(from.asString, newReason);
        this.forceReasonTracking = from.forceReasonTracking;
        this.prerequisiteEvalRecords = from.prerequisiteEvalRecords;
    }

    private EvalResult(EvalResult from, boolean newForceTracking) {
        this.anyType = from.anyType;
        this.asBoolean = from.asBoolean;
        this.asInteger = from.asInteger;
        this.asDouble = from.asDouble;
        this.asString = from.asString;
        this.forceReasonTracking = newForceTracking;
        this.prerequisiteEvalRecords = from.prerequisiteEvalRecords;
    }

    private EvalResult(EvalResult from, List<PrerequisiteEvalRecord> prerequisiteEvalRecords) {
        this.anyType = from.anyType;
        this.asBoolean = from.asBoolean;
        this.asInteger = from.asInteger;
        this.asDouble = from.asDouble;
        this.asString = from.asString;
        this.forceReasonTracking = from.forceReasonTracking;
        this.prerequisiteEvalRecords = prerequisiteEvalRecords;
    }

    public EvaluationDetail<LDValue> getAnyType() {
        return this.anyType;
    }

    public EvaluationDetail<Boolean> getAsBoolean() {
        return this.asBoolean;
    }

    public EvaluationDetail<Integer> getAsInteger() {
        return this.asInteger;
    }

    public EvaluationDetail<Double> getAsDouble() {
        return this.asDouble;
    }

    public EvaluationDetail<String> getAsString() {
        return this.asString;
    }

    public LDValue getValue() {
        return this.anyType.getValue();
    }

    public int getVariationIndex() {
        return this.anyType.getVariationIndex();
    }

    public EvaluationReason getReason() {
        return this.anyType.getReason();
    }

    public boolean isNoVariation() {
        return this.anyType.isDefaultValue();
    }

    public boolean isForceReasonTracking() {
        return this.forceReasonTracking;
    }

    public List<PrerequisiteEvalRecord> getPrerequisiteEvalRecords() {
        return this.prerequisiteEvalRecords;
    }

    public EvalResult withReason(EvaluationReason newReason) {
        return newReason.equals(this.anyType.getReason()) ? this : new EvalResult(this, newReason);
    }

    public EvalResult withForceReasonTracking(boolean newValue) {
        return this.forceReasonTracking == newValue ? this : new EvalResult(this, newValue);
    }

    public EvalResult withPrerequisiteEvalRecords(List<PrerequisiteEvalRecord> newValue) {
        return this.prerequisiteEvalRecords == newValue ? this : new EvalResult(this, newValue);
    }

    public boolean equals(Object other) {
        if (other instanceof EvalResult) {
            EvalResult o = (EvalResult)other;
            return this.anyType.equals(o.anyType) && this.forceReasonTracking == o.forceReasonTracking;
        }
        return false;
    }

    public int hashCode() {
        return this.anyType.hashCode() + (this.forceReasonTracking ? 1 : 0);
    }

    public String toString() {
        if (this.forceReasonTracking) {
            return this.anyType.toString() + "(forceReasonTracking=true)";
        }
        return this.anyType.toString();
    }

    private static <T> EvaluationDetail<T> transformReason(EvaluationDetail<T> from, EvaluationReason newReason) {
        return from == null ? null : EvaluationDetail.fromValue(from.getValue(), from.getVariationIndex(), newReason);
    }

    private static <T> EvaluationDetail<T> wrongTypeWithValue(T value) {
        return EvaluationDetail.fromValue(value, -1, EvaluationReason.error(EvaluationReason.ErrorKind.WRONG_TYPE));
    }
}

