/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.DataModelSerialization;
import com.launchdarkly.sdk.server.FeatureRequestor;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpErrors;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.shaded.javax.annotation.Nullable;
import com.launchdarkly.shaded.okhttp3.Cache;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class DefaultFeatureRequestor
implements FeatureRequestor {
    private static final long MAX_HTTP_CACHE_SIZE_BYTES = 0xA00000L;
    private final OkHttpClient httpClient;
    @VisibleForTesting
    final URI pollingUri;
    private final Headers headers;
    private final Path cacheDir;
    private final LDLogger logger;

    DefaultFeatureRequestor(HttpProperties httpProperties, URI baseUri, @Nullable String payloadFilter, LDLogger logger) {
        this.logger = logger;
        URI tempUri = HttpHelpers.concatenateUriPath(baseUri, "/sdk/latest-all");
        if (payloadFilter != null) {
            if (!payloadFilter.isEmpty()) {
                tempUri = HttpHelpers.addQueryParam(tempUri, "filter", payloadFilter);
            } else {
                logger.info("Payload filter \"{}\" is not valid, not applying filter.", (Object)payloadFilter);
            }
        }
        this.pollingUri = tempUri;
        OkHttpClient.Builder httpBuilder = httpProperties.toHttpClientBuilder();
        this.headers = httpProperties.toHeadersBuilder().build();
        try {
            this.cacheDir = Files.createTempDirectory("LaunchDarklySDK", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to create cache directory for polling", e);
        }
        Cache cache = new Cache(this.cacheDir.toFile(), 0xA00000L);
        httpBuilder.cache(cache);
        this.httpClient = httpBuilder.build();
    }

    @Override
    public void close() {
        HttpProperties.shutdownHttpClient(this.httpClient);
        Util.deleteDirectory(this.cacheDir);
    }

    @Override
    public DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> getAllData(boolean returnDataEvenIfCached) throws IOException, HttpErrors.HttpErrorException, SerializationException {
        Request request = new Request.Builder().url(this.pollingUri.toURL()).headers(this.headers).get().build();
        this.logger.debug("Making request: " + request);
        try (Response response = this.httpClient.newCall(request).execute();){
            boolean wasCached;
            boolean bl = wasCached = response.networkResponse() == null || response.networkResponse().code() == 304;
            if (wasCached && !returnDataEvenIfCached) {
                this.logger.debug("Get flag(s) got cached response, will not parse");
                this.logger.debug("Cache hit count: {} Cache network count: {} ", (Object)this.httpClient.cache().hitCount(), (Object)this.httpClient.cache().networkCount());
                DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> fullDataSet = null;
                return fullDataSet;
            }
            this.logger.debug("Get flag(s) response: {}", (Object)response);
            this.logger.debug("Network response: {}", (Object)response.networkResponse());
            this.logger.debug("Cache hit count: {} Cache network count: {}", (Object)this.httpClient.cache().hitCount(), (Object)this.httpClient.cache().networkCount());
            this.logger.debug("Cache response: {}", (Object)response.cacheResponse());
            if (!response.isSuccessful()) {
                throw new HttpErrors.HttpErrorException(response.code());
            }
            JsonReader jr = new JsonReader(response.body().charStream());
            DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> fullDataSet = new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(DataModelSerialization.parseFullDataSet(jr), true);
            return fullDataSet;
        }
    }
}

