/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.FDv2Requestor;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.FDv2Event;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpHelpers;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.shaded.javax.annotation.Nonnull;
import com.launchdarkly.shaded.okhttp3.Call;
import com.launchdarkly.shaded.okhttp3.Callback;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DefaultFDv2Requestor
implements FDv2Requestor,
Closeable {
    private static final String BASIS_QUERY_PARAM = "basis";
    private static final String FILTER_QUERY_PARAM = "filter";
    private final OkHttpClient httpClient;
    private final URI pollingUri;
    private final Headers headers;
    private final LDLogger logger;
    private final Map<URI, String> etags;
    private final String payloadFilter;

    public DefaultFDv2Requestor(HttpProperties httpProperties, URI baseUri, String requestPath, String payloadFilter, LDLogger logger) {
        this.logger = logger;
        this.pollingUri = HttpHelpers.concatenateUriPath(baseUri, requestPath);
        this.etags = new HashMap<URI, String>();
        this.payloadFilter = payloadFilter;
        OkHttpClient.Builder httpBuilder = httpProperties.toHttpClientBuilder();
        this.headers = httpProperties.toHeadersBuilder().build();
        this.httpClient = httpBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<FDv2Requestor.FDv2PayloadResponse> Poll(Selector selector) {
        final CompletableFuture<FDv2Requestor.FDv2PayloadResponse> future = new CompletableFuture<FDv2Requestor.FDv2PayloadResponse>();
        try {
            URI requestUri = this.pollingUri;
            if (!selector.isEmpty()) {
                requestUri = HttpHelpers.addQueryParam(requestUri, BASIS_QUERY_PARAM, selector.getState());
            }
            if (this.payloadFilter != null && !this.payloadFilter.isEmpty()) {
                requestUri = HttpHelpers.addQueryParam(requestUri, FILTER_QUERY_PARAM, this.payloadFilter);
            }
            this.logger.debug("Making FDv2 polling request to: {}", (Object)requestUri);
            Request.Builder requestBuilder = new Request.Builder().url(requestUri.toURL()).headers(this.headers).get();
            Map<URI, String> map = this.etags;
            synchronized (map) {
                String etag = this.etags.get(requestUri);
                if (etag != null) {
                    requestBuilder.header("If-None-Match", etag);
                }
            }
            Request request = requestBuilder.build();
            final URI finalRequestUri = requestUri;
            this.httpClient.newCall(request).enqueue(new Callback(){

                @Override
                public void onFailure(@Nonnull Call call, @Nonnull IOException e) {
                    if (e instanceof SocketTimeoutException) {
                        future.completeExceptionally(new IOException("FDv2 polling request timed out: " + finalRequestUri, e));
                    } else {
                        future.completeExceptionally(e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(@Nonnull Call call, @Nonnull Response response) {
                    try {
                        if (response.code() == 304) {
                            DefaultFDv2Requestor.this.logger.debug("FDv2 polling request returned 304: not modified");
                            future.complete(FDv2Requestor.FDv2PayloadResponse.none(response.code()));
                            return;
                        }
                        if (!response.isSuccessful()) {
                            future.complete(FDv2Requestor.FDv2PayloadResponse.failure(response.code(), response.headers()));
                            return;
                        }
                        String newEtag = response.header("ETag");
                        Map map = DefaultFDv2Requestor.this.etags;
                        synchronized (map) {
                            if (newEtag != null) {
                                DefaultFDv2Requestor.this.etags.put(finalRequestUri, newEtag);
                            } else {
                                DefaultFDv2Requestor.this.etags.remove(finalRequestUri);
                            }
                        }
                        String responseBody = Objects.requireNonNull(response.body()).string();
                        DefaultFDv2Requestor.this.logger.debug("Received FDv2 polling response");
                        List<FDv2Event> events = FDv2Event.parseEventsArray(responseBody);
                        FDv2Requestor.FDv2PayloadResponse pollingResponse = FDv2Requestor.FDv2PayloadResponse.success(events, response.headers(), response.code());
                        future.complete(pollingResponse);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                    finally {
                        response.close();
                    }
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public void close() {
        HttpProperties.shutdownHttpClient(this.httpClient);
    }
}

