/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.DefaultFDv2Requestor;
import com.launchdarkly.sdk.server.PollingInitializerImpl;
import com.launchdarkly.sdk.server.PollingSynchronizerImpl;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.StreamingSynchronizerImpl;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.FDv2PollingInitializerBuilder;
import com.launchdarkly.sdk.server.integrations.FDv2PollingSynchronizerBuilder;
import com.launchdarkly.sdk.server.integrations.FDv2StreamingSynchronizerBuilder;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuildInputs;
import java.net.URI;

public final class DataSystemComponents {
    private DataSystemComponents() {
    }

    public static FDv2PollingInitializerBuilder pollingInitializer() {
        return new FDv2PollingInitializerBuilderImpl();
    }

    public static FDv2PollingSynchronizerBuilder pollingSynchronizer() {
        return new FDv2PollingSynchronizerBuilderImpl();
    }

    public static FDv2StreamingSynchronizerBuilder streamingSynchronizer() {
        return new FDv2StreamingSynchronizerBuilderImpl();
    }

    public static PollingDataSourceBuilder fDv1Polling() {
        return Components.pollingDataSource();
    }

    static class FDv2StreamingSynchronizerBuilderImpl
    extends FDv2StreamingSynchronizerBuilder {
        FDv2StreamingSynchronizerBuilderImpl() {
        }

        @Override
        public Synchronizer build(DataSourceBuildInputs context) {
            ServiceEndpoints endpoints = this.serviceEndpointsOverride != null ? this.serviceEndpointsOverride : context.getServiceEndpoints();
            URI configuredBaseUri = StandardEndpoints.selectBaseUri(endpoints.getStreamingBaseUri(), StandardEndpoints.DEFAULT_STREAMING_BASE_URI, "Streaming", context.getBaseLogger());
            return new StreamingSynchronizerImpl(ComponentsImpl.toHttpProperties(context.getHttp()), configuredBaseUri, "/sdk/stream", context.getBaseLogger(), context.getSelectorSource(), this.payloadFilter, this.initialReconnectDelay, context.getThreadPriority());
        }
    }

    static class FDv2PollingSynchronizerBuilderImpl
    extends FDv2PollingSynchronizerBuilder {
        FDv2PollingSynchronizerBuilderImpl() {
        }

        @Override
        public Synchronizer build(DataSourceBuildInputs context) {
            ServiceEndpoints endpoints = this.serviceEndpointsOverride != null ? this.serviceEndpointsOverride : context.getServiceEndpoints();
            URI configuredBaseUri = StandardEndpoints.selectBaseUri(endpoints.getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI, "Polling", context.getBaseLogger());
            DefaultFDv2Requestor requestor = new DefaultFDv2Requestor(ComponentsImpl.toHttpProperties(context.getHttp()), configuredBaseUri, "/sdk/poll", this.payloadFilter, context.getBaseLogger());
            return new PollingSynchronizerImpl(requestor, context.getBaseLogger(), context.getSelectorSource(), context.getSharedExecutor(), this.pollInterval);
        }
    }

    static class FDv2PollingInitializerBuilderImpl
    extends FDv2PollingInitializerBuilder {
        FDv2PollingInitializerBuilderImpl() {
        }

        @Override
        public Initializer build(DataSourceBuildInputs context) {
            ServiceEndpoints endpoints = this.serviceEndpointsOverride != null ? this.serviceEndpointsOverride : context.getServiceEndpoints();
            URI configuredBaseUri = StandardEndpoints.selectBaseUri(endpoints.getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI, "Polling", context.getBaseLogger());
            DefaultFDv2Requestor requestor = new DefaultFDv2Requestor(ComponentsImpl.toHttpProperties(context.getHttp()), configuredBaseUri, "/sdk/poll", this.payloadFilter, context.getBaseLogger());
            return new PollingInitializerImpl(requestor, context.getBaseLogger(), context.getSelectorSource());
        }
    }
}

