/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelDependencies;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSinkV2;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.TransactionalDataStore;
import com.launchdarkly.shaded.com.google.common.base.Joiner;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class DataSourceUpdatesImpl
implements DataSourceUpdateSink,
DataSourceUpdateSinkV2 {
    private final DataStore store;
    private final EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeEventNotifier;
    private final EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier;
    private final DataModelDependencies.DependencyTracker dependencyTracker = new DataModelDependencies.DependencyTracker();
    private final DataStoreStatusProvider dataStoreStatusProvider;
    private final OutageTracker outageTracker;
    private final Object stateLock = new Object();
    private final LDLogger logger;
    private volatile DataSourceStatusProvider.Status currentStatus;
    private volatile boolean lastStoreUpdateFailed = false;
    volatile Consumer<String> onOutageErrorLog = null;

    DataSourceUpdatesImpl(DataStore store, DataStoreStatusProvider dataStoreStatusProvider, EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeEventNotifier, EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusNotifier, ScheduledExecutorService sharedExecutor, Duration outageLoggingTimeout, LDLogger baseLogger) {
        this.store = store;
        this.flagChangeEventNotifier = flagChangeEventNotifier;
        this.dataSourceStatusNotifier = dataSourceStatusNotifier;
        this.dataStoreStatusProvider = dataStoreStatusProvider;
        this.outageTracker = new OutageTracker(sharedExecutor, outageLoggingTimeout);
        this.logger = baseLogger.subLogger("DataSource");
        this.currentStatus = new DataSourceStatusProvider.Status(DataSourceStatusProvider.State.INITIALIZING, Instant.now(), null);
    }

    @Override
    public boolean init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldData = null;
        try {
            if (this.hasFlagChangeEventListeners()) {
                oldData = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
                for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
                    DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items = this.store.getAll(kind);
                    oldData.put(kind, ImmutableMap.copyOf(items.getItems()));
                }
            }
            this.store.init(DataModelDependencies.sortAllCollections(allData));
            this.lastStoreUpdateFailed = false;
        }
        catch (RuntimeException e) {
            this.reportStoreFailure(e);
            return false;
        }
        this.updateDependencyTrackerFromFullDataSet(allData);
        if (oldData != null) {
            this.sendChangeEvents(this.computeChangedItemsForFullDataSet(oldData, this.fullDataSetToMap(allData)));
        }
        return true;
    }

    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        boolean successfullyUpdated;
        try {
            successfullyUpdated = this.store.upsert(kind, key, item);
            this.lastStoreUpdateFailed = false;
        }
        catch (RuntimeException e) {
            this.reportStoreFailure(e);
            return false;
        }
        if (successfullyUpdated) {
            this.dependencyTracker.updateDependenciesFrom(kind, key, item);
            if (this.hasFlagChangeEventListeners()) {
                HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
                this.sendChangeEvents(affectedItems);
            }
        }
        return true;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
        if (newState == null) {
            return;
        }
        DataSourceStatusProvider.Status statusToBroadcast = null;
        Object object = this.stateLock;
        synchronized (object) {
            DataSourceStatusProvider.Status oldStatus = this.currentStatus;
            if (newState == DataSourceStatusProvider.State.INTERRUPTED && oldStatus.getState() == DataSourceStatusProvider.State.INITIALIZING) {
                newState = DataSourceStatusProvider.State.INITIALIZING;
            }
            if (newState != oldStatus.getState() || newError != null) {
                statusToBroadcast = this.currentStatus = new DataSourceStatusProvider.Status(newState, newState == this.currentStatus.getState() ? this.currentStatus.getStateSince() : Instant.now(), newError == null ? this.currentStatus.getLastError() : newError);
                this.stateLock.notifyAll();
            }
            this.outageTracker.trackDataSourceState(newState, newError);
        }
        if (statusToBroadcast != null) {
            this.dataSourceStatusNotifier.broadcast(statusToBroadcast);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceStatusProvider.Status getLastStatus() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.currentStatus;
        }
    }

    boolean waitFor(DataSourceStatusProvider.State desiredState, Duration timeout2) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout2.toMillis();
        Object object = this.stateLock;
        synchronized (object) {
            while (true) {
                if (this.currentStatus.getState() == desiredState) {
                    return true;
                }
                if (this.currentStatus.getState() == DataSourceStatusProvider.State.OFF) {
                    return false;
                }
                if (timeout2.isZero()) {
                    this.stateLock.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                if (now >= deadline) {
                    return false;
                }
                this.stateLock.wait(deadline - now);
            }
        }
    }

    private boolean hasFlagChangeEventListeners() {
        return this.flagChangeEventNotifier.hasListeners();
    }

    void addFlagChangeListener(FlagChangeListener listener) {
        this.flagChangeEventNotifier.register(listener);
    }

    void removeFlagChangeListener(FlagChangeListener listener) {
        this.flagChangeEventNotifier.unregister(listener);
    }

    private void sendChangeEvents(Iterable<DataModelDependencies.KindAndKey> affectedItems) {
        for (DataModelDependencies.KindAndKey item : affectedItems) {
            if (item.kind != DataModel.FEATURES) continue;
            this.flagChangeEventNotifier.broadcast(new FlagChangeEvent(item.key));
        }
    }

    private void updateDependencyTrackerFromFullDataSet(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        this.dependencyTracker.reset();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
            DataStoreTypes.DataKind kind = e0.getKey();
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e1 : e0.getValue().getItems()) {
                String key = e1.getKey();
                this.dependencyTracker.updateDependenciesFrom(kind, key, e1.getValue());
            }
        }
    }

    private Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> fullDataSetToMap(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> ret = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e : allData.getData()) {
            ret.put(e.getKey(), ImmutableMap.copyOf(e.getValue().getItems()));
        }
        return ret;
    }

    private Set<DataModelDependencies.KindAndKey> computeChangedItemsForFullDataSet(Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldDataMap, Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> newDataMap) {
        HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
        for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
            Map<String, DataStoreTypes.ItemDescriptor> oldItems = oldDataMap.get(kind);
            Map<String, DataStoreTypes.ItemDescriptor> newItems = newDataMap.get(kind);
            if (oldItems == null) {
                oldItems = Collections.emptyMap();
            }
            if (newItems == null) {
                newItems = Collections.emptyMap();
            }
            ImmutableSet<String> allKeys = ImmutableSet.copyOf(Iterables.concat(oldItems.keySet(), newItems.keySet()));
            for (String key : allKeys) {
                DataStoreTypes.ItemDescriptor oldItem = oldItems.get(key);
                DataStoreTypes.ItemDescriptor newItem = newItems.get(key);
                if (oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.getVersion() >= newItem.getVersion()) continue;
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
            }
        }
        return affectedItems;
    }

    private void reportStoreFailure(RuntimeException e) {
        if (!this.lastStoreUpdateFailed) {
            this.logger.warn("Unexpected data store error when trying to store an update received from the data source: {}", LogValues.exceptionSummary(e));
            this.lastStoreUpdateFailed = true;
        }
        this.logger.debug(LogValues.exceptionTrace(e));
        this.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, DataSourceStatusProvider.ErrorInfo.fromException(DataSourceStatusProvider.ErrorKind.STORE_ERROR, e));
    }

    private static String describeErrorCount(Map.Entry<DataSourceStatusProvider.ErrorInfo, Integer> entry) {
        return entry.getKey() + " (" + entry.getValue() + (entry.getValue() == 1 ? " time" : " times") + ")";
    }

    @Override
    public boolean apply(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        if (this.store instanceof TransactionalDataStore) {
            return this.applyToTransactionalStore((TransactionalDataStore)((Object)this.store), changeSet);
        }
        return this.applyToLegacyStore(changeSet);
    }

    private boolean applyToTransactionalStore(TransactionalDataStore transactionalDataStore, DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldData;
        try {
            oldData = this.getOldDataIfFlagChangeListeners();
        }
        catch (RuntimeException e) {
            this.reportStoreFailure(e);
            return false;
        }
        DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> sortedChangeSet = DataModelDependencies.sortChangeset(changeSet);
        try {
            transactionalDataStore.apply(sortedChangeSet);
            this.lastStoreUpdateFailed = false;
        }
        catch (RuntimeException e) {
            this.reportStoreFailure(e);
            return false;
        }
        this.updateStatus(DataSourceStatusProvider.State.VALID, null);
        Set<DataModelDependencies.KindAndKey> changes = this.updateDependencyTrackerForChangesetAndDetermineChanges(oldData, sortedChangeSet);
        if (changes != null) {
            this.sendChangeEvents(changes);
        }
        return true;
    }

    private boolean applyToLegacyStore(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> sortedChangeSet) {
        switch (sortedChangeSet.getType()) {
            case Full: {
                return this.applyFullChangeSetToLegacyStore(sortedChangeSet);
            }
            case Partial: {
                return this.applyPartialChangeSetToLegacyStore(sortedChangeSet);
            }
        }
        return true;
    }

    private boolean applyFullChangeSetToLegacyStore(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> unsortedChangeset) {
        return this.init(new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(unsortedChangeset.getData(), unsortedChangeset.shouldPersist()));
    }

    private boolean applyPartialChangeSetToLegacyStore(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> sortedChangeset = DataModelDependencies.sortChangeset(changeSet);
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindItemsPair : sortedChangeset.getData()) {
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> item : kindItemsPair.getValue().getItems()) {
                boolean applySuccess = this.upsert(kindItemsPair.getKey(), item.getKey(), item.getValue());
                if (applySuccess) continue;
                return false;
            }
        }
        return true;
    }

    private Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> getOldDataIfFlagChangeListeners() {
        if (this.hasFlagChangeEventListeners()) {
            HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldData = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
            for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
                DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items = this.store.getAll(kind);
                oldData.put(kind, ImmutableMap.copyOf(items.getItems()));
            }
            return oldData;
        }
        return null;
    }

    private Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> changeSetToMap(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> ret = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e : changeSet.getData()) {
            ret.put(e.getKey(), ImmutableMap.copyOf(e.getValue().getItems()));
        }
        return ret;
    }

    private Set<DataModelDependencies.KindAndKey> updateDependencyTrackerForChangesetAndDetermineChanges(Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldDataMap, DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        switch (changeSet.getType()) {
            case Full: {
                return this.handleFullChangeset(oldDataMap, changeSet);
            }
            case Partial: {
                return this.handlePartialChangeset(oldDataMap, changeSet);
            }
            case None: {
                return null;
            }
        }
        return null;
    }

    private Set<DataModelDependencies.KindAndKey> handleFullChangeset(Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldDataMap, DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        this.dependencyTracker.reset();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindEntry : changeSet.getData()) {
            DataStoreTypes.DataKind kind = kindEntry.getKey();
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> itemEntry : kindEntry.getValue().getItems()) {
                String key = itemEntry.getKey();
                this.dependencyTracker.updateDependenciesFrom(kind, key, itemEntry.getValue());
            }
        }
        if (oldDataMap == null) {
            return null;
        }
        Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> newDataMap = this.changeSetToMap(changeSet);
        return this.computeChangedItemsForFullDataSet(oldDataMap, newDataMap);
    }

    private Set<DataModelDependencies.KindAndKey> handlePartialChangeset(Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> oldDataMap, DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        if (oldDataMap == null) {
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindEntry : changeSet.getData()) {
                DataStoreTypes.DataKind kind = kindEntry.getKey();
                for (Map.Entry<String, DataStoreTypes.ItemDescriptor> itemEntry : kindEntry.getValue().getItems()) {
                    this.dependencyTracker.updateDependenciesFrom(kind, itemEntry.getKey(), itemEntry.getValue());
                }
            }
            return null;
        }
        HashSet<DataModelDependencies.KindAndKey> affectedItems = new HashSet<DataModelDependencies.KindAndKey>();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindEntry : changeSet.getData()) {
            DataStoreTypes.DataKind kind = kindEntry.getKey();
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> itemEntry : kindEntry.getValue().getItems()) {
                String key = itemEntry.getKey();
                this.dependencyTracker.updateDependenciesFrom(kind, key, itemEntry.getValue());
                this.dependencyTracker.addAffectedItems(affectedItems, new DataModelDependencies.KindAndKey(kind, key));
            }
        }
        return affectedItems;
    }

    private final class OutageTracker {
        private final boolean enabled;
        private final ScheduledExecutorService sharedExecutor;
        private final Duration loggingTimeout;
        private final HashMap<DataSourceStatusProvider.ErrorInfo, Integer> errorCounts = new HashMap();
        private volatile boolean inOutage;
        private volatile ScheduledFuture<?> timeoutFuture;

        OutageTracker(ScheduledExecutorService sharedExecutor, Duration loggingTimeout) {
            this.sharedExecutor = sharedExecutor;
            this.loggingTimeout = loggingTimeout;
            this.enabled = loggingTimeout != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackDataSourceState(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
            if (!this.enabled) {
                return;
            }
            OutageTracker outageTracker = this;
            synchronized (outageTracker) {
                if (newState == DataSourceStatusProvider.State.INTERRUPTED || newError != null || newState == DataSourceStatusProvider.State.INITIALIZING && this.inOutage) {
                    if (this.inOutage) {
                        this.recordError(newError);
                    } else {
                        this.inOutage = true;
                        this.errorCounts.clear();
                        this.recordError(newError);
                        this.timeoutFuture = this.sharedExecutor.schedule(this::onTimeout, this.loggingTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                } else {
                    if (this.timeoutFuture != null) {
                        this.timeoutFuture.cancel(false);
                        this.timeoutFuture = null;
                    }
                    this.inOutage = false;
                }
            }
        }

        private void recordError(DataSourceStatusProvider.ErrorInfo newError) {
            DataSourceStatusProvider.ErrorInfo basicErrorInfo = new DataSourceStatusProvider.ErrorInfo(newError.getKind(), newError.getStatusCode(), null, null);
            this.errorCounts.compute(basicErrorInfo, (key, oldValue) -> oldValue == null ? 1 : oldValue + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTimeout() {
            String errorsDesc;
            OutageTracker outageTracker = this;
            synchronized (outageTracker) {
                if (this.timeoutFuture == null || !this.inOutage) {
                    return;
                }
                this.timeoutFuture = null;
                errorsDesc = Joiner.on(", ").join(Iterables.transform(this.errorCounts.entrySet(), x$0 -> DataSourceUpdatesImpl.describeErrorCount(x$0)));
            }
            if (DataSourceUpdatesImpl.this.onOutageErrorLog != null) {
                DataSourceUpdatesImpl.this.onOutageErrorLog.accept(errorsDesc);
            }
            DataSourceUpdatesImpl.this.logger.error("A streaming connection to LaunchDarkly has not been established within {} after the connection was interrupted. The following errors were encountered: {}", (Object)Util.describeDuration(this.loggingTimeout), (Object)errorsDesc);
        }
    }
}

