/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.collections.IterableAsyncQueue;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.io.IOException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class DataSourceSynchronizerAdapter
implements Synchronizer {
    private final DataSource dataSource;
    private final IterableAsyncQueue<FDv2SourceResult> resultQueue = new IterableAsyncQueue();
    private final CompletableFuture<FDv2SourceResult> shutdownFuture = new CompletableFuture();
    private final Object startLock = new Object();
    private boolean started = false;
    private boolean closed = false;
    private Future<Void> startFuture;

    public DataSourceSynchronizerAdapter(DataSourceFactory dataSourceFactory) {
        ConvertingUpdateSink convertingSink = new ConvertingUpdateSink(this.resultQueue);
        this.dataSource = dataSourceFactory.create(convertingSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<FDv2SourceResult> next() {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.started && !this.closed) {
                this.started = true;
                this.startFuture = this.dataSource.start();
                Thread monitorThread = new Thread(() -> {
                    try {
                        this.startFuture.get();
                    }
                    catch (ExecutionException e) {
                        DataSourceStatusProvider.ErrorInfo errorInfo = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, e.getCause() != null ? e.getCause().toString() : e.toString(), Instant.now());
                        this.resultQueue.put(FDv2SourceResult.interrupted(errorInfo, false));
                    }
                    catch (CancellationException e) {
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
                monitorThread.setName("LaunchDarkly-SDK-Server-DataSourceAdapter-Monitor");
                monitorThread.setDaemon(true);
                monitorThread.start();
            }
        }
        return CompletableFuture.anyOf(this.shutdownFuture, this.resultQueue.take()).thenApply(result -> (FDv2SourceResult)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.dataSource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.shutdownFuture.complete(FDv2SourceResult.shutdown());
        if (this.startFuture != null) {
            this.startFuture.cancel(true);
        }
    }

    private static class ConvertingUpdateSink
    implements DataSourceUpdateSink {
        private final IterableAsyncQueue<FDv2SourceResult> resultQueue;

        public ConvertingUpdateSink(IterableAsyncQueue<FDv2SourceResult> resultQueue) {
            this.resultQueue = resultQueue;
        }

        @Override
        public boolean init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
            DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet = new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(DataStoreTypes.ChangeSetType.Full, Selector.EMPTY, allData.getData(), null, allData.shouldPersist());
            this.resultQueue.put(FDv2SourceResult.changeSet(changeSet, false));
            return true;
        }

        @Override
        public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            DataStoreTypes.KeyedItems items = new DataStoreTypes.KeyedItems(Collections.singletonList(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(key, item)));
            List data = Collections.singletonList(new AbstractMap.SimpleEntry(kind, items));
            DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet = new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(DataStoreTypes.ChangeSetType.Partial, Selector.EMPTY, data, null, true);
            this.resultQueue.put(FDv2SourceResult.changeSet(changeSet, false));
            return true;
        }

        @Override
        public DataStoreStatusProvider getDataStoreStatusProvider() {
            return null;
        }

        @Override
        public void updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
            switch (newState) {
                case INTERRUPTED: {
                    this.resultQueue.put(FDv2SourceResult.interrupted(newError, false));
                    break;
                }
                case OFF: {
                    if (newError == null) break;
                    this.resultQueue.put(FDv2SourceResult.terminalError(newError, false));
                    break;
                }
            }
        }
    }

    @FunctionalInterface
    public static interface DataSourceFactory {
        public DataSource create(DataSourceUpdateSink var1);
    }
}

