/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.TypeAdapter;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

abstract class DataModelSerialization {
    DataModelSerialization() {
    }

    static DataModel.VersionedData deserializeFromParsedJson(DataStoreTypes.DataKind kind, JsonElement parsedJson) throws SerializationException {
        DataModel.VersionedData item;
        block4: {
            try {
                if (kind == DataModel.FEATURES) {
                    item = JsonHelpers.gsonInstance().fromJson(parsedJson, DataModel.FeatureFlag.class);
                    break block4;
                }
                if (kind == DataModel.SEGMENTS) {
                    item = JsonHelpers.gsonInstance().fromJson(parsedJson, DataModel.Segment.class);
                    break block4;
                }
                throw new IllegalArgumentException("unknown data kind");
            }
            catch (RuntimeException e) {
                throw new SerializationException(e);
            }
        }
        return item;
    }

    static DataModel.VersionedData deserializeFromJsonReader(DataStoreTypes.DataKind kind, JsonReader jr) throws SerializationException {
        DataModel.VersionedData item;
        block4: {
            try {
                if (kind == DataModel.FEATURES) {
                    item = (DataModel.VersionedData)JsonHelpers.gsonInstance().fromJson(jr, (Type)((Object)DataModel.FeatureFlag.class));
                    break block4;
                }
                if (kind == DataModel.SEGMENTS) {
                    item = (DataModel.VersionedData)JsonHelpers.gsonInstance().fromJson(jr, (Type)((Object)DataModel.Segment.class));
                    break block4;
                }
                throw new IllegalArgumentException("unknown data kind");
            }
            catch (RuntimeException e) {
                throw new SerializationException(e);
            }
        }
        return item;
    }

    static Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>> parseFullDataSet(JsonReader jr) throws SerializationException {
        ImmutableList.Builder flags = ImmutableList.builder();
        ImmutableList.Builder segments = ImmutableList.builder();
        try {
            jr.beginObject();
            block11: while (jr.peek() != JsonToken.END_OBJECT) {
                ImmutableList.Builder listBuilder;
                Class itemClass;
                String kindName;
                switch (kindName = jr.nextName()) {
                    case "flags": {
                        itemClass = DataModel.FeatureFlag.class;
                        listBuilder = flags;
                        break;
                    }
                    case "segments": {
                        itemClass = DataModel.Segment.class;
                        listBuilder = segments;
                        break;
                    }
                    default: {
                        jr.skipValue();
                        continue block11;
                    }
                }
                jr.beginObject();
                while (jr.peek() != JsonToken.END_OBJECT) {
                    String key = jr.nextName();
                    DataModel.FeatureFlag item = JsonHelpers.deserialize(jr, itemClass);
                    listBuilder.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(key, new DataStoreTypes.ItemDescriptor(((DataModel.VersionedData)item).getVersion(), item)));
                }
                jr.endObject();
            }
            jr.endObject();
            return ImmutableMap.of(DataModel.FEATURES, new DataStoreTypes.KeyedItems(flags.build()), DataModel.SEGMENTS, new DataStoreTypes.KeyedItems(segments.build())).entrySet();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        catch (RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    static Integer readNullableInt(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.skipValue();
            return null;
        }
        return in.nextInt();
    }

    static AttributeRef attributeNameOrPath(String attrString, ContextKind contextKind) {
        if (attrString == null) {
            return null;
        }
        return contextKind == null ? AttributeRef.fromLiteral(attrString) : AttributeRef.fromPath(attrString);
    }

    static class SegmentRuleTypeAdapter
    extends TypeAdapter<DataModel.SegmentRule> {
        SegmentRuleTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, DataModel.SegmentRule sr) throws IOException {
            out.beginObject();
            out.name("clauses").beginArray();
            for (DataModel.Clause c : sr.getClauses()) {
                JsonHelpers.gsonInstanceWithNullsAllowed().toJson((Object)c, (Type)((Object)DataModel.Clause.class), out);
            }
            out.endArray();
            if (sr.getWeight() != null) {
                out.name("weight").value(sr.getWeight());
            }
            if (sr.getRolloutContextKind() != null) {
                out.name("rolloutContextKind").value(sr.getRolloutContextKind().toString());
            }
            if (sr.getBucketBy() != null) {
                out.name("bucketBy").value(sr.getBucketBy().toString());
            }
            out.endObject();
        }

        @Override
        public DataModel.SegmentRule read(JsonReader in) throws IOException {
            ArrayList<DataModel.Clause> clauses = new ArrayList<DataModel.Clause>();
            Integer weight = null;
            ContextKind rolloutContextKind = null;
            String bucketByString = null;
            in.beginObject();
            block12: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "clauses": {
                        if (in.peek() == JsonToken.NULL) {
                            in.skipValue();
                            continue block12;
                        }
                        in.beginArray();
                        while (in.hasNext()) {
                            DataModel.Clause c = (DataModel.Clause)JsonHelpers.gsonInstanceWithNullsAllowed().fromJson(in, (Type)((Object)DataModel.Clause.class));
                            clauses.add(c);
                        }
                        in.endArray();
                        continue block12;
                    }
                    case "weight": {
                        weight = DataModelSerialization.readNullableInt(in);
                        continue block12;
                    }
                    case "rolloutContextKind": {
                        rolloutContextKind = ContextKind.of(in.nextString());
                        continue block12;
                    }
                    case "bucketBy": {
                        bucketByString = in.nextString();
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            AttributeRef bucketBy = DataModelSerialization.attributeNameOrPath(bucketByString, rolloutContextKind);
            return new DataModel.SegmentRule(clauses, weight, rolloutContextKind, bucketBy);
        }
    }

    static class RolloutTypeAdapter
    extends TypeAdapter<DataModel.Rollout> {
        RolloutTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, DataModel.Rollout r) throws IOException {
            out.beginObject();
            if (r.getContextKind() != null) {
                out.name("contextKind").value(r.getContextKind().toString());
            }
            out.name("variations").beginArray();
            for (DataModel.WeightedVariation wv : r.getVariations()) {
                JsonHelpers.gsonInstanceWithNullsAllowed().toJson((Object)wv, (Type)((Object)DataModel.WeightedVariation.class), out);
            }
            out.endArray();
            if (r.getBucketBy() != null) {
                out.name("bucketBy").value(r.getBucketBy().toString());
            }
            if (r.getKind() != DataModel.RolloutKind.rollout) {
                out.name("kind").value(r.getKind().name());
            }
            if (r.getSeed() != null) {
                out.name("seed").value(r.getSeed());
            }
            out.endObject();
        }

        @Override
        public DataModel.Rollout read(JsonReader in) throws IOException {
            ContextKind contextKind = null;
            ArrayList<DataModel.WeightedVariation> variations = new ArrayList<DataModel.WeightedVariation>();
            String bucketByString = null;
            DataModel.RolloutKind kind = DataModel.RolloutKind.rollout;
            Integer seed = null;
            in.beginObject();
            block14: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "contextKind": {
                        contextKind = ContextKind.of(in.nextString());
                        continue block14;
                    }
                    case "variations": {
                        if (in.peek() == JsonToken.NULL) {
                            in.skipValue();
                            continue block14;
                        }
                        in.beginArray();
                        while (in.hasNext()) {
                            DataModel.WeightedVariation wv = (DataModel.WeightedVariation)JsonHelpers.gsonInstanceWithNullsAllowed().fromJson(in, (Type)((Object)DataModel.WeightedVariation.class));
                            variations.add(wv);
                        }
                        in.endArray();
                        continue block14;
                    }
                    case "bucketBy": {
                        bucketByString = in.nextString();
                        continue block14;
                    }
                    case "kind": {
                        kind = DataModel.RolloutKind.experiment.name().equals(in.nextString()) ? DataModel.RolloutKind.experiment : DataModel.RolloutKind.rollout;
                        continue block14;
                    }
                    case "seed": {
                        seed = DataModelSerialization.readNullableInt(in);
                        continue block14;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            AttributeRef bucketBy = DataModelSerialization.attributeNameOrPath(bucketByString, contextKind);
            return new DataModel.Rollout(contextKind, variations, bucketBy, kind, seed);
        }
    }

    static class ClauseTypeAdapter
    extends TypeAdapter<DataModel.Clause> {
        ClauseTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, DataModel.Clause c) throws IOException {
            out.beginObject();
            if (c.getContextKind() != null) {
                out.name("contextKind").value(c.getContextKind().toString());
            }
            out.name("attribute").value(c.getAttribute() == null ? null : c.getAttribute().toString());
            out.name("op").value(c.getOp() == null ? null : c.getOp().name());
            out.name("values").beginArray();
            for (LDValue v : c.getValues()) {
                JsonHelpers.gsonInstanceWithNullsAllowed().toJson((Object)v, (Type)((Object)LDValue.class), out);
            }
            out.endArray();
            out.name("negate").value(c.isNegate());
            out.endObject();
        }

        @Override
        public DataModel.Clause read(JsonReader in) throws IOException {
            ContextKind contextKind = null;
            String attrString = null;
            DataModel.Operator op = null;
            ArrayList<LDValue> values2 = new ArrayList<LDValue>();
            boolean negate = false;
            in.beginObject();
            block14: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "contextKind": {
                        contextKind = ContextKind.of(in.nextString());
                        continue block14;
                    }
                    case "attribute": {
                        attrString = in.nextString();
                        continue block14;
                    }
                    case "op": {
                        op = DataModel.Operator.forName(in.nextString());
                        continue block14;
                    }
                    case "values": {
                        if (in.peek() == JsonToken.NULL) {
                            in.skipValue();
                            continue block14;
                        }
                        in.beginArray();
                        while (in.hasNext()) {
                            LDValue value = (LDValue)JsonHelpers.gsonInstanceWithNullsAllowed().fromJson(in, (Type)((Object)LDValue.class));
                            values2.add(value);
                        }
                        in.endArray();
                        continue block14;
                    }
                    case "negate": {
                        negate = in.nextBoolean();
                        continue block14;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            AttributeRef attribute = DataModelSerialization.attributeNameOrPath(attrString, contextKind);
            return new DataModel.Clause(contextKind, attribute, op, values2, negate);
        }
    }
}

