/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.launchdarkly.sdk.json.GsonReaderAdapter;
import com.launchdarkly.sdk.json.GsonWriterAdapter;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Iterator;

public class LDJackson {
    private LDJackson() {
    }

    public static Module module() {
        SimpleModule module = new SimpleModule(LDJackson.class.getName());
        module.addSerializer(JsonSerializable.class, (JsonSerializer)LDJacksonSerializer.INSTANCE);
        Iterator<Class<? extends JsonSerializable>> iterator2 = JsonSerialization.getDeserializableClasses().iterator();
        while (iterator2.hasNext()) {
            Class<? extends JsonSerializable> c;
            Class<? extends JsonSerializable> cjs = c = iterator2.next();
            module.addDeserializer(cjs, new LDJacksonDeserializer<JsonSerializable>(cjs));
        }
        return module;
    }

    static class GsonWriterToJacksonGeneratorAdapter
    extends GsonWriterAdapter {
        private final JsonGenerator gen;

        GsonWriterToJacksonGeneratorAdapter(JsonGenerator gen) {
            this.gen = gen;
        }

        @Override
        protected void beginArrayInternal() throws IOException {
            this.gen.writeStartArray();
        }

        @Override
        protected void beginObjectInternal() throws IOException {
            this.gen.writeStartObject();
        }

        @Override
        protected void endArrayInternal() throws IOException {
            this.gen.writeEndArray();
        }

        @Override
        protected void endObjectInternal() throws IOException {
            this.gen.writeEndObject();
        }

        @Override
        protected void jsonValueInternal(String value) throws IOException {
            this.gen.writeRawValue(value);
        }

        @Override
        protected void nameInternal(String name) throws IOException {
            this.gen.writeFieldName(name);
        }

        @Override
        protected void valueInternalNull() throws IOException {
            this.gen.writeNull();
        }

        @Override
        protected void valueInternalBool(boolean value) throws IOException {
            this.gen.writeBoolean(value);
        }

        @Override
        protected void valueInternalDouble(double value) throws IOException {
            this.gen.writeNumber(value);
        }

        @Override
        protected void valueInternalLong(long value) throws IOException {
            this.gen.writeNumber(value);
        }

        @Override
        protected void valueInternalString(String value) throws IOException {
            this.gen.writeString(value);
        }
    }

    static class GsonReaderToJacksonParserAdapter
    extends GsonReaderAdapter {
        private final JsonParser parser;
        private boolean atToken = true;

        GsonReaderToJacksonParserAdapter(JsonParser parser) {
            this.parser = parser;
        }

        @Override
        public void beginArray() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.START_ARRAY, com.fasterxml.jackson.core.JsonToken.START_ARRAY, "array");
        }

        @Override
        public void beginObject() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.START_OBJECT, com.fasterxml.jackson.core.JsonToken.START_OBJECT, "object");
        }

        @Override
        public void endArray() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.END_ARRAY, com.fasterxml.jackson.core.JsonToken.END_ARRAY, "end of array");
        }

        @Override
        public void endObject() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.END_OBJECT, com.fasterxml.jackson.core.JsonToken.END_OBJECT, "end of object");
        }

        @Override
        public boolean hasNext() throws IOException {
            com.fasterxml.jackson.core.JsonToken t2 = this.peekToken();
            return t2 != com.fasterxml.jackson.core.JsonToken.END_ARRAY && t2 != com.fasterxml.jackson.core.JsonToken.END_OBJECT;
        }

        @Override
        public boolean nextBoolean() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.VALUE_FALSE, com.fasterxml.jackson.core.JsonToken.VALUE_TRUE, "boolean");
            return this.parser.getBooleanValue();
        }

        @Override
        public double nextDouble() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.VALUE_NUMBER_FLOAT, com.fasterxml.jackson.core.JsonToken.VALUE_NUMBER_INT, "number");
            return this.parser.getDoubleValue();
        }

        @Override
        public int nextInt() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.VALUE_NUMBER_FLOAT, com.fasterxml.jackson.core.JsonToken.VALUE_NUMBER_INT, "number");
            return this.parser.getIntValue();
        }

        @Override
        public long nextLong() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.VALUE_NUMBER_FLOAT, com.fasterxml.jackson.core.JsonToken.VALUE_NUMBER_INT, "number");
            return this.parser.getLongValue();
        }

        @Override
        public String nextName() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.FIELD_NAME, com.fasterxml.jackson.core.JsonToken.FIELD_NAME, "property name");
            return this.parser.getCurrentName();
        }

        @Override
        public void nextNull() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.VALUE_NULL, com.fasterxml.jackson.core.JsonToken.VALUE_NULL, "null");
        }

        @Override
        public String nextString() throws IOException {
            this.requireToken(com.fasterxml.jackson.core.JsonToken.VALUE_STRING, com.fasterxml.jackson.core.JsonToken.VALUE_NULL, "string");
            return this.parser.getValueAsString();
        }

        @Override
        public void skipValue() throws IOException {
            this.consumeToken();
            this.parser.skipChildren();
        }

        @Override
        protected int peekInternal() throws IOException {
            JsonToken gt;
            com.fasterxml.jackson.core.JsonToken t2 = this.peekToken();
            if (t2 == null) {
                return JsonToken.END_DOCUMENT.ordinal();
            }
            switch (t2) {
                case END_ARRAY: {
                    gt = JsonToken.END_ARRAY;
                    break;
                }
                case END_OBJECT: {
                    gt = JsonToken.END_OBJECT;
                    break;
                }
                case FIELD_NAME: {
                    gt = JsonToken.NAME;
                    break;
                }
                case NOT_AVAILABLE: {
                    gt = JsonToken.END_DOCUMENT;
                    break;
                }
                case START_ARRAY: {
                    gt = JsonToken.BEGIN_ARRAY;
                    break;
                }
                case START_OBJECT: {
                    gt = JsonToken.BEGIN_OBJECT;
                    break;
                }
                case VALUE_FALSE: {
                    gt = JsonToken.BOOLEAN;
                    break;
                }
                case VALUE_NULL: {
                    gt = JsonToken.NULL;
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    gt = JsonToken.NUMBER;
                    break;
                }
                case VALUE_NUMBER_INT: {
                    gt = JsonToken.NUMBER;
                    break;
                }
                case VALUE_STRING: {
                    gt = JsonToken.STRING;
                    break;
                }
                case VALUE_TRUE: {
                    gt = JsonToken.BOOLEAN;
                    break;
                }
                default: {
                    gt = JsonToken.END_DOCUMENT;
                }
            }
            return gt.ordinal();
        }

        private void requireToken(com.fasterxml.jackson.core.JsonToken type, com.fasterxml.jackson.core.JsonToken alternateType, String expectedDesc) throws IOException {
            com.fasterxml.jackson.core.JsonToken t2 = this.consumeToken();
            if (t2 != type && t2 != alternateType) {
                throw new JsonParseException(this.parser, "expected " + expectedDesc);
            }
        }

        private com.fasterxml.jackson.core.JsonToken peekToken() throws IOException {
            if (!this.atToken) {
                this.atToken = true;
                return this.parser.nextToken();
            }
            return this.parser.currentToken();
        }

        private com.fasterxml.jackson.core.JsonToken consumeToken() throws IOException {
            if (this.atToken) {
                this.atToken = false;
                return this.parser.currentToken();
            }
            return this.parser.nextToken();
        }
    }

    private static class LDJacksonDeserializer<T extends JsonSerializable>
    extends JsonDeserializer<T> {
        private final Class<T> objectClass;

        LDJacksonDeserializer(Class<T> objectClass) {
            this.objectClass = objectClass;
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Throwable throwable = null;
            try (GsonReaderToJacksonParserAdapter adapter = new GsonReaderToJacksonParserAdapter(p);){
                JsonSerializable jsonSerializable = (JsonSerializable)JsonSerialization.deserializeFromGsonInternal(adapter, this.objectClass);
                return (T)jsonSerializable;
            }
            catch (com.launchdarkly.shaded.com.google.gson.JsonParseException e) {
                try {
                    throw new JsonParseException(p, e.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static class LDJacksonSerializer
    extends JsonSerializer<JsonSerializable> {
        static final LDJacksonSerializer INSTANCE = new LDJacksonSerializer();

        private LDJacksonSerializer() {
        }

        public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try (GsonWriterToJacksonGeneratorAdapter adapter = new GsonWriterToJacksonGeneratorAdapter(gen);){
                JsonSerialization.serializeToGsonInternal(value, value.getClass(), adapter);
            }
        }
    }
}

