/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.subsystems;

import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import java.net.Proxy;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public final class HttpConfiguration {
    private final Duration connectTimeout;
    private final Map<String, String> defaultHeaders;
    private final Proxy proxy;
    private final HttpAuthentication proxyAuthentication;
    private final SocketFactory socketFactory;
    private final Duration socketTimeout;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager trustManager;

    public HttpConfiguration(Duration connectTimeout, Map<String, String> defaultHeaders, Proxy proxy, HttpAuthentication proxyAuthentication, SocketFactory socketFactory, Duration socketTimeout, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.connectTimeout = connectTimeout == null ? HttpConfigurationBuilder.DEFAULT_CONNECT_TIMEOUT : connectTimeout;
        this.defaultHeaders = defaultHeaders == null ? Collections.emptyMap() : new HashMap<String, String>(defaultHeaders);
        this.proxy = proxy;
        this.proxyAuthentication = proxyAuthentication;
        this.socketFactory = socketFactory;
        this.socketTimeout = socketTimeout == null ? HttpConfigurationBuilder.DEFAULT_SOCKET_TIMEOUT : socketTimeout;
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Iterable<Map.Entry<String, String>> getDefaultHeaders() {
        return this.defaultHeaders.entrySet();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HttpAuthentication getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }
}

