/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.ArrayBuilder;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSortedSet;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public final class TestData
implements ComponentConfigurer<DataSource> {
    private final Object lock = new Object();
    private final Map<String, DataStoreTypes.ItemDescriptor> currentFlags = new HashMap<String, DataStoreTypes.ItemDescriptor>();
    private final Map<String, FlagBuilder> currentBuilders = new HashMap<String, FlagBuilder>();
    private final List<DataSourceImpl> instances = new CopyOnWriteArrayList<DataSourceImpl>();

    public static TestData dataSource() {
        return new TestData();
    }

    private TestData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlagBuilder flag(String key) {
        FlagBuilder existingBuilder;
        Object object = this.lock;
        synchronized (object) {
            existingBuilder = this.currentBuilders.get(key);
        }
        if (existingBuilder != null) {
            return new FlagBuilder(existingBuilder);
        }
        return new FlagBuilder(key).booleanFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData update(FlagBuilder flagBuilder) {
        String key = flagBuilder.key;
        FlagBuilder clonedBuilder = new FlagBuilder(flagBuilder);
        DataStoreTypes.ItemDescriptor newItem = null;
        Iterator<DataSourceImpl> iterator2 = this.lock;
        synchronized (iterator2) {
            DataStoreTypes.ItemDescriptor oldItem = this.currentFlags.get(key);
            int oldVersion = oldItem == null ? 0 : oldItem.getVersion();
            newItem = flagBuilder.createFlag(oldVersion + 1);
            this.currentFlags.put(key, newItem);
            this.currentBuilders.put(key, clonedBuilder);
        }
        for (DataSourceImpl instance : this.instances) {
            instance.updates.upsert(DataModel.FEATURES, key, newItem);
        }
        return this;
    }

    public TestData updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
        for (DataSourceImpl instance : this.instances) {
            instance.updates.updateStatus(newState, newError);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource build(ClientContext context) {
        DataSourceImpl instance = new DataSourceImpl(context.getDataSourceUpdateSink());
        Object object = this.lock;
        synchronized (object) {
            this.instances.add(instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> makeInitData() {
        ImmutableMap<String, DataStoreTypes.ItemDescriptor> copiedData;
        Object object = this.lock;
        synchronized (object) {
            copiedData = ImmutableMap.copyOf(this.currentFlags);
        }
        return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(ImmutableMap.of(DataModel.FEATURES, new DataStoreTypes.KeyedItems(copiedData.entrySet())).entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closedInstance(DataSourceImpl instance) {
        Object object = this.lock;
        synchronized (object) {
            this.instances.remove(instance);
        }
    }

    private final class DataSourceImpl
    implements DataSource {
        final DataSourceUpdateSink updates;

        DataSourceImpl(DataSourceUpdateSink updates) {
            this.updates = updates;
        }

        @Override
        public Future<Void> start() {
            this.updates.init(TestData.this.makeInitData());
            this.updates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public void close() throws IOException {
            TestData.this.closedInstance(this);
        }
    }

    public static final class FlagBuilder {
        private static final int TRUE_VARIATION_FOR_BOOLEAN = 0;
        private static final int FALSE_VARIATION_FOR_BOOLEAN = 1;
        final String key;
        int offVariation;
        boolean on;
        int fallthroughVariation;
        CopyOnWriteArrayList<LDValue> variations;
        final Map<ContextKind, Map<Integer, ImmutableSet<String>>> targets = new TreeMap<ContextKind, Map<Integer, ImmutableSet<String>>>();
        final List<FlagRuleBuilder> rules = new ArrayList<FlagRuleBuilder>();

        private FlagBuilder(String key) {
            this.key = key;
            this.on = true;
            this.variations = new CopyOnWriteArrayList();
        }

        private FlagBuilder(FlagBuilder from) {
            this.key = from.key;
            this.offVariation = from.offVariation;
            this.on = from.on;
            this.fallthroughVariation = from.fallthroughVariation;
            this.variations = new CopyOnWriteArrayList<LDValue>(from.variations);
            for (ContextKind contextKind : from.targets.keySet()) {
                this.targets.put(contextKind, new TreeMap<Integer, ImmutableSet<String>>(from.targets.get(contextKind)));
            }
            this.rules.addAll(from.rules);
        }

        private boolean isBooleanFlag() {
            return this.variations.size() == 2 && this.variations.get(0).equals(LDValue.of(true)) && this.variations.get(1).equals(LDValue.of(false));
        }

        public FlagBuilder booleanFlag() {
            if (this.isBooleanFlag()) {
                return this;
            }
            return this.variations(LDValue.of(true), LDValue.of(false)).fallthroughVariation(0).offVariation(1);
        }

        public FlagBuilder on(boolean on) {
            this.on = on;
            return this;
        }

        public FlagBuilder fallthroughVariation(boolean value) {
            return this.booleanFlag().fallthroughVariation(FlagBuilder.variationForBoolean(value));
        }

        public FlagBuilder fallthroughVariation(int variationIndex) {
            this.fallthroughVariation = variationIndex;
            return this;
        }

        public FlagBuilder offVariation(boolean value) {
            return this.booleanFlag().offVariation(FlagBuilder.variationForBoolean(value));
        }

        public FlagBuilder offVariation(int variationIndex) {
            this.offVariation = variationIndex;
            return this;
        }

        public FlagBuilder variationForAll(boolean variation) {
            return this.booleanFlag().variationForAll(FlagBuilder.variationForBoolean(variation));
        }

        public FlagBuilder variationForAll(int variationIndex) {
            return this.on(true).clearRules().clearTargets().fallthroughVariation(variationIndex);
        }

        public FlagBuilder valueForAll(LDValue value) {
            this.variations.clear();
            this.variations.add(value);
            return this.variationForAll(0);
        }

        public FlagBuilder variationForUser(String userKey, boolean variation) {
            return this.variationForKey(ContextKind.DEFAULT, userKey, variation);
        }

        public FlagBuilder variationForKey(ContextKind contextKind, String key, boolean variation) {
            return this.booleanFlag().variationForKey(contextKind, key, FlagBuilder.variationForBoolean(variation));
        }

        public FlagBuilder variationForUser(String userKey, int variationIndex) {
            return this.variationForKey(ContextKind.DEFAULT, userKey, variationIndex);
        }

        public FlagBuilder variationForKey(ContextKind contextKind, String key, int variationIndex) {
            Map<Integer, ImmutableSet<String>> keysByVariation;
            if (contextKind == null) {
                contextKind = ContextKind.DEFAULT;
            }
            if ((keysByVariation = this.targets.get(contextKind)) == null) {
                keysByVariation = new TreeMap<Integer, ImmutableSet<String>>();
                this.targets.put(contextKind, keysByVariation);
            }
            for (int i = 0; i < this.variations.size(); ++i) {
                ImmutableSet<String> keys2 = keysByVariation.get(i);
                if (i == variationIndex) {
                    if (keys2 == null) {
                        keysByVariation.put(i, ImmutableSortedSet.of(key));
                        continue;
                    }
                    if (keys2.contains(key)) continue;
                    keysByVariation.put(i, ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.naturalOrder().addAll(keys2)).add(key)).build());
                    continue;
                }
                if (keys2 == null || !keys2.contains(key)) continue;
                keysByVariation.put(i, ImmutableSortedSet.copyOf(Iterables.filter(keys2, k -> !k.equals(key))));
            }
            return this;
        }

        public FlagBuilder variations(LDValue ... values2) {
            this.variations.clear();
            for (LDValue v : values2) {
                this.variations.add(v);
            }
            return this;
        }

        public FlagRuleBuilder ifMatch(ContextKind contextKind, String attribute, LDValue ... values2) {
            return new FlagRuleBuilder().andMatch(contextKind, attribute, values2);
        }

        public FlagRuleBuilder ifMatch(String attribute, LDValue ... values2) {
            return this.ifMatch(ContextKind.DEFAULT, attribute, values2);
        }

        public FlagRuleBuilder ifNotMatch(ContextKind contextKind, String attribute, LDValue ... values2) {
            return new FlagRuleBuilder().andNotMatch(contextKind, attribute, values2);
        }

        public FlagRuleBuilder ifNotMatch(String attribute, LDValue ... values2) {
            return this.ifNotMatch(ContextKind.DEFAULT, attribute, values2);
        }

        public FlagBuilder clearRules() {
            this.rules.clear();
            return this;
        }

        public FlagBuilder clearTargets() {
            this.targets.clear();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        DataStoreTypes.ItemDescriptor createFlag(int version) {
            ObjectBuilder builder = LDValue.buildObject().put("key", this.key).put("version", version).put("on", this.on).put("offVariation", this.offVariation).put("fallthrough", LDValue.buildObject().put("variation", this.fallthroughVariation).build());
            builder.put("prerequisites", LDValue.arrayOf(new LDValue[0])).put("salt", "");
            ArrayBuilder jsonVariations = LDValue.buildArray();
            for (LDValue v : this.variations) {
                jsonVariations.add(v);
            }
            builder.put("variations", jsonVariations.build());
            ArrayBuilder jsonTargets = LDValue.buildArray();
            ArrayBuilder jsonContextTargets = LDValue.buildArray();
            if (!this.targets.isEmpty()) {
                if (this.targets.get(ContextKind.DEFAULT) != null) {
                    for (Map.Entry entry : this.targets.get(ContextKind.DEFAULT).entrySet()) {
                        if (((ImmutableSet)entry.getValue()).isEmpty()) continue;
                        jsonTargets.add(LDValue.buildObject().put("variation", (Integer)entry.getKey()).put("values", LDValue.Convert.String.arrayFrom((Iterable)entry.getValue())).build());
                    }
                }
                for (ContextKind contextKind : this.targets.keySet()) {
                    for (Map.Entry entry : this.targets.get(contextKind).entrySet()) {
                        if (((ImmutableSet)entry.getValue()).isEmpty()) continue;
                        jsonContextTargets.add(LDValue.buildObject().put("contextKind", contextKind.toString()).put("variation", (Integer)entry.getKey()).put("values", contextKind.isDefault() ? LDValue.arrayOf(new LDValue[0]) : LDValue.Convert.String.arrayFrom((Iterable)entry.getValue())).build());
                    }
                }
            }
            builder.put("targets", jsonTargets.build());
            builder.put("contextTargets", jsonContextTargets.build());
            ArrayBuilder jsonRules = LDValue.buildArray();
            if (!this.rules.isEmpty()) {
                boolean bl = false;
                for (FlagRuleBuilder flagRuleBuilder : this.rules) {
                    void var7_11;
                    ArrayBuilder jsonClauses = LDValue.buildArray();
                    for (Clause c : flagRuleBuilder.clauses) {
                        ArrayBuilder jsonValues = LDValue.buildArray();
                        for (LDValue v : c.values) {
                            jsonValues.add(v);
                        }
                        jsonClauses.add(LDValue.buildObject().put("contextKind", c.contextKind == null ? null : c.contextKind.toString()).put("attribute", c.attribute.toString()).put("op", c.operator).put("values", jsonValues.build()).put("negate", c.negate).build());
                    }
                    jsonRules.add(LDValue.buildObject().put("id", "rule" + (int)var7_11).put("variation", flagRuleBuilder.variation).put("clauses", jsonClauses.build()).build());
                    ++var7_11;
                }
            }
            builder.put("rules", jsonRules.build());
            String string = builder.build().toJsonString();
            return DataModel.FEATURES.deserialize(string);
        }

        private static int variationForBoolean(boolean value) {
            return value ? 0 : 1;
        }

        private static final class Clause {
            final ContextKind contextKind;
            final AttributeRef attribute;
            final String operator;
            final LDValue[] values;
            final boolean negate;

            Clause(ContextKind contextKind, AttributeRef attribute, String operator, LDValue[] values2, boolean negate) {
                this.contextKind = contextKind;
                this.attribute = attribute;
                this.operator = operator;
                this.values = values2;
                this.negate = negate;
            }
        }

        public final class FlagRuleBuilder {
            final List<Clause> clauses = new ArrayList<Clause>();
            int variation;

            public FlagRuleBuilder andMatch(ContextKind contextKind, String attribute, LDValue ... values2) {
                if (attribute != null) {
                    this.clauses.add(new Clause(contextKind, AttributeRef.fromPath(attribute), "in", values2, false));
                }
                return this;
            }

            public FlagRuleBuilder andMatch(String attribute, LDValue ... values2) {
                return this.andMatch(ContextKind.DEFAULT, attribute, values2);
            }

            public FlagRuleBuilder andNotMatch(ContextKind contextKind, String attribute, LDValue ... values2) {
                if (attribute != null) {
                    this.clauses.add(new Clause(contextKind, AttributeRef.fromPath(attribute), "in", values2, true));
                }
                return this;
            }

            public FlagRuleBuilder andNotMatch(String attribute, LDValue ... values2) {
                return this.andNotMatch(ContextKind.DEFAULT, attribute, values2);
            }

            public FlagBuilder thenReturn(boolean variation) {
                FlagBuilder.this.booleanFlag();
                return this.thenReturn(FlagBuilder.variationForBoolean(variation));
            }

            public FlagBuilder thenReturn(int variationIndex) {
                this.variation = variationIndex;
                FlagBuilder.this.rules.add(this);
                return FlagBuilder.this;
            }
        }
    }
}

