/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.interfaces.Event;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class EventSummarizer {
    private EventSummary eventsState = new EventSummary();

    EventSummarizer() {
    }

    void summarizeEvent(Event event) {
        if (!(event instanceof Event.FeatureRequest)) {
            return;
        }
        Event.FeatureRequest fe = (Event.FeatureRequest)event;
        this.eventsState.incrementCounter(fe.getKey(), fe.getVariation(), fe.getVersion(), fe.getValue(), fe.getDefaultVal());
        this.eventsState.noteTimestamp(fe.getCreationDate());
    }

    EventSummary getSummaryAndReset() {
        EventSummary ret = this.eventsState;
        this.clear();
        return ret;
    }

    void restoreTo(EventSummary previousState) {
        this.eventsState = previousState;
    }

    boolean isEmpty() {
        return this.eventsState.isEmpty();
    }

    void clear() {
        this.eventsState = new EventSummary();
    }

    static final class SimpleIntKeyedMap<T> {
        private static final int INITIAL_CAPACITY = 4;
        private int[] keys = new int[4];
        private Object[] values = new Object[4];
        private int n;

        SimpleIntKeyedMap() {
        }

        int size() {
            return this.n;
        }

        int capacity() {
            return this.keys.length;
        }

        int keyAt(int index) {
            return this.keys[index];
        }

        T valueAt(int index) {
            return (T)this.values[index];
        }

        T get(int key) {
            for (int i = 0; i < this.n; ++i) {
                if (this.keys[i] != key) continue;
                return (T)this.values[i];
            }
            return null;
        }

        SimpleIntKeyedMap<T> put(int key, T value) {
            for (int i = 0; i < this.n; ++i) {
                if (this.keys[i] != key) continue;
                this.values[i] = value;
                return this;
            }
            if (this.n == this.keys.length) {
                int[] newKeys = new int[this.keys.length * 2];
                System.arraycopy(this.keys, 0, newKeys, 0, this.n);
                Object[] newValues = new Object[this.keys.length * 2];
                System.arraycopy(this.values, 0, newValues, 0, this.n);
                this.keys = newKeys;
                this.values = newValues;
            }
            this.keys[this.n] = key;
            this.values[this.n] = value;
            ++this.n;
            return this;
        }

        public boolean equals(Object o) {
            if (o instanceof SimpleIntKeyedMap) {
                SimpleIntKeyedMap other = (SimpleIntKeyedMap)o;
                if (this.n == other.n) {
                    for (int i = 0; i < this.n; ++i) {
                        Object value1 = this.values[i];
                        T value2 = other.get(this.keys[i]);
                        if (Objects.equals(value1, value2)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder("{");
            for (int i = 0; i < this.n; ++i) {
                s2.append(this.keys[i]).append("=").append(this.values[i] == null ? "null" : this.values[i].toString());
            }
            s2.append("}");
            return s2.toString();
        }
    }

    static final class CounterValue {
        long count;
        final LDValue flagValue;

        CounterValue(long count, LDValue flagValue) {
            this.count = count;
            this.flagValue = flagValue;
        }

        void increment() {
            ++this.count;
        }

        public boolean equals(Object other) {
            if (other instanceof CounterValue) {
                CounterValue o = (CounterValue)other;
                return this.count == o.count && Objects.equals(this.flagValue, o.flagValue);
            }
            return false;
        }

        public String toString() {
            return "(" + this.count + "," + this.flagValue + ")";
        }
    }

    static final class FlagInfo {
        final LDValue defaultVal;
        final SimpleIntKeyedMap<SimpleIntKeyedMap<CounterValue>> versionsAndVariations;

        FlagInfo(LDValue defaultVal, SimpleIntKeyedMap<SimpleIntKeyedMap<CounterValue>> versionsAndVariations) {
            this.defaultVal = defaultVal;
            this.versionsAndVariations = versionsAndVariations;
        }

        public boolean equals(Object other) {
            if (other instanceof FlagInfo) {
                FlagInfo o = (FlagInfo)other;
                return o.defaultVal.equals(this.defaultVal) && o.versionsAndVariations.equals(this.versionsAndVariations);
            }
            return false;
        }

        public int hashCode() {
            return this.defaultVal.hashCode() + 31 * this.versionsAndVariations.hashCode();
        }

        public String toString() {
            return "(default=" + this.defaultVal + ", counters=" + this.versionsAndVariations + ")";
        }
    }

    static final class EventSummary {
        final Map<String, FlagInfo> counters;
        long startDate;
        long endDate;

        EventSummary() {
            this.counters = new HashMap<String, FlagInfo>();
        }

        EventSummary(EventSummary from) {
            this.counters = new HashMap<String, FlagInfo>(from.counters);
            this.startDate = from.startDate;
            this.endDate = from.endDate;
        }

        boolean isEmpty() {
            return this.counters.isEmpty();
        }

        void incrementCounter(String flagKey, int variation, int version, LDValue flagValue, LDValue defaultVal) {
            CounterValue value;
            SimpleIntKeyedMap<CounterValue> variations;
            FlagInfo flagInfo = this.counters.get(flagKey);
            if (flagInfo == null) {
                flagInfo = new FlagInfo(defaultVal, new SimpleIntKeyedMap<SimpleIntKeyedMap<CounterValue>>());
                this.counters.put(flagKey, flagInfo);
            }
            if ((variations = flagInfo.versionsAndVariations.get(version)) == null) {
                variations = new SimpleIntKeyedMap();
                flagInfo.versionsAndVariations.put(version, variations);
            }
            if ((value = variations.get(variation)) == null) {
                variations.put(variation, new CounterValue(1L, flagValue));
            } else {
                value.increment();
            }
        }

        void noteTimestamp(long time) {
            if (this.startDate == 0L || time < this.startDate) {
                this.startDate = time;
            }
            if (time > this.endDate) {
                this.endDate = time;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof EventSummary) {
                EventSummary o = (EventSummary)other;
                return o.counters.equals(this.counters) && this.startDate == o.startDate && this.endDate == o.endDate;
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

