/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.EventSummarizer;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.shaded.com.google.gson.Gson;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Map;

final class EventOutputFormatter {
    private final EventsConfiguration config;
    private final Gson gson;

    EventOutputFormatter(EventsConfiguration config) {
        this.config = config;
        this.gson = JsonHelpers.gsonInstanceForEventsSerialization(config);
    }

    final int writeOutputEvents(Event[] events, EventSummarizer.EventSummary summary, Writer writer) throws IOException {
        int count = events.length;
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.beginArray();
            for (Event event : events) {
                this.writeOutputEvent(event, jsonWriter);
            }
            if (!summary.isEmpty()) {
                this.writeSummaryEvent(summary, jsonWriter);
                ++count;
            }
            jsonWriter.endArray();
        }
        return count;
    }

    private final void writeOutputEvent(Event event, JsonWriter jw) throws IOException {
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe;
            this.startEvent(fe, (fe = (Event.FeatureRequest)event).isDebug() ? "debug" : "feature", fe.getKey(), jw);
            this.writeUserOrKey(fe, fe.isDebug(), jw);
            if (fe.getVersion() >= 0) {
                jw.name("version");
                jw.value(fe.getVersion());
            }
            if (fe.getVariation() >= 0) {
                jw.name("variation");
                jw.value(fe.getVariation());
            }
            this.writeLDValue("value", fe.getValue(), jw);
            this.writeLDValue("default", fe.getDefaultVal(), jw);
            if (fe.getPrereqOf() != null) {
                jw.name("prereqOf");
                jw.value(fe.getPrereqOf());
            }
            this.writeEvaluationReason("reason", fe.getReason(), jw);
            if (!fe.getContextKind().equals("user")) {
                jw.name("contextKind").value(fe.getContextKind());
            }
        } else if (event instanceof Event.Identify) {
            this.startEvent(event, "identify", event.getUser() == null ? null : event.getUser().getKey(), jw);
            this.writeUser(event.getUser(), jw);
        } else if (event instanceof Event.Custom) {
            Event.Custom ce = (Event.Custom)event;
            this.startEvent(event, "custom", ce.getKey(), jw);
            this.writeUserOrKey(ce, false, jw);
            this.writeLDValue("data", ce.getData(), jw);
            if (!ce.getContextKind().equals("user")) {
                jw.name("contextKind").value(ce.getContextKind());
            }
            if (ce.getMetricValue() != null) {
                jw.name("metricValue");
                jw.value(ce.getMetricValue());
            }
        } else if (event instanceof Event.Index) {
            this.startEvent(event, "index", null, jw);
            this.writeUser(event.getUser(), jw);
        } else if (event instanceof Event.AliasEvent) {
            Event.AliasEvent ae = (Event.AliasEvent)event;
            this.startEvent(event, "alias", ae.getKey(), jw);
            jw.name("contextKind").value(ae.getContextKind());
            jw.name("previousKey").value(ae.getPreviousKey());
            jw.name("previousContextKind").value(ae.getPreviousContextKind());
        } else {
            return;
        }
        jw.endObject();
    }

    private final void writeSummaryEvent(EventSummarizer.EventSummary summary, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value("summary");
        jw.name("startDate");
        jw.value(summary.startDate);
        jw.name("endDate");
        jw.value(summary.endDate);
        jw.name("features");
        jw.beginObject();
        for (Map.Entry<String, EventSummarizer.FlagInfo> flag : summary.counters.entrySet()) {
            String flagKey = flag.getKey();
            EventSummarizer.FlagInfo flagInfo = flag.getValue();
            jw.name(flagKey);
            jw.beginObject();
            this.writeLDValue("default", flagInfo.defaultVal, jw);
            jw.name("counters");
            jw.beginArray();
            for (int i = 0; i < flagInfo.versionsAndVariations.size(); ++i) {
                int version = flagInfo.versionsAndVariations.keyAt(i);
                EventSummarizer.SimpleIntKeyedMap<EventSummarizer.CounterValue> variations = flagInfo.versionsAndVariations.valueAt(i);
                for (int j = 0; j < variations.size(); ++j) {
                    int variation = variations.keyAt(j);
                    EventSummarizer.CounterValue counter = variations.valueAt(j);
                    jw.beginObject();
                    if (variation >= 0) {
                        jw.name("variation").value(variation);
                    }
                    if (version >= 0) {
                        jw.name("version").value(version);
                    } else {
                        jw.name("unknown").value(true);
                    }
                    this.writeLDValue("value", counter.flagValue, jw);
                    jw.name("count").value(counter.count);
                    jw.endObject();
                }
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }

    private final void startEvent(Event event, String kind, String key, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value(kind);
        jw.name("creationDate");
        jw.value(event.getCreationDate());
        if (key != null) {
            jw.name("key");
            jw.value(key);
        }
    }

    private final void writeUserOrKey(Event event, boolean forceInline, JsonWriter jw) throws IOException {
        LDUser user = event.getUser();
        if (user != null) {
            if (this.config.inlineUsersInEvents || forceInline) {
                this.writeUser(user, jw);
            } else {
                jw.name("userKey");
                jw.value(user.getKey());
            }
        }
    }

    private final void writeUser(LDUser user, JsonWriter jw) throws IOException {
        jw.name("user");
        this.gson.toJson((Object)user, (Type)((Object)LDUser.class), jw);
    }

    private final void writeLDValue(String key, LDValue value, JsonWriter jw) throws IOException {
        if (value == null || value.isNull()) {
            return;
        }
        jw.name(key);
        this.gson.toJson((Object)value, (Type)((Object)LDValue.class), jw);
    }

    private final void writeEvaluationReason(String key, EvaluationReason er, JsonWriter jw) throws IOException {
        if (er == null) {
            return;
        }
        jw.name(key);
        this.gson.toJson((Object)er, (Type)((Object)EvaluationReason.class), jw);
    }
}

