/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractMap;

abstract class DataModelSerialization {
    DataModelSerialization() {
    }

    static DataModel.VersionedData deserializeFromParsedJson(DataStoreTypes.DataKind kind, JsonElement parsedJson) throws SerializationException {
        DataModel.VersionedData item;
        block4: {
            try {
                if (kind == DataModel.FEATURES) {
                    item = JsonHelpers.gsonInstance().fromJson(parsedJson, DataModel.FeatureFlag.class);
                    break block4;
                }
                if (kind == DataModel.SEGMENTS) {
                    item = JsonHelpers.gsonInstance().fromJson(parsedJson, DataModel.Segment.class);
                    break block4;
                }
                throw new IllegalArgumentException("unknown data kind");
            }
            catch (RuntimeException e) {
                throw new SerializationException(e);
            }
        }
        return item;
    }

    static DataModel.VersionedData deserializeFromJsonReader(DataStoreTypes.DataKind kind, JsonReader jr) throws SerializationException {
        DataModel.VersionedData item;
        block4: {
            try {
                if (kind == DataModel.FEATURES) {
                    item = (DataModel.VersionedData)JsonHelpers.gsonInstance().fromJson(jr, (Type)((Object)DataModel.FeatureFlag.class));
                    break block4;
                }
                if (kind == DataModel.SEGMENTS) {
                    item = (DataModel.VersionedData)JsonHelpers.gsonInstance().fromJson(jr, (Type)((Object)DataModel.Segment.class));
                    break block4;
                }
                throw new IllegalArgumentException("unknown data kind");
            }
            catch (RuntimeException e) {
                throw new SerializationException(e);
            }
        }
        return item;
    }

    static DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> parseFullDataSet(JsonReader jr) throws SerializationException {
        ImmutableList.Builder flags = ImmutableList.builder();
        ImmutableList.Builder segments = ImmutableList.builder();
        try {
            jr.beginObject();
            block11: while (jr.peek() != JsonToken.END_OBJECT) {
                ImmutableList.Builder listBuilder;
                Class itemClass;
                String kindName;
                switch (kindName = jr.nextName()) {
                    case "flags": {
                        itemClass = DataModel.FeatureFlag.class;
                        listBuilder = flags;
                        break;
                    }
                    case "segments": {
                        itemClass = DataModel.Segment.class;
                        listBuilder = segments;
                        break;
                    }
                    default: {
                        jr.skipValue();
                        continue block11;
                    }
                }
                jr.beginObject();
                while (jr.peek() != JsonToken.END_OBJECT) {
                    String key = jr.nextName();
                    DataModel.FeatureFlag item = JsonHelpers.deserialize(jr, itemClass);
                    listBuilder.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(key, new DataStoreTypes.ItemDescriptor(((DataModel.VersionedData)item).getVersion(), item)));
                }
                jr.endObject();
            }
            jr.endObject();
            return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(ImmutableMap.of(DataModel.FEATURES, new DataStoreTypes.KeyedItems(flags.build()), DataModel.SEGMENTS, new DataStoreTypes.KeyedItems(segments.build())).entrySet());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        catch (RuntimeException e) {
            throw new SerializationException(e);
        }
    }
}

