/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class BigSegmentStoreTypes {
    private BigSegmentStoreTypes() {
    }

    public static Membership createMembershipFromSegmentRefs(Iterable<String> includedSegmentRefs, Iterable<String> excludedSegmentRefs) {
        MembershipBuilder membershipBuilder = new MembershipBuilder();
        membershipBuilder.addRefs(excludedSegmentRefs, false);
        membershipBuilder.addRefs(includedSegmentRefs, true);
        return membershipBuilder.build();
    }

    private static class MembershipBuilder {
        private boolean nonEmpty;
        private String firstValue;
        private boolean firstValueIncluded;
        private HashMap<String, Boolean> map;

        private MembershipBuilder() {
        }

        void addRefs(Iterable<String> segmentRefs, boolean included) {
            if (segmentRefs == null) {
                return;
            }
            for (String s2 : segmentRefs) {
                if (s2 == null) continue;
                if (this.nonEmpty) {
                    if (this.map == null) {
                        this.map = new HashMap();
                        this.map.put(this.firstValue, this.firstValueIncluded);
                    }
                    this.map.put(s2, included);
                    continue;
                }
                this.firstValue = s2;
                this.firstValueIncluded = included;
                this.nonEmpty = true;
            }
        }

        Membership build() {
            if (this.nonEmpty) {
                if (this.map != null) {
                    return new MapMembership(this.map);
                }
                return new SingleValueMembership(this.firstValue, this.firstValueIncluded);
            }
            return EmptyMembership.instance;
        }

        private static final class MapMembership
        implements Membership {
            private final Map<String, Boolean> map;

            private MapMembership(Map<String, Boolean> map) {
                this.map = map;
            }

            @Override
            public Boolean checkMembership(String segmentRef) {
                return this.map.get(segmentRef);
            }

            public boolean equals(Object o) {
                return o instanceof MapMembership && this.map.equals(((MapMembership)o).map);
            }

            public int hashCode() {
                return Objects.hash(this.map);
            }
        }

        private static final class SingleValueMembership
        implements Membership {
            private final String segmentRef;
            private final boolean included;

            SingleValueMembership(String segmentRef, boolean included) {
                this.segmentRef = segmentRef;
                this.included = included;
            }

            @Override
            public Boolean checkMembership(String segmentRef) {
                return this.segmentRef.equals(segmentRef) ? Boolean.valueOf(this.included) : null;
            }

            public boolean equals(Object o) {
                if (!(o instanceof SingleValueMembership)) {
                    return false;
                }
                SingleValueMembership other = (SingleValueMembership)o;
                return this.segmentRef.equals(other.segmentRef) && this.included == other.included;
            }

            public int hashCode() {
                return this.segmentRef.hashCode() + (this.included ? 1 : 0);
            }
        }

        private static final class EmptyMembership
        implements Membership {
            static final EmptyMembership instance = new EmptyMembership();

            private EmptyMembership() {
            }

            @Override
            public Boolean checkMembership(String segmentRef) {
                return null;
            }

            public boolean equals(Object o) {
                return o instanceof EmptyMembership;
            }

            public int hashCode() {
                return 0;
            }
        }
    }

    public static final class StoreMetadata {
        private final long lastUpToDate;

        public StoreMetadata(long lastUpToDate) {
            this.lastUpToDate = lastUpToDate;
        }

        public long getLastUpToDate() {
            return this.lastUpToDate;
        }
    }

    public static interface Membership {
        public Boolean checkMembership(String var1);
    }
}

