/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.interfaces.Event;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class EventSummarizer {
    private EventSummary eventsState = new EventSummary();

    EventSummarizer() {
    }

    void summarizeEvent(Event event) {
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe = (Event.FeatureRequest)event;
            this.eventsState.incrementCounter(fe.getKey(), fe.getVariation(), fe.getVersion(), fe.getValue(), fe.getDefaultVal());
            this.eventsState.noteTimestamp(fe.getCreationDate());
        }
    }

    EventSummary snapshot() {
        return new EventSummary(this.eventsState);
    }

    void clear() {
        this.eventsState = new EventSummary();
    }

    static final class CounterValue {
        long count;
        final LDValue flagValue;
        final LDValue defaultVal;

        CounterValue(long count, LDValue flagValue, LDValue defaultVal) {
            this.count = count;
            this.flagValue = flagValue;
            this.defaultVal = defaultVal;
        }

        void increment() {
            ++this.count;
        }

        public boolean equals(Object other) {
            if (other instanceof CounterValue) {
                CounterValue o = (CounterValue)other;
                return this.count == o.count && Objects.equals(this.flagValue, o.flagValue) && Objects.equals(this.defaultVal, o.defaultVal);
            }
            return false;
        }

        public String toString() {
            return "(" + this.count + "," + this.flagValue + "," + this.defaultVal + ")";
        }
    }

    static final class CounterKey {
        final String key;
        final int variation;
        final int version;

        CounterKey(String key, int variation, int version) {
            this.key = key;
            this.variation = variation;
            this.version = version;
        }

        public boolean equals(Object other) {
            if (other instanceof CounterKey) {
                CounterKey o = (CounterKey)other;
                return o.key.equals(this.key) && o.variation == this.variation && o.version == this.version;
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode() + 31 * (this.variation + 31 * this.version);
        }

        public String toString() {
            return "(" + this.key + "," + this.variation + "," + this.version + ")";
        }
    }

    static final class EventSummary {
        final Map<CounterKey, CounterValue> counters;
        long startDate;
        long endDate;

        EventSummary() {
            this.counters = new HashMap<CounterKey, CounterValue>();
        }

        EventSummary(EventSummary from) {
            this.counters = new HashMap<CounterKey, CounterValue>(from.counters);
            this.startDate = from.startDate;
            this.endDate = from.endDate;
        }

        boolean isEmpty() {
            return this.counters.isEmpty();
        }

        void incrementCounter(String flagKey, int variation, int version, LDValue flagValue, LDValue defaultVal) {
            CounterKey key = new CounterKey(flagKey, variation, version);
            CounterValue value = this.counters.get(key);
            if (value != null) {
                value.increment();
            } else {
                this.counters.put(key, new CounterValue(1L, flagValue, defaultVal));
            }
        }

        void noteTimestamp(long time) {
            if (this.startDate == 0L || time < this.startDate) {
                this.startDate = time;
            }
            if (time > this.endDate) {
                this.endDate = time;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof EventSummary) {
                EventSummary o = (EventSummary)other;
                return o.counters.equals(this.counters) && this.startDate == o.startDate && this.endDate == o.endDate;
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

