/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.shaded.org.apache.commons.codec.digest.DigestUtils;

abstract class EvaluatorBucketing {
    private static final float LONG_SCALE = 1.1529215E18f;

    private EvaluatorBucketing() {
    }

    static float bucketUser(Integer seed, LDUser user, String key, UserAttribute attr, String salt) {
        LDValue userValue = user.getAttribute(attr == null ? UserAttribute.KEY : attr);
        String idHash = EvaluatorBucketing.getBucketableStringValue(userValue);
        if (idHash != null) {
            String prefix = seed != null ? seed.toString() : key + "." + salt;
            if (user.getSecondary() != null) {
                idHash = idHash + "." + user.getSecondary();
            }
            String hash = DigestUtils.sha1Hex(prefix + "." + idHash).substring(0, 15);
            long longVal = Long.parseLong(hash, 16);
            return (float)longVal / 1.1529215E18f;
        }
        return 0.0f;
    }

    private static String getBucketableStringValue(LDValue userValue) {
        switch (userValue.getType()) {
            case STRING: {
                return userValue.stringValue();
            }
            case NUMBER: {
                return userValue.isInt() ? String.valueOf(userValue.intValue()) : null;
            }
        }
        return null;
    }
}

