/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.ComponentsImpl;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceFactory;
import com.launchdarkly.sdk.server.interfaces.DataStoreFactory;
import com.launchdarkly.sdk.server.interfaces.EventProcessorFactory;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStoreFactory;

public abstract class Components {
    private Components() {
    }

    public static DataStoreFactory inMemoryDataStore() {
        return ComponentsImpl.InMemoryDataStoreFactory.INSTANCE;
    }

    public static PersistentDataStoreBuilder persistentDataStore(PersistentDataStoreFactory storeFactory) {
        return new ComponentsImpl.PersistentDataStoreBuilderImpl(storeFactory);
    }

    public static EventProcessorBuilder sendEvents() {
        return new ComponentsImpl.EventProcessorBuilderImpl();
    }

    public static EventProcessorFactory noEvents() {
        return ComponentsImpl.NULL_EVENT_PROCESSOR_FACTORY;
    }

    static boolean isNullImplementation(EventProcessorFactory f) {
        return f == ComponentsImpl.NULL_EVENT_PROCESSOR_FACTORY;
    }

    public static StreamingDataSourceBuilder streamingDataSource() {
        return new ComponentsImpl.StreamingDataSourceBuilderImpl();
    }

    public static PollingDataSourceBuilder pollingDataSource() {
        return new ComponentsImpl.PollingDataSourceBuilderImpl();
    }

    static ComponentsImpl.PollingDataSourceBuilderImpl pollingDataSourceInternal() {
        return new ComponentsImpl.PollingDataSourceBuilderImpl();
    }

    public static DataSourceFactory externalUpdatesOnly() {
        return ComponentsImpl.NullDataSourceFactory.INSTANCE;
    }

    public static HttpConfigurationBuilder httpConfiguration() {
        return new ComponentsImpl.HttpConfigurationBuilderImpl();
    }

    public static HttpAuthentication httpBasicAuthentication(String username, String password) {
        return new ComponentsImpl.HttpBasicAuthentication(username, password);
    }

    public static LoggingConfigurationBuilder logging() {
        return new ComponentsImpl.LoggingConfigurationBuilderImpl();
    }
}

