/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.json.GsonReaderAdapter;
import com.launchdarkly.sdk.json.GsonWriterAdapter;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.google.gson.Gson;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class JsonSerialization {
    static final List<Class<? extends JsonSerializable>> knownDeserializableClasses = new ArrayList<Class<? extends JsonSerializable>>();
    private static final Gson gson = new Gson();

    private JsonSerialization() {
    }

    public static <T extends JsonSerializable> String serialize(T instance) {
        return JsonSerialization.serializeInternal(instance);
    }

    static String serializeInternal(Object instance) {
        return gson.toJson(instance);
    }

    public static <T extends JsonSerializable> T deserialize(String json, Class<T> objectClass) throws SerializationException {
        return (T)((JsonSerializable)JsonSerialization.deserializeInternal(json, objectClass));
    }

    static <T> T deserializeInternal(String json, Class<T> objectClass) throws SerializationException {
        try {
            return gson.fromJson(json, objectClass);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    static void serializeToGsonInternal(Object value, Class<?> type, GsonWriterAdapter writer) {
        gson.toJson(value, type, writer);
    }

    static <T> T deserializeFromGsonInternal(GsonReaderAdapter adapter, Type type) {
        return gson.fromJson(adapter, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterable<Class<? extends JsonSerializable>> getDeserializableClasses() {
        List<Class<? extends JsonSerializable>> list = knownDeserializableClasses;
        synchronized (list) {
            if (knownDeserializableClasses.isEmpty()) {
                knownDeserializableClasses.add(EvaluationReason.class);
                knownDeserializableClasses.add(EvaluationDetail.class);
                knownDeserializableClasses.add(LDUser.class);
                knownDeserializableClasses.add(LDValue.class);
                knownDeserializableClasses.add(UserAttribute.class);
                try {
                    Class<?> sdkExtensionsClass = Class.forName("com/launchdarkly/shaded/com.launchdarkly.sdk.json.SdkSerializationExtensions");
                    Method method = sdkExtensionsClass.getMethod("getDeserializableClasses", new Class[0]);
                    Iterable sdkClasses = (Iterable)method.invoke(null, new Object[0]);
                    for (Class c : sdkClasses) {
                        knownDeserializableClasses.add(c);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return knownDeserializableClasses;
    }
}

