/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.server.DiagnosticId;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.interfaces.BasicConfiguration;
import com.launchdarkly.sdk.server.interfaces.DiagnosticDescription;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import java.util.List;
import java.util.Map;

class DiagnosticEvent {
    final String kind;
    final long creationDate;
    final DiagnosticId id;

    DiagnosticEvent(String kind, long creationDate, DiagnosticId id) {
        this.kind = kind;
        this.creationDate = creationDate;
        this.id = id;
    }

    static class Init
    extends DiagnosticEvent {
        final DiagnosticSdk sdk;
        final LDValue configuration;
        final DiagnosticPlatform platform = new DiagnosticPlatform();

        Init(long creationDate, DiagnosticId diagnosticId, LDConfig config, BasicConfiguration basicConfig, HttpConfiguration httpConfig) {
            super("diagnostic-init", creationDate, diagnosticId);
            this.sdk = new DiagnosticSdk(httpConfig);
            this.configuration = Init.getConfigurationData(config, basicConfig, httpConfig);
        }

        static LDValue getConfigurationData(LDConfig config, BasicConfiguration basicConfig, HttpConfiguration httpConfig) {
            ObjectBuilder builder = LDValue.buildObject();
            builder.put("connectTimeoutMillis", httpConfig.getConnectTimeout().toMillis());
            builder.put("socketTimeoutMillis", httpConfig.getSocketTimeout().toMillis());
            builder.put("usingProxy", httpConfig.getProxy() != null);
            builder.put("usingProxyAuthenticator", httpConfig.getProxyAuthentication() != null);
            builder.put("startWaitMillis", config.startWait.toMillis());
            Init.mergeComponentProperties(builder, config.dataStoreFactory, basicConfig, "dataStoreType");
            Init.mergeComponentProperties(builder, config.dataSourceFactory, basicConfig, null);
            Init.mergeComponentProperties(builder, config.eventProcessorFactory, basicConfig, null);
            return builder.build();
        }

        private static void mergeComponentProperties(ObjectBuilder builder, Object component, BasicConfiguration basicConfig, String defaultPropertyName) {
            if (!(component instanceof DiagnosticDescription)) {
                if (defaultPropertyName != null) {
                    builder.put(defaultPropertyName, "custom");
                }
                return;
            }
            LDValue componentDesc = LDValue.normalize(((DiagnosticDescription)component).describeConfiguration(basicConfig));
            if (defaultPropertyName != null) {
                builder.put(defaultPropertyName, componentDesc.isString() ? componentDesc.stringValue() : "custom");
            } else if (componentDesc.getType() == LDValueType.OBJECT) {
                for (String key : componentDesc.keys()) {
                    for (ConfigProperty prop : ConfigProperty.values()) {
                        LDValue value;
                        if (!prop.name.equals(key) || (value = componentDesc.get(key)).getType() != prop.type) continue;
                        builder.put(key, value);
                    }
                }
            }
        }

        static class DiagnosticPlatform {
            private final String name = "Java";
            private final String javaVendor = System.getProperty("java.vendor");
            private final String javaVersion = System.getProperty("java.version");
            private final String osArch = System.getProperty("os.arch");
            final String osName = DiagnosticPlatform.normalizeOsName(System.getProperty("os.name"));
            private final String osVersion = System.getProperty("os.version");

            DiagnosticPlatform() {
            }

            private static String normalizeOsName(String osName) {
                if (osName != null) {
                    if (osName.equals("Mac OS X")) {
                        return "MacOS";
                    }
                    if (osName.startsWith("Windows")) {
                        return "Windows";
                    }
                }
                return osName;
            }
        }

        static class DiagnosticSdk {
            final String name = "java-server-sdk";
            final String version = "5.3.0";
            final String wrapperName;
            final String wrapperVersion;

            DiagnosticSdk(HttpConfiguration httpConfig) {
                for (Map.Entry<String, String> headers : httpConfig.getDefaultHeaders()) {
                    if (!headers.getKey().equalsIgnoreCase("X-LaunchDarkly-Wrapper")) continue;
                    String id = headers.getValue();
                    if (id.indexOf("/") >= 0) {
                        this.wrapperName = id.substring(0, id.indexOf("/"));
                        this.wrapperVersion = id.substring(id.indexOf("/") + 1);
                    } else {
                        this.wrapperName = id;
                        this.wrapperVersion = null;
                    }
                    return;
                }
                this.wrapperName = null;
                this.wrapperVersion = null;
            }
        }
    }

    static class Statistics
    extends DiagnosticEvent {
        final long dataSinceDate;
        final long droppedEvents;
        final long deduplicatedUsers;
        final long eventsInLastBatch;
        final List<StreamInit> streamInits;

        Statistics(long creationDate, DiagnosticId id, long dataSinceDate, long droppedEvents, long deduplicatedUsers, long eventsInLastBatch, List<StreamInit> streamInits) {
            super("diagnostic", creationDate, id);
            this.dataSinceDate = dataSinceDate;
            this.droppedEvents = droppedEvents;
            this.deduplicatedUsers = deduplicatedUsers;
            this.eventsInLastBatch = eventsInLastBatch;
            this.streamInits = streamInits;
        }
    }

    static class StreamInit {
        long timestamp;
        long durationMillis;
        boolean failed;

        StreamInit(long timestamp, long durationMillis, boolean failed) {
            this.timestamp = timestamp;
            this.durationMillis = durationMillis;
            this.failed = failed;
        }
    }

    static enum ConfigProperty {
        ALL_ATTRIBUTES_PRIVATE("allAttributesPrivate", LDValueType.BOOLEAN),
        CUSTOM_BASE_URI("customBaseURI", LDValueType.BOOLEAN),
        CUSTOM_EVENTS_URI("customEventsURI", LDValueType.BOOLEAN),
        CUSTOM_STREAM_URI("customStreamURI", LDValueType.BOOLEAN),
        DIAGNOSTIC_RECORDING_INTERVAL_MILLIS("diagnosticRecordingIntervalMillis", LDValueType.NUMBER),
        EVENTS_CAPACITY("eventsCapacity", LDValueType.NUMBER),
        EVENTS_FLUSH_INTERVAL_MILLIS("eventsFlushIntervalMillis", LDValueType.NUMBER),
        INLINE_USERS_IN_EVENTS("inlineUsersInEvents", LDValueType.BOOLEAN),
        POLLING_INTERVAL_MILLIS("pollingIntervalMillis", LDValueType.NUMBER),
        RECONNECT_TIME_MILLIS("reconnectTimeMillis", LDValueType.NUMBER),
        SAMPLING_INTERVAL("samplingInterval", LDValueType.NUMBER),
        STREAMING_DISABLED("streamingDisabled", LDValueType.BOOLEAN),
        USER_KEYS_CAPACITY("userKeysCapacity", LDValueType.NUMBER),
        USER_KEYS_FLUSH_INTERVAL_MILLIS("userKeysFlushIntervalMillis", LDValueType.NUMBER),
        USING_RELAY_DAEMON("usingRelayDaemon", LDValueType.BOOLEAN);

        String name;
        LDValueType type;

        private ConfigProperty(String name, LDValueType type) {
            this.name = name;
            this.type = type;
        }
    }
}

