/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.HttpConnectStrategy;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamException;
import com.launchdarkly.shaded.okhttp3.HttpUrl;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class ConnectStrategy {
    public abstract Client createClient(LDLogger var1);

    public static HttpConnectStrategy http(URI uri) {
        return new HttpConnectStrategy(uri);
    }

    public static HttpConnectStrategy http(URL url) {
        try {
            return new HttpConnectStrategy(url == null ? null : url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HttpConnectStrategy http(HttpUrl url) {
        return new HttpConnectStrategy(url == null ? null : url.uri());
    }

    public static abstract class Client
    implements Closeable {
        public abstract Result connect(String var1) throws StreamException;

        public abstract boolean awaitClosed(long var1) throws InterruptedException;

        public abstract URI getOrigin();

        public static class Result {
            private final InputStream inputStream;
            private final URI origin;
            private final Closeable closer;

            public Result(InputStream inputStream2, URI origin, Closeable closer) {
                this.inputStream = inputStream2;
                this.origin = origin;
                this.closer = closer;
            }

            public InputStream getInputStream() {
                return this.inputStream;
            }

            public URI getOrigin() {
                return this.origin;
            }

            public Closeable getCloser() {
                return this.closer;
            }
        }
    }
}

