/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.interfaces;

import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class DataStoreTypes {
    private DataStoreTypes() {
    }

    public static final class KeyedItems<TDescriptor> {
        private final Iterable<Map.Entry<String, TDescriptor>> items;

        public Iterable<Map.Entry<String, TDescriptor>> getItems() {
            return this.items;
        }

        public KeyedItems(Iterable<Map.Entry<String, TDescriptor>> items) {
            this.items = items == null ? ImmutableList.of() : items;
        }

        public boolean equals(Object o) {
            return o instanceof KeyedItems && this.items.equals(((KeyedItems)o).items);
        }

        public int hashCode() {
            return this.items.hashCode();
        }
    }

    public static final class FullDataSet<TDescriptor> {
        private final Iterable<Map.Entry<DataKind, KeyedItems<TDescriptor>>> data;

        public Iterable<Map.Entry<DataKind, KeyedItems<TDescriptor>>> getData() {
            return this.data;
        }

        public FullDataSet(Iterable<Map.Entry<DataKind, KeyedItems<TDescriptor>>> data) {
            this.data = data == null ? ImmutableList.of() : data;
        }

        public boolean equals(Object o) {
            return o instanceof FullDataSet && this.data.equals(((FullDataSet)o).data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }

    public static final class SerializedItemDescriptor {
        private final int version;
        private final boolean deleted;
        private final String serializedItem;

        public int getVersion() {
            return this.version;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public String getSerializedItem() {
            return this.serializedItem;
        }

        public SerializedItemDescriptor(int version, boolean deleted, String serializedItem) {
            this.version = version;
            this.deleted = deleted;
            this.serializedItem = serializedItem;
        }

        public boolean equals(Object o) {
            if (o instanceof SerializedItemDescriptor) {
                SerializedItemDescriptor other = (SerializedItemDescriptor)o;
                return this.version == other.version && this.deleted == other.deleted && Objects.equals(this.serializedItem, other.serializedItem);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.version, this.deleted, this.serializedItem);
        }

        public String toString() {
            return "SerializedItemDescriptor(" + this.version + "," + this.deleted + "," + this.serializedItem + ")";
        }
    }

    public static final class ItemDescriptor {
        private final int version;
        private final Object item;

        public int getVersion() {
            return this.version;
        }

        public Object getItem() {
            return this.item;
        }

        public ItemDescriptor(int version, Object item) {
            this.version = version;
            this.item = item;
        }

        public static ItemDescriptor deletedItem(int version) {
            return new ItemDescriptor(version, null);
        }

        public boolean equals(Object o) {
            if (o instanceof ItemDescriptor) {
                ItemDescriptor other = (ItemDescriptor)o;
                return this.version == other.version && Objects.equals(this.item, other.item);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.version, this.item);
        }

        public String toString() {
            return "ItemDescriptor(" + this.version + "," + this.item + ")";
        }
    }

    public static final class DataKind {
        private final String name;
        private final Function<ItemDescriptor, String> serializer;
        private final Function<String, ItemDescriptor> deserializer;

        public String getName() {
            return this.name;
        }

        public String serialize(ItemDescriptor item) {
            return this.serializer.apply(item);
        }

        public ItemDescriptor deserialize(String s2) {
            return this.deserializer.apply(s2);
        }

        public DataKind(String name, Function<ItemDescriptor, String> serializer, Function<String, ItemDescriptor> deserializer) {
            this.name = name;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public String toString() {
            return "DataKind(" + this.name + ")";
        }
    }
}

