/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.HttpConfigurationFactory;
import java.time.Duration;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public abstract class HttpConfigurationBuilder
implements HttpConfigurationFactory {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(2L);
    public static final Duration DEFAULT_SOCKET_TIMEOUT = Duration.ofSeconds(10L);
    protected Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    protected HttpAuthentication proxyAuth;
    protected String proxyHost;
    protected int proxyPort;
    protected Duration socketTimeout = DEFAULT_SOCKET_TIMEOUT;
    protected SocketFactory socketFactory;
    protected SSLSocketFactory sslSocketFactory;
    protected X509TrustManager trustManager;
    protected String wrapperName;
    protected String wrapperVersion;

    public HttpConfigurationBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout == null ? DEFAULT_CONNECT_TIMEOUT : connectTimeout;
        return this;
    }

    public HttpConfigurationBuilder proxyHostAndPort(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        return this;
    }

    public HttpConfigurationBuilder proxyAuth(HttpAuthentication strategy) {
        this.proxyAuth = strategy;
        return this;
    }

    public HttpConfigurationBuilder socketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout == null ? DEFAULT_SOCKET_TIMEOUT : socketTimeout;
        return this;
    }

    public HttpConfigurationBuilder socketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    public HttpConfigurationBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
        return this;
    }

    public HttpConfigurationBuilder wrapper(String wrapperName, String wrapperVersion) {
        this.wrapperName = wrapperName;
        this.wrapperVersion = wrapperVersion;
        return this;
    }
}

