/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.interfaces.BigSegmentStore;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreFactory;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.interfaces.ClientContext;
import java.time.Duration;

public final class BigSegmentsConfigurationBuilder {
    public static final int DEFAULT_USER_CACHE_SIZE = 1000;
    public static final Duration DEFAULT_USER_CACHE_TIME = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_STATUS_POLL_INTERVAL = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_STALE_AFTER = Duration.ofMinutes(2L);
    private final BigSegmentStoreFactory storeFactory;
    private int userCacheSize = 1000;
    private Duration userCacheTime = DEFAULT_USER_CACHE_TIME;
    private Duration statusPollInterval = DEFAULT_STATUS_POLL_INTERVAL;
    private Duration staleAfter = DEFAULT_STALE_AFTER;

    public BigSegmentsConfigurationBuilder(BigSegmentStoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public BigSegmentsConfigurationBuilder userCacheSize(int userCacheSize) {
        this.userCacheSize = Math.max(userCacheSize, 0);
        return this;
    }

    public BigSegmentsConfigurationBuilder userCacheTime(Duration userCacheTime) {
        this.userCacheTime = userCacheTime != null && userCacheTime.compareTo(Duration.ZERO) >= 0 ? userCacheTime : DEFAULT_USER_CACHE_TIME;
        return this;
    }

    public BigSegmentsConfigurationBuilder statusPollInterval(Duration statusPollInterval) {
        this.statusPollInterval = statusPollInterval != null && statusPollInterval.compareTo(Duration.ZERO) > 0 ? statusPollInterval : DEFAULT_STATUS_POLL_INTERVAL;
        return this;
    }

    public BigSegmentsConfigurationBuilder staleAfter(Duration staleAfter) {
        this.staleAfter = staleAfter != null && staleAfter.compareTo(Duration.ZERO) > 0 ? staleAfter : DEFAULT_STALE_AFTER;
        return this;
    }

    public BigSegmentsConfiguration createBigSegmentsConfiguration(ClientContext context) {
        BigSegmentStore store = this.storeFactory == null ? null : this.storeFactory.createBigSegmentStore(context);
        return new BigSegmentsConfiguration(store, this.userCacheSize, this.userCacheTime, this.statusPollInterval, this.staleAfter);
    }
}

