/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.interfaces.Event;
import java.util.function.Supplier;

abstract class EventFactory {
    public static final EventFactory DEFAULT = new Default(false, null);
    public static final EventFactory DEFAULT_WITH_REASONS = new Default(true, null);

    EventFactory() {
    }

    abstract Event.FeatureRequest newFeatureRequestEvent(DataModel.FeatureFlag var1, LDUser var2, LDValue var3, int var4, EvaluationReason var5, boolean var6, LDValue var7, String var8);

    abstract Event.FeatureRequest newUnknownFeatureRequestEvent(String var1, LDUser var2, LDValue var3, EvaluationReason.ErrorKind var4);

    abstract Event.Custom newCustomEvent(String var1, LDUser var2, LDValue var3, Double var4);

    abstract Event.Identify newIdentifyEvent(LDUser var1);

    abstract Event.AliasEvent newAliasEvent(LDUser var1, LDUser var2);

    final Event.FeatureRequest newFeatureRequestEvent(DataModel.FeatureFlag flag, LDUser user, EvalResult result, LDValue defaultValue) {
        return this.newFeatureRequestEvent(flag, user, result == null ? null : result.getValue(), result == null ? -1 : result.getVariationIndex(), result == null ? null : result.getReason(), result != null && result.isForceReasonTracking(), defaultValue, null);
    }

    final Event.FeatureRequest newDefaultFeatureRequestEvent(DataModel.FeatureFlag flag, LDUser user, LDValue defaultVal, EvaluationReason.ErrorKind errorKind) {
        return this.newFeatureRequestEvent(flag, user, defaultVal, -1, EvaluationReason.error(errorKind), false, defaultVal, null);
    }

    final Event.FeatureRequest newPrerequisiteFeatureRequestEvent(DataModel.FeatureFlag prereqFlag, LDUser user, EvalResult result, DataModel.FeatureFlag prereqOf) {
        return this.newFeatureRequestEvent(prereqFlag, user, result == null ? null : result.getValue(), result == null ? -1 : result.getVariationIndex(), result == null ? null : result.getReason(), result != null && result.isForceReasonTracking(), LDValue.ofNull(), prereqOf.getKey());
    }

    static final Event.FeatureRequest newDebugEvent(Event.FeatureRequest from) {
        return new Event.FeatureRequest(from.getCreationDate(), from.getKey(), from.getUser(), from.getVersion(), from.getVariation(), from.getValue(), from.getDefaultVal(), from.getReason(), from.getPrereqOf(), from.isTrackEvents(), from.getDebugEventsUntilDate(), true);
    }

    static final class Disabled
    extends EventFactory {
        static final Disabled INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        final Event.FeatureRequest newFeatureRequestEvent(DataModel.FeatureFlag flag, LDUser user, LDValue value, int variationIndex, EvaluationReason reason, boolean inExperiment, LDValue defaultValue, String prereqOf) {
            return null;
        }

        @Override
        final Event.FeatureRequest newUnknownFeatureRequestEvent(String key, LDUser user, LDValue defaultValue, EvaluationReason.ErrorKind errorKind) {
            return null;
        }

        @Override
        final Event.Custom newCustomEvent(String key, LDUser user, LDValue data, Double metricValue) {
            return null;
        }

        @Override
        final Event.Identify newIdentifyEvent(LDUser user) {
            return null;
        }

        @Override
        Event.AliasEvent newAliasEvent(LDUser user, LDUser previousUser) {
            return null;
        }
    }

    static class Default
    extends EventFactory {
        private final boolean includeReasons;
        private final Supplier<Long> timestampFn;

        Default(boolean includeReasons, Supplier<Long> timestampFn) {
            this.includeReasons = includeReasons;
            this.timestampFn = timestampFn != null ? timestampFn : () -> System.currentTimeMillis();
        }

        @Override
        final Event.FeatureRequest newFeatureRequestEvent(DataModel.FeatureFlag flag, LDUser user, LDValue value, int variationIndex, EvaluationReason reason, boolean forceReasonTracking, LDValue defaultValue, String prereqOf) {
            return new Event.FeatureRequest(this.timestampFn.get(), flag.getKey(), user, flag.getVersion(), variationIndex, value, defaultValue, forceReasonTracking || this.includeReasons ? reason : null, prereqOf, forceReasonTracking || flag.isTrackEvents(), flag.getDebugEventsUntilDate() == null ? 0L : flag.getDebugEventsUntilDate(), false);
        }

        @Override
        final Event.FeatureRequest newUnknownFeatureRequestEvent(String key, LDUser user, LDValue defaultValue, EvaluationReason.ErrorKind errorKind) {
            return new Event.FeatureRequest(this.timestampFn.get(), key, user, -1, -1, defaultValue, defaultValue, this.includeReasons ? EvaluationReason.error(errorKind) : null, null, false, 0L, false);
        }

        @Override
        Event.Custom newCustomEvent(String key, LDUser user, LDValue data, Double metricValue) {
            return new Event.Custom(this.timestampFn.get(), key, user, data, metricValue);
        }

        @Override
        Event.Identify newIdentifyEvent(LDUser user) {
            return new Event.Identify(this.timestampFn.get(), user);
        }

        @Override
        Event.AliasEvent newAliasEvent(LDUser user, LDUser previousUser) {
            return new Event.AliasEvent(this.timestampFn.get(), user, previousUser);
        }
    }
}

