/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorBucketing;
import com.launchdarkly.sdk.server.EvaluatorHelpers;
import com.launchdarkly.sdk.server.EvaluatorOperators;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreTypes;
import java.util.List;
import java.util.Set;

class Evaluator {
    static final String INVALID_FLAG_KEY_THAT_THROWS_EXCEPTION = "$ test error flag $";
    static final RuntimeException EXPECTED_EXCEPTION_FROM_INVALID_FLAG = new RuntimeException("deliberate test error");
    private final Getters getters;
    private final LDLogger logger;

    Evaluator(Getters getters, LDLogger logger) {
        this.getters = getters;
        this.logger = logger;
    }

    EvalResult evaluate(DataModel.FeatureFlag flag, LDUser user, PrerequisiteEvaluationSink prereqEvals) {
        if (flag.getKey() == INVALID_FLAG_KEY_THAT_THROWS_EXCEPTION) {
            throw EXPECTED_EXCEPTION_FROM_INVALID_FLAG;
        }
        if (user == null || user.getKey() == null) {
            this.logger.warn("Null user or null user key when evaluating flag \"{}\"; returning null", (Object)flag.getKey());
            return EvalResult.error(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED);
        }
        EvaluatorState state = new EvaluatorState();
        EvalResult result = this.evaluateInternal(flag, user, prereqEvals, state);
        if (state.bigSegmentsStatus != null) {
            return result.withReason(result.getReason().withBigSegmentsStatus(state.bigSegmentsStatus));
        }
        return result;
    }

    private EvalResult evaluateInternal(DataModel.FeatureFlag flag, LDUser user, PrerequisiteEvaluationSink prereqEvals, EvaluatorState state) {
        if (!flag.isOn()) {
            return EvaluatorHelpers.offResult(flag);
        }
        EvalResult prereqFailureResult = this.checkPrerequisites(flag, user, prereqEvals, state);
        if (prereqFailureResult != null) {
            return prereqFailureResult;
        }
        List<DataModel.Target> targets = flag.getTargets();
        int nTargets = targets.size();
        for (int i = 0; i < nTargets; ++i) {
            DataModel.Target target = targets.get(i);
            if (!target.getValues().contains(user.getKey())) continue;
            return EvaluatorHelpers.targetMatchResult(flag, target);
        }
        List<DataModel.Rule> rules = flag.getRules();
        int nRules = rules.size();
        for (int i = 0; i < nRules; ++i) {
            DataModel.Rule rule = rules.get(i);
            if (!this.ruleMatchesUser(flag, rule, user, state)) continue;
            return this.computeRuleMatch(flag, user, rule, i);
        }
        return this.getValueForVariationOrRollout(flag, flag.getFallthrough(), user, flag.preprocessed == null ? null : flag.preprocessed.fallthroughResults, EvaluationReason.fallthrough());
    }

    private EvalResult checkPrerequisites(DataModel.FeatureFlag flag, LDUser user, PrerequisiteEvaluationSink prereqEvals, EvaluatorState state) {
        List<DataModel.Prerequisite> prerequisites = flag.getPrerequisites();
        int nPrerequisites = prerequisites.size();
        for (int i = 0; i < nPrerequisites; ++i) {
            DataModel.Prerequisite prereq = prerequisites.get(i);
            boolean prereqOk = true;
            DataModel.FeatureFlag prereqFeatureFlag = this.getters.getFlag(prereq.getKey());
            if (prereqFeatureFlag == null) {
                this.logger.error("Could not retrieve prerequisite flag \"{}\" when evaluating \"{}\"", (Object)prereq.getKey(), (Object)flag.getKey());
                prereqOk = false;
            } else {
                EvalResult prereqEvalResult = this.evaluateInternal(prereqFeatureFlag, user, prereqEvals, state);
                if (!prereqFeatureFlag.isOn() || prereqEvalResult.getVariationIndex() != prereq.getVariation()) {
                    prereqOk = false;
                }
                if (prereqEvals != null) {
                    prereqEvals.recordPrerequisiteEvaluation(prereqFeatureFlag, flag, user, prereqEvalResult);
                }
            }
            if (prereqOk) continue;
            return EvaluatorHelpers.prerequisiteFailedResult(flag, prereq);
        }
        return null;
    }

    private EvalResult getValueForVariationOrRollout(DataModel.FeatureFlag flag, DataModel.VariationOrRollout vr, LDUser user, DataModelPreprocessing.EvalResultFactoryMultiVariations precomputedResults, EvaluationReason reason) {
        int variation = -1;
        boolean inExperiment = false;
        Integer maybeVariation = vr.getVariation();
        if (maybeVariation != null) {
            variation = maybeVariation;
        } else {
            DataModel.Rollout rollout = vr.getRollout();
            if (rollout != null && !rollout.getVariations().isEmpty()) {
                float bucket = EvaluatorBucketing.bucketUser(rollout.getSeed(), user, flag.getKey(), rollout.getBucketBy(), flag.getSalt());
                float sum = 0.0f;
                List<DataModel.WeightedVariation> variations = rollout.getVariations();
                int nVariations = variations.size();
                for (int i = 0; i < nVariations; ++i) {
                    DataModel.WeightedVariation wv = variations.get(i);
                    if (!(bucket < (sum += (float)wv.getWeight() / 100000.0f))) continue;
                    variation = wv.getVariation();
                    inExperiment = vr.getRollout().isExperiment() && !wv.isUntracked();
                    break;
                }
                if (variation < 0) {
                    DataModel.WeightedVariation lastVariation = rollout.getVariations().get(rollout.getVariations().size() - 1);
                    variation = lastVariation.getVariation();
                    boolean bl = inExperiment = vr.getRollout().isExperiment() && !lastVariation.isUntracked();
                }
            }
        }
        if (variation < 0) {
            this.logger.error("Data inconsistency in feature flag \"{}\": variation/rollout object with no variation or rollout", (Object)flag.getKey());
            return EvalResult.error(EvaluationReason.ErrorKind.MALFORMED_FLAG);
        }
        if (precomputedResults != null) {
            return precomputedResults.forVariation(variation, inExperiment);
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForVariation(flag, variation, inExperiment ? Evaluator.experimentize(reason) : reason));
    }

    private static EvaluationReason experimentize(EvaluationReason reason) {
        if (reason.getKind() == EvaluationReason.Kind.FALLTHROUGH) {
            return EvaluationReason.fallthrough(true);
        }
        if (reason.getKind() == EvaluationReason.Kind.RULE_MATCH) {
            return EvaluationReason.ruleMatch(reason.getRuleIndex(), reason.getRuleId(), true);
        }
        return reason;
    }

    private boolean ruleMatchesUser(DataModel.FeatureFlag flag, DataModel.Rule rule, LDUser user, EvaluatorState state) {
        List<DataModel.Clause> clauses = rule.getClauses();
        int nClauses = clauses.size();
        for (int i = 0; i < nClauses; ++i) {
            DataModel.Clause clause = clauses.get(i);
            if (this.clauseMatchesUser(clause, user, state)) continue;
            return false;
        }
        return true;
    }

    private boolean clauseMatchesUser(DataModel.Clause clause, LDUser user, EvaluatorState state) {
        if (clause.getOp() == DataModel.Operator.segmentMatch) {
            List<LDValue> values2 = clause.getValues();
            int nValues = values2.size();
            for (int i = 0; i < nValues; ++i) {
                DataModel.Segment segment;
                LDValue clauseValue = values2.get(i);
                if (!clauseValue.isString() || (segment = this.getters.getSegment(clauseValue.stringValue())) == null || !this.segmentMatchesUser(segment, user, state)) continue;
                return this.maybeNegate(clause, true);
            }
            return this.maybeNegate(clause, false);
        }
        return this.clauseMatchesUserNoSegments(clause, user);
    }

    private boolean clauseMatchesUserNoSegments(DataModel.Clause clause, LDUser user) {
        LDValue userValue = user.getAttribute(clause.getAttribute());
        if (userValue.isNull()) {
            return false;
        }
        if (userValue.getType() == LDValueType.ARRAY) {
            int nValues = userValue.size();
            for (int i = 0; i < nValues; ++i) {
                LDValue value = userValue.get(i);
                if (value.getType() == LDValueType.ARRAY || value.getType() == LDValueType.OBJECT) {
                    this.logger.error("Invalid custom attribute value in user object for user key \"{}\": {}", (Object)user.getKey(), (Object)value);
                    return false;
                }
                if (!Evaluator.clauseMatchAny(clause, value)) continue;
                return this.maybeNegate(clause, true);
            }
            return this.maybeNegate(clause, false);
        }
        if (userValue.getType() != LDValueType.OBJECT) {
            return this.maybeNegate(clause, Evaluator.clauseMatchAny(clause, userValue));
        }
        this.logger.warn("Got unexpected user attribute type \"{}\" for user key \"{}\" and attribute \"{}\"", new Object[]{userValue.getType(), user.getKey(), clause.getAttribute()});
        return false;
    }

    static boolean clauseMatchAny(DataModel.Clause clause, LDValue userValue) {
        DataModel.Operator op = clause.getOp();
        if (op != null) {
            DataModelPreprocessing.ClausePreprocessed preprocessed = clause.preprocessed;
            if (op == DataModel.Operator.in) {
                Set<LDValue> vs;
                Set<LDValue> set = vs = preprocessed == null ? null : preprocessed.valuesSet;
                if (vs != null) {
                    return vs.contains(userValue);
                }
            }
            List<LDValue> values2 = clause.getValues();
            List<DataModelPreprocessing.ClausePreprocessed.ValueData> preprocessedValues = preprocessed == null ? null : preprocessed.valuesExtra;
            int n = values2.size();
            for (int i = 0; i < n; ++i) {
                DataModelPreprocessing.ClausePreprocessed.ValueData p = preprocessedValues == null ? null : preprocessedValues.get(i);
                LDValue v = values2.get(i);
                if (!EvaluatorOperators.apply(op, userValue, v, p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean maybeNegate(DataModel.Clause clause, boolean b) {
        return clause.isNegate() ? !b : b;
    }

    private boolean segmentMatchesUser(DataModel.Segment segment, LDUser user, EvaluatorState state) {
        String userKey = user.getKey();
        if (segment.isUnbounded()) {
            Boolean membership;
            if (segment.getGeneration() == null) {
                state.bigSegmentsStatus = EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED;
                return false;
            }
            if (state.bigSegmentsStatus == null) {
                BigSegmentStoreWrapper.BigSegmentsQueryResult queryResult = this.getters.getBigSegments(user.getKey());
                if (queryResult == null) {
                    state.bigSegmentsStatus = EvaluationReason.BigSegmentsStatus.NOT_CONFIGURED;
                } else {
                    state.bigSegmentsStatus = queryResult.status;
                    state.bigSegmentsMembership = queryResult.membership;
                }
            }
            Boolean bl = membership = state.bigSegmentsMembership == null ? null : state.bigSegmentsMembership.checkMembership(Evaluator.makeBigSegmentRef(segment));
            if (membership != null) {
                return membership;
            }
        } else {
            if (segment.getIncluded().contains(userKey)) {
                return true;
            }
            if (segment.getExcluded().contains(userKey)) {
                return false;
            }
        }
        List<DataModel.SegmentRule> rules = segment.getRules();
        int nRules = rules.size();
        for (int i = 0; i < nRules; ++i) {
            DataModel.SegmentRule rule = rules.get(i);
            if (!this.segmentRuleMatchesUser(rule, user, segment.getKey(), segment.getSalt())) continue;
            return true;
        }
        return false;
    }

    private boolean segmentRuleMatchesUser(DataModel.SegmentRule segmentRule, LDUser user, String segmentKey, String salt) {
        double weight;
        List<DataModel.Clause> clauses = segmentRule.getClauses();
        int nClauses = clauses.size();
        for (int i = 0; i < nClauses; ++i) {
            DataModel.Clause c = clauses.get(i);
            if (this.clauseMatchesUserNoSegments(c, user)) continue;
            return false;
        }
        if (segmentRule.getWeight() == null) {
            return true;
        }
        double bucket = EvaluatorBucketing.bucketUser(null, user, segmentKey, segmentRule.getBucketBy(), salt);
        return bucket < (weight = (double)segmentRule.getWeight().intValue() / 100000.0);
    }

    private EvalResult computeRuleMatch(DataModel.FeatureFlag flag, LDUser user, DataModel.Rule rule, int ruleIndex) {
        if (rule.preprocessed != null) {
            return this.getValueForVariationOrRollout(flag, rule, user, rule.preprocessed.allPossibleResults, null);
        }
        EvaluationReason reason = EvaluationReason.ruleMatch(ruleIndex, rule.getId());
        return this.getValueForVariationOrRollout(flag, rule, user, null, reason);
    }

    static String makeBigSegmentRef(DataModel.Segment segment) {
        return String.format("%s.g%d", segment.getKey(), segment.getGeneration());
    }

    private static class EvaluatorState {
        private BigSegmentStoreTypes.Membership bigSegmentsMembership = null;
        private EvaluationReason.BigSegmentsStatus bigSegmentsStatus = null;

        private EvaluatorState() {
        }
    }

    static interface PrerequisiteEvaluationSink {
        public void recordPrerequisiteEvaluation(DataModel.FeatureFlag var1, DataModel.FeatureFlag var2, LDUser var3, EvalResult var4);
    }

    static interface Getters {
        public DataModel.FeatureFlag getFlag(String var1);

        public DataModel.Segment getSegment(String var1);

        public BigSegmentStoreWrapper.BigSegmentsQueryResult getBigSegments(String var1);
    }
}

