/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.redis.clients.jedis;

import com.launchdarkly.shaded.redis.clients.jedis.Client;
import com.launchdarkly.shaded.redis.clients.jedis.Protocol;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisConnectionException;
import com.launchdarkly.shaded.redis.clients.jedis.exceptions.JedisException;
import com.launchdarkly.shaded.redis.clients.util.SafeEncoder;
import java.util.Arrays;
import java.util.List;

public abstract class JedisPubSub {
    private int subscribedChannels = 0;
    private volatile Client client;

    public void onMessage(String channel, String message) {
    }

    public void onPMessage(String pattern, String channel, String message) {
    }

    public void onSubscribe(String channel, int subscribedChannels) {
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
    }

    public void onPUnsubscribe(String pattern, int subscribedChannels) {
    }

    public void onPSubscribe(String pattern, int subscribedChannels) {
    }

    public void onPong(String pattern) {
    }

    public void unsubscribe() {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub was not subscribed to a Jedis instance.");
        }
        this.client.unsubscribe();
        this.client.flush();
    }

    public void unsubscribe(String ... channels) {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub is not subscribed to a Jedis instance.");
        }
        this.client.unsubscribe(channels);
        this.client.flush();
    }

    public void subscribe(String ... channels) {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub is not subscribed to a Jedis instance.");
        }
        this.client.subscribe(channels);
        this.client.flush();
    }

    public void psubscribe(String ... patterns) {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub is not subscribed to a Jedis instance.");
        }
        this.client.psubscribe(patterns);
        this.client.flush();
    }

    public void punsubscribe() {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub is not subscribed to a Jedis instance.");
        }
        this.client.punsubscribe();
        this.client.flush();
    }

    public void punsubscribe(String ... patterns) {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub is not subscribed to a Jedis instance.");
        }
        this.client.punsubscribe(patterns);
        this.client.flush();
    }

    public void ping() {
        if (this.client == null) {
            throw new JedisConnectionException("JedisPubSub is not subscribed to a Jedis instance.");
        }
        this.client.ping();
        this.client.flush();
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Client client, String ... patterns) {
        this.client = client;
        client.psubscribe(patterns);
        client.flush();
        this.process(client);
    }

    public void proceed(Client client, String ... channels) {
        this.client = client;
        client.subscribe(channels);
        client.flush();
        this.process(client);
    }

    private void process(Client client) {
        do {
            String strpattern;
            byte[] bpattern;
            String strchannel;
            byte[] bchannel;
            List<Object> reply;
            Object firstObj;
            if (!((firstObj = (reply = client.getRawObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + firstObj);
            }
            byte[] resp = (byte[])firstObj;
            if (Arrays.equals(Protocol.Keyword.SUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                strchannel = bchannel == null ? null : SafeEncoder.encode(bchannel);
                this.onSubscribe(strchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.UNSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                strchannel = bchannel == null ? null : SafeEncoder.encode(bchannel);
                this.onUnsubscribe(strchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.MESSAGE.raw, resp)) {
                bchannel = (byte[])reply.get(1);
                byte[] bmesg = (byte[])reply.get(2);
                String strchannel2 = bchannel == null ? null : SafeEncoder.encode(bchannel);
                String strmesg = bmesg == null ? null : SafeEncoder.encode(bmesg);
                this.onMessage(strchannel2, strmesg);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PMESSAGE.raw, resp)) {
                bpattern = (byte[])reply.get(1);
                byte[] bchannel2 = (byte[])reply.get(2);
                byte[] bmesg = (byte[])reply.get(3);
                String strpattern2 = bpattern == null ? null : SafeEncoder.encode(bpattern);
                String strchannel3 = bchannel2 == null ? null : SafeEncoder.encode(bchannel2);
                String strmesg = bmesg == null ? null : SafeEncoder.encode(bmesg);
                this.onPMessage(strpattern2, strchannel3, strmesg);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPSubscribe(strpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PUNSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPUnsubscribe(strpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PONG.raw, resp)) {
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPong(strpattern);
                continue;
            }
            throw new JedisException("Unknown message type: " + firstObj);
        } while (this.isSubscribed());
        this.client = null;
        client.resetPipelinedCount();
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

