/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.value;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.LDValueTypeAdapter;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;

@JsonAdapter(value=LDValueTypeAdapter.class)
final class LDValueObject
extends LDValue {
    private static final LDValueObject EMPTY = new LDValueObject(ImmutableMap.of());
    private final Map<String, LDValue> map;

    static LDValueObject fromMap(Map<String, LDValue> map) {
        return map.isEmpty() ? EMPTY : new LDValueObject(map);
    }

    private LDValueObject(Map<String, LDValue> map) {
        this.map = map;
    }

    @Override
    public LDValueType getType() {
        return LDValueType.OBJECT;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Iterable<String> keys() {
        return this.map.keySet();
    }

    @Override
    public Iterable<LDValue> values() {
        return this.map.values();
    }

    @Override
    public LDValue get(String name) {
        LDValue v = this.map.get(name);
        return v == null ? LDValueObject.ofNull() : v;
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, LDValue> e : this.map.entrySet()) {
            writer.name(e.getKey());
            e.getValue().write(writer);
        }
        writer.endObject();
    }

    @Override
    JsonElement computeJsonElement() {
        JsonObject o = new JsonObject();
        for (String key : this.map.keySet()) {
            o.add(key, this.map.get(key).asUnsafeJsonElement());
        }
        return o;
    }
}

