/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.utils;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.interfaces.SerializationException;

public abstract class FeatureStoreHelpers {
    private static final Gson gson = new Gson();

    public static <T extends VersionedData> T unmarshalJson(VersionedDataKind<T> kind, String data) {
        try {
            return (T)((VersionedData)gson.fromJson(data, kind.getItemClass()));
        }
        catch (JsonParseException e) {
            throw new UnmarshalException(e);
        }
    }

    public static String marshalJson(VersionedData item) {
        return gson.toJson((Object)item);
    }

    public static class UnmarshalException
    extends SerializationException {
        public UnmarshalException(Throwable cause) {
            super(cause);
        }
    }
}

