/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.integrations.RedisDataStoreBuilder;
import com.launchdarkly.client.utils.FeatureStoreCore;
import com.launchdarkly.client.utils.FeatureStoreHelpers;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPool;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.Transaction;
import com.launchdarkly.shaded.redis.clients.util.JedisURIHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RedisDataStoreImpl
implements FeatureStoreCore {
    private static final Logger logger = LoggerFactory.getLogger(RedisDataStoreImpl.class);
    private final JedisPool pool;
    private final String prefix;
    private UpdateListener updateListener;

    RedisDataStoreImpl(RedisDataStoreBuilder builder) {
        String extra;
        String host = builder.uri.getHost();
        int port = builder.uri.getPort();
        String password = builder.password == null ? JedisURIHelper.getPassword(builder.uri) : builder.password;
        int database = builder.database == null ? JedisURIHelper.getDBIndex(builder.uri) : builder.database;
        boolean tls = builder.tls || builder.uri.getScheme().equals("com.launchdarkly.shaded.rediss");
        String string = extra = tls ? " with TLS" : "";
        if (password != null) {
            extra = extra + (extra.isEmpty() ? " with" : " and") + " password";
        }
        logger.info(String.format("Connecting to Redis feature store at %s:%d/%d%s", host, port, database, extra));
        JedisPoolConfig poolConfig = builder.poolConfig != null ? builder.poolConfig : new JedisPoolConfig();
        JedisPool pool = new JedisPool(poolConfig, host, port, builder.connectTimeout, builder.socketTimeout, password, database, null, tls, null, null, null);
        String prefix = builder.prefix == null || builder.prefix.isEmpty() ? "launchdarkly" : builder.prefix;
        this.pool = pool;
        this.prefix = prefix;
    }

    @Override
    public VersionedData getInternal(VersionedDataKind<?> kind, String key) {
        try (Jedis jedis = this.pool.getResource();){
            Object item = this.getRedis(kind, key, jedis);
            if (item != null) {
                logger.debug("[get] Key: {} with version: {} found in \"{}\".", new Object[]{key, item.getVersion(), kind.getNamespace()});
            }
            Object obj = item;
            return obj;
        }
    }

    @Override
    public Map<String, VersionedData> getAllInternal(VersionedDataKind<?> kind) {
        try (Jedis jedis = this.pool.getResource();){
            Map<String, String> allJson = jedis.hgetAll(this.itemsKey(kind));
            HashMap result = new HashMap();
            for (Map.Entry<String, String> entry : allJson.entrySet()) {
                Object item = FeatureStoreHelpers.unmarshalJson(kind, entry.getValue());
                result.put(entry.getKey(), item);
            }
            HashMap<String, ?> hashMap = result;
            return hashMap;
        }
    }

    @Override
    public void initInternal(Map<VersionedDataKind<?>, Map<String, VersionedData>> allData) {
        try (Jedis jedis = this.pool.getResource();){
            Transaction t = jedis.multi();
            for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> entry : allData.entrySet()) {
                String baseKey = this.itemsKey(entry.getKey());
                t.del(baseKey);
                for (VersionedData item : entry.getValue().values()) {
                    t.hset(baseKey, item.getKey(), FeatureStoreHelpers.marshalJson(item));
                }
            }
            t.set(this.initedKey(), "");
            t.exec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedData upsertInternal(VersionedDataKind<?> kind, VersionedData newItem) {
        while (true) {
            Jedis jedis = null;
            try {
                Object oldItem;
                jedis = this.pool.getResource();
                String baseKey = this.itemsKey(kind);
                jedis.watch(baseKey);
                if (this.updateListener != null) {
                    this.updateListener.aboutToUpdate(baseKey, newItem.getKey());
                }
                if ((oldItem = this.getRedis(kind, newItem.getKey(), jedis)) != null && oldItem.getVersion() >= newItem.getVersion()) {
                    logger.debug("Attempted to {} key: {} version: {} with a version that is the same or older: {} in \"{}\"", new Object[]{newItem.isDeleted() ? "delete" : "update", newItem.getKey(), oldItem.getVersion(), newItem.getVersion(), kind.getNamespace()});
                    Object obj = oldItem;
                    return obj;
                }
                Transaction tx = jedis.multi();
                tx.hset(baseKey, newItem.getKey(), FeatureStoreHelpers.marshalJson(newItem));
                List<Object> result = tx.exec();
                if (result.isEmpty()) {
                    logger.debug("Concurrent modification detected, retrying");
                    continue;
                }
                VersionedData versionedData = newItem;
                return versionedData;
            }
            finally {
                if (jedis == null) continue;
                jedis.unwatch();
                jedis.close();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean initializedInternal() {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.exists(this.initedKey());
            return bl;
        }
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly RedisFeatureStore");
        this.pool.destroy();
    }

    @VisibleForTesting
    void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    private String itemsKey(VersionedDataKind<?> kind) {
        return this.prefix + ":" + kind.getNamespace();
    }

    private String initedKey() {
        return this.prefix + ":$inited";
    }

    private <T extends VersionedData> T getRedis(VersionedDataKind<T> kind, String key, Jedis jedis) {
        String json = jedis.hget(this.itemsKey(kind), key);
        if (json == null) {
            logger.debug("[get] Key: {} not found in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
            return null;
        }
        return FeatureStoreHelpers.unmarshalJson(kind, json);
    }

    static interface UpdateListener {
        public void aboutToUpdate(String var1, String var2);
    }
}

