/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.launchdarkly.client.FeatureStoreCacheConfig;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.integrations.CacheMonitor;
import com.launchdarkly.client.interfaces.DiagnosticDescription;
import com.launchdarkly.client.interfaces.PersistentDataStoreFactory;
import java.util.concurrent.TimeUnit;

public abstract class PersistentDataStoreBuilder
implements FeatureStoreFactory,
DiagnosticDescription {
    public static final int DEFAULT_CACHE_TTL_SECONDS = 15;
    protected final PersistentDataStoreFactory persistentDataStoreFactory;
    protected FeatureStoreCacheConfig caching = FeatureStoreCacheConfig.DEFAULT;
    protected CacheMonitor cacheMonitor = null;

    protected PersistentDataStoreBuilder(PersistentDataStoreFactory persistentDataStoreFactory) {
        this.persistentDataStoreFactory = persistentDataStoreFactory;
    }

    public PersistentDataStoreBuilder noCaching() {
        return this.cacheTime(0L, TimeUnit.MILLISECONDS);
    }

    public PersistentDataStoreBuilder cacheTime(long cacheTime, TimeUnit cacheTimeUnit) {
        this.caching = this.caching.ttl(cacheTime, cacheTimeUnit);
        return this;
    }

    public PersistentDataStoreBuilder cacheMillis(long millis) {
        return this.cacheTime(millis, TimeUnit.MILLISECONDS);
    }

    public PersistentDataStoreBuilder cacheSeconds(long seconds) {
        return this.cacheTime(seconds, TimeUnit.SECONDS);
    }

    public PersistentDataStoreBuilder cacheForever() {
        return this.cacheTime(-1L, TimeUnit.MILLISECONDS);
    }

    public PersistentDataStoreBuilder staleValuesPolicy(StaleValuesPolicy staleValuesPolicy) {
        this.caching = this.caching.staleValuesPolicy(FeatureStoreCacheConfig.StaleValuesPolicy.fromNewEnum(staleValuesPolicy));
        return this;
    }

    public PersistentDataStoreBuilder cacheMonitor(CacheMonitor cacheMonitor) {
        this.cacheMonitor = cacheMonitor;
        return this;
    }

    public static enum StaleValuesPolicy {
        EVICT,
        REFRESH,
        REFRESH_ASYNC;

    }
}

