/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.org.apache.commons.codec.digest.DigestUtils;
import java.util.List;

class VariationOrRollout {
    private static final float long_scale = 1.1529215E18f;
    private Integer variation;
    private Rollout rollout;

    VariationOrRollout() {
    }

    VariationOrRollout(Integer variation, Rollout rollout) {
        this.variation = variation;
        this.rollout = rollout;
    }

    Integer getVariation() {
        return this.variation;
    }

    Rollout getRollout() {
        return this.rollout;
    }

    Integer variationIndexForUser(LDUser user, String key, String salt) {
        if (this.variation != null) {
            return this.variation;
        }
        if (this.rollout != null && this.rollout.variations != null && !this.rollout.variations.isEmpty()) {
            String bucketBy = this.rollout.bucketBy == null ? "key" : this.rollout.bucketBy;
            float bucket = VariationOrRollout.bucketUser(user, key, bucketBy, salt);
            float sum = 0.0f;
            for (WeightedVariation wv : this.rollout.variations) {
                if (!(bucket < (sum += (float)wv.weight / 100000.0f))) continue;
                return wv.variation;
            }
            return ((WeightedVariation)this.rollout.variations.get(this.rollout.variations.size() - 1)).variation;
        }
        return null;
    }

    static float bucketUser(LDUser user, String key, String attr, String salt) {
        LDValue userValue = user.getValueForEvaluation(attr);
        String idHash = VariationOrRollout.getBucketableStringValue(userValue);
        if (idHash != null) {
            if (!user.getSecondary().isNull()) {
                idHash = idHash + "." + user.getSecondary().stringValue();
            }
            String hash = DigestUtils.sha1Hex(key + "." + salt + "." + idHash).substring(0, 15);
            long longVal = Long.parseLong(hash, 16);
            return (float)longVal / 1.1529215E18f;
        }
        return 0.0f;
    }

    private static String getBucketableStringValue(LDValue userValue) {
        switch (userValue.getType()) {
            case STRING: {
                return userValue.stringValue();
            }
            case NUMBER: {
                return userValue.isInt() ? String.valueOf(userValue.intValue()) : null;
            }
        }
        return null;
    }

    static final class WeightedVariation {
        private int variation;
        private int weight;

        WeightedVariation() {
        }

        WeightedVariation(int variation, int weight) {
            this.variation = variation;
            this.weight = weight;
        }

        int getVariation() {
            return this.variation;
        }

        int getWeight() {
            return this.weight;
        }
    }

    static final class Rollout {
        private List<WeightedVariation> variations;
        private String bucketBy;

        Rollout() {
        }

        Rollout(List<WeightedVariation> variations, String bucketBy) {
            this.variations = variations;
            this.bucketBy = bucketBy;
        }

        List<WeightedVariation> getVariations() {
            return this.variations;
        }

        String getBucketBy() {
            return this.bucketBy;
        }
    }
}

