/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.DiagnosticEvent;
import com.launchdarkly.client.DiagnosticId;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

class DiagnosticAccumulator {
    final DiagnosticId diagnosticId;
    volatile long dataSinceDate;
    private final AtomicInteger eventsInLastBatch = new AtomicInteger(0);
    private final Object streamInitsLock = new Object();
    private ArrayList<DiagnosticEvent.StreamInit> streamInits = new ArrayList();

    DiagnosticAccumulator(DiagnosticId diagnosticId) {
        this.diagnosticId = diagnosticId;
        this.dataSinceDate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordStreamInit(long timestamp, long durationMillis, boolean failed) {
        Object object = this.streamInitsLock;
        synchronized (object) {
            this.streamInits.add(new DiagnosticEvent.StreamInit(timestamp, durationMillis, failed));
        }
    }

    void recordEventsInBatch(int eventsInBatch) {
        this.eventsInLastBatch.set(eventsInBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiagnosticEvent.Statistics createEventAndReset(long droppedEvents, long deduplicatedUsers) {
        ArrayList<DiagnosticEvent.StreamInit> eventInits;
        long currentTime = System.currentTimeMillis();
        Object object = this.streamInitsLock;
        synchronized (object) {
            eventInits = this.streamInits;
            this.streamInits = new ArrayList();
        }
        long eventsInBatch = this.eventsInLastBatch.getAndSet(0);
        DiagnosticEvent.Statistics res = new DiagnosticEvent.Statistics(currentTime, this.diagnosticId, this.dataSinceDate, droppedEvents, deduplicatedUsers, eventsInBatch, eventInits);
        this.dataSinceDate = currentTime;
        return res;
    }
}

