/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.value;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.LDValueTypeAdapter;
import java.io.IOException;

@JsonAdapter(value=LDValueTypeAdapter.class)
final class LDValueNumber
extends LDValue {
    private static final LDValueNumber ZERO = new LDValueNumber(0.0);
    private final double value;

    static LDValueNumber fromDouble(double value) {
        return value == 0.0 ? ZERO : new LDValueNumber(value);
    }

    private LDValueNumber(double value) {
        this.value = value;
    }

    @Override
    public LDValueType getType() {
        return LDValueType.NUMBER;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isInt() {
        return LDValueNumber.isInteger(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public String toJsonString() {
        return this.isInt() ? String.valueOf(this.intValue()) : String.valueOf(this.value);
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        if (this.isInt()) {
            writer.value((long)this.intValue());
        } else {
            writer.value(this.value);
        }
    }

    @Override
    JsonElement computeJsonElement() {
        return new JsonPrimitive((Number)this.value);
    }
}

