/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import java.util.Objects;
import java.util.concurrent.Callable;

public final class CacheMonitor {
    private Callable<CacheStats> source;

    @Deprecated
    public void setSource(Callable<CacheStats> source) {
        this.source = source;
    }

    public CacheStats getCacheStats() {
        try {
            return this.source == null ? null : this.source.call();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final class CacheStats {
        private final long hitCount;
        private final long missCount;
        private final long loadSuccessCount;
        private final long loadExceptionCount;
        private final long totalLoadTime;
        private final long evictionCount;

        public CacheStats(long hitCount, long missCount, long loadSuccessCount, long loadExceptionCount, long totalLoadTime, long evictionCount) {
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.loadSuccessCount = loadSuccessCount;
            this.loadExceptionCount = loadExceptionCount;
            this.totalLoadTime = totalLoadTime;
            this.evictionCount = evictionCount;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getMissCount() {
            return this.missCount;
        }

        public long getLoadSuccessCount() {
            return this.loadSuccessCount;
        }

        public long getLoadExceptionCount() {
            return this.loadExceptionCount;
        }

        public long getTotalLoadTime() {
            return this.totalLoadTime;
        }

        public long getEvictionCount() {
            return this.evictionCount;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CacheStats)) {
                return false;
            }
            CacheStats o = (CacheStats)other;
            return this.hitCount == o.hitCount && this.missCount == o.missCount && this.loadSuccessCount == o.loadSuccessCount && this.loadExceptionCount == o.loadExceptionCount && this.totalLoadTime == o.totalLoadTime && this.evictionCount == o.evictionCount;
        }

        public int hashCode() {
            return Objects.hash(this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount);
        }

        public String toString() {
            return "{hit=" + this.hitCount + ", miss=" + this.missCount + ", loadSuccess=" + this.loadSuccessCount + ", loadException=" + this.loadExceptionCount + ", totalLoadTime=" + this.totalLoadTime + ", evictionCount=" + this.evictionCount + "}";
        }
    }
}

