/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Components;
import com.launchdarkly.client.FeatureStoreCacheConfig;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.RedisFeatureStore;
import com.launchdarkly.client.integrations.CacheMonitor;
import com.launchdarkly.client.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.client.integrations.Redis;
import com.launchdarkly.client.integrations.RedisDataStoreBuilder;
import com.launchdarkly.client.interfaces.DiagnosticDescription;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

@Deprecated
public final class RedisFeatureStoreBuilder
implements FeatureStoreFactory,
DiagnosticDescription {
    public static final URI DEFAULT_URI = RedisDataStoreBuilder.DEFAULT_URI;
    public static final String DEFAULT_PREFIX = "launchdarkly";
    public static final long DEFAULT_CACHE_TIME_SECONDS = 15L;
    final PersistentDataStoreBuilder wrappedOuterBuilder;
    final RedisDataStoreBuilder wrappedBuilder = Redis.dataStore();
    boolean refreshStaleValues = false;
    boolean asyncRefresh = false;

    RedisFeatureStoreBuilder() {
        this.wrappedOuterBuilder = Components.persistentDataStore(this.wrappedBuilder);
        this.wrappedOuterBuilder.cacheMonitor(new CacheMonitor());
    }

    RedisFeatureStoreBuilder(URI uri) {
        this();
        this.wrappedBuilder.uri(uri);
    }

    public RedisFeatureStoreBuilder(URI uri, long cacheTimeSecs) {
        this();
        this.wrappedBuilder.uri(uri);
        this.wrappedOuterBuilder.cacheSeconds(cacheTimeSecs);
    }

    public RedisFeatureStoreBuilder(String scheme, String host, int port, long cacheTimeSecs) throws URISyntaxException {
        this();
        this.wrappedBuilder.uri(new URI(scheme, null, host, port, null, null, null));
        this.wrappedOuterBuilder.cacheSeconds(cacheTimeSecs);
    }

    public RedisFeatureStoreBuilder database(Integer database) {
        this.wrappedBuilder.database(database);
        return this;
    }

    public RedisFeatureStoreBuilder password(String password) {
        this.wrappedBuilder.password(password);
        return this;
    }

    public RedisFeatureStoreBuilder tls(boolean tls) {
        this.wrappedBuilder.tls(tls);
        return this;
    }

    public RedisFeatureStoreBuilder caching(FeatureStoreCacheConfig caching) {
        this.wrappedOuterBuilder.cacheTime(caching.getCacheTime(), caching.getCacheTimeUnit());
        this.wrappedOuterBuilder.staleValuesPolicy(caching.getStaleValuesPolicy().toNewEnum());
        return this;
    }

    public RedisFeatureStoreBuilder refreshStaleValues(boolean enabled) {
        this.refreshStaleValues = enabled;
        this.updateCachingStaleValuesPolicy();
        return this;
    }

    public RedisFeatureStoreBuilder asyncRefresh(boolean enabled) {
        this.asyncRefresh = enabled;
        this.updateCachingStaleValuesPolicy();
        return this;
    }

    private void updateCachingStaleValuesPolicy() {
        if (this.refreshStaleValues) {
            this.wrappedOuterBuilder.staleValuesPolicy(this.asyncRefresh ? PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH_ASYNC : PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH);
        } else {
            this.wrappedOuterBuilder.staleValuesPolicy(PersistentDataStoreBuilder.StaleValuesPolicy.EVICT);
        }
    }

    public RedisFeatureStoreBuilder prefix(String prefix) {
        this.wrappedBuilder.prefix(prefix);
        return this;
    }

    public RedisFeatureStoreBuilder cacheTime(long cacheTime, TimeUnit timeUnit) {
        this.wrappedOuterBuilder.cacheTime(cacheTime, timeUnit);
        return this;
    }

    public RedisFeatureStoreBuilder poolConfig(JedisPoolConfig poolConfig) {
        this.wrappedBuilder.poolConfig(poolConfig);
        return this;
    }

    public RedisFeatureStoreBuilder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.wrappedBuilder.connectTimeout(connectTimeout, timeUnit);
        return this;
    }

    public RedisFeatureStoreBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.wrappedBuilder.socketTimeout(socketTimeout, timeUnit);
        return this;
    }

    public RedisFeatureStore build() {
        return new RedisFeatureStore(this);
    }

    @Override
    public RedisFeatureStore createFeatureStore() {
        return this.build();
    }

    @Override
    public LDValue describeConfiguration(LDConfig config) {
        return LDValue.of("Redis");
    }
}

