/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.EventsConfiguration;
import com.launchdarkly.client.JsonHelpers;
import com.launchdarkly.client.LDCountryCode;
import com.launchdarkly.client.UserAttribute;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDUser {
    private static final Logger logger = LoggerFactory.getLogger(LDUser.class);
    private final LDValue key;
    private LDValue secondary;
    private LDValue ip;
    private LDValue email;
    private LDValue name;
    private LDValue avatar;
    private LDValue firstName;
    private LDValue lastName;
    private LDValue anonymous;
    private LDValue country;
    private Map<String, LDValue> custom;
    Set<String> privateAttributeNames;

    protected LDUser(Builder builder) {
        if (builder.key == null || builder.key.equals("")) {
            logger.warn("User was created with null/empty key");
        }
        this.key = LDValue.of(builder.key);
        this.ip = LDValue.of(builder.ip);
        this.country = LDValue.of(builder.country);
        this.secondary = LDValue.of(builder.secondary);
        this.firstName = LDValue.of(builder.firstName);
        this.lastName = LDValue.of(builder.lastName);
        this.email = LDValue.of(builder.email);
        this.name = LDValue.of(builder.name);
        this.avatar = LDValue.of(builder.avatar);
        this.anonymous = builder.anonymous == null ? LDValue.ofNull() : LDValue.of(builder.anonymous);
        this.custom = builder.custom == null ? null : ImmutableMap.copyOf(builder.custom);
        this.privateAttributeNames = builder.privateAttrNames == null ? null : ImmutableSet.copyOf(builder.privateAttrNames);
    }

    public LDUser(String key) {
        this.key = LDValue.of(key);
        this.anonymous = this.country = LDValue.ofNull();
        this.lastName = this.country;
        this.firstName = this.country;
        this.avatar = this.country;
        this.name = this.country;
        this.email = this.country;
        this.ip = this.country;
        this.secondary = this.country;
        this.custom = null;
        this.privateAttributeNames = null;
    }

    protected LDValue getValueForEvaluation(String attribute) {
        for (UserAttribute builtIn : UserAttribute.values()) {
            if (!builtIn.name().equals(attribute)) continue;
            return builtIn.get(this);
        }
        return this.getCustom(attribute);
    }

    LDValue getKey() {
        return this.key;
    }

    String getKeyAsString() {
        return this.key.stringValue();
    }

    LDValue getIp() {
        return this.ip;
    }

    LDValue getCountry() {
        return this.country;
    }

    LDValue getSecondary() {
        return this.secondary;
    }

    LDValue getName() {
        return this.name;
    }

    LDValue getFirstName() {
        return this.firstName;
    }

    LDValue getLastName() {
        return this.lastName;
    }

    LDValue getEmail() {
        return this.email;
    }

    LDValue getAvatar() {
        return this.avatar;
    }

    LDValue getAnonymous() {
        return this.anonymous;
    }

    LDValue getCustom(String key) {
        if (this.custom != null) {
            return LDValue.normalize(this.custom.get(key));
        }
        return LDValue.ofNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LDUser ldUser = (LDUser)o;
        return Objects.equals(this.key, ldUser.key) && Objects.equals(this.secondary, ldUser.secondary) && Objects.equals(this.ip, ldUser.ip) && Objects.equals(this.email, ldUser.email) && Objects.equals(this.name, ldUser.name) && Objects.equals(this.avatar, ldUser.avatar) && Objects.equals(this.firstName, ldUser.firstName) && Objects.equals(this.lastName, ldUser.lastName) && Objects.equals(this.anonymous, ldUser.anonymous) && Objects.equals(this.country, ldUser.country) && Objects.equals(this.custom, ldUser.custom) && Objects.equals(this.privateAttributeNames, ldUser.privateAttributeNames);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.secondary, this.ip, this.email, this.name, this.avatar, this.firstName, this.lastName, this.anonymous, this.country, this.custom, this.privateAttributeNames);
    }

    public static class Builder {
        private String key;
        private String secondary;
        private String ip;
        private String firstName;
        private String lastName;
        private String email;
        private String name;
        private String avatar;
        private Boolean anonymous;
        private String country;
        private Map<String, LDValue> custom;
        private Set<String> privateAttrNames;

        public Builder(String key) {
            this.key = key;
        }

        public Builder(LDUser user) {
            this.key = user.getKey().stringValue();
            this.secondary = user.getSecondary().stringValue();
            this.ip = user.getIp().stringValue();
            this.firstName = user.getFirstName().stringValue();
            this.lastName = user.getLastName().stringValue();
            this.email = user.getEmail().stringValue();
            this.name = user.getName().stringValue();
            this.avatar = user.getAvatar().stringValue();
            this.anonymous = user.getAnonymous().isNull() ? null : Boolean.valueOf(user.getAnonymous().booleanValue());
            this.country = user.getCountry().stringValue();
            this.custom = user.custom == null ? null : new HashMap(user.custom);
            this.privateAttrNames = user.privateAttributeNames == null ? null : new HashSet<String>(user.privateAttributeNames);
        }

        public Builder ip(String s) {
            this.ip = s;
            return this;
        }

        public Builder privateIp(String s) {
            this.addPrivate("ip");
            return this.ip(s);
        }

        public Builder secondary(String s) {
            this.secondary = s;
            return this;
        }

        public Builder privateSecondary(String s) {
            this.addPrivate("secondary");
            return this.secondary(s);
        }

        public Builder country(String s) {
            LDCountryCode countryCode = LDCountryCode.getByCode(s, false);
            if (countryCode == null) {
                List<LDCountryCode> codes = LDCountryCode.findByName("^" + Pattern.quote(s) + ".*");
                if (codes.isEmpty()) {
                    logger.warn("Invalid country. Expected valid ISO-3166-1 code: " + s);
                } else if (codes.size() > 1) {
                    for (LDCountryCode c : codes) {
                        if (!c.getName().equals(s)) continue;
                        this.country = c.getAlpha2();
                        return this;
                    }
                    logger.warn("Ambiguous country. Provided code matches multiple countries: " + s);
                    this.country = codes.get(0).getAlpha2();
                } else {
                    this.country = codes.get(0).getAlpha2();
                }
            } else {
                this.country = countryCode.getAlpha2();
            }
            return this;
        }

        public Builder privateCountry(String s) {
            this.addPrivate("country");
            return this.country(s);
        }

        @Deprecated
        public Builder country(LDCountryCode country) {
            this.country = country == null ? null : country.getAlpha2();
            return this;
        }

        @Deprecated
        public Builder privateCountry(LDCountryCode country) {
            this.addPrivate("country");
            return this.country(country);
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder privateFirstName(String firstName) {
            this.addPrivate("firstName");
            return this.firstName(firstName);
        }

        public Builder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder privateLastName(String lastName) {
            this.addPrivate("lastName");
            return this.lastName(lastName);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privateName(String name) {
            this.addPrivate("name");
            return this.name(name);
        }

        public Builder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder privateAvatar(String avatar) {
            this.addPrivate("avatar");
            return this.avatar(avatar);
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder privateEmail(String email) {
            this.addPrivate("email");
            return this.email(email);
        }

        public Builder custom(String k, String v) {
            return this.custom(k, (JsonElement)(v == null ? null : new JsonPrimitive(v)));
        }

        public Builder custom(String k, Number n) {
            return this.custom(k, (JsonElement)(n == null ? null : new JsonPrimitive(n)));
        }

        public Builder custom(String k, Boolean b) {
            return this.custom(k, (JsonElement)(b == null ? null : new JsonPrimitive(b)));
        }

        public Builder custom(String k, LDValue v) {
            this.checkCustomAttribute(k);
            if (k != null && v != null) {
                if (this.custom == null) {
                    this.custom = new HashMap<String, LDValue>();
                }
                this.custom.put(k, v);
            }
            return this;
        }

        @Deprecated
        public Builder custom(String k, JsonElement v) {
            return this.custom(k, LDValue.unsafeFromJsonElement(v));
        }

        public Builder customString(String k, List<String> vs) {
            JsonArray array = new JsonArray();
            for (String v : vs) {
                if (v == null) continue;
                array.add((JsonElement)new JsonPrimitive(v));
            }
            return this.custom(k, (JsonElement)array);
        }

        public Builder customNumber(String k, List<Number> vs) {
            JsonArray array = new JsonArray();
            for (Number v : vs) {
                if (v == null) continue;
                array.add((JsonElement)new JsonPrimitive(v));
            }
            return this.custom(k, (JsonElement)array);
        }

        public Builder customValues(String k, List<JsonElement> vs) {
            JsonArray array = new JsonArray();
            for (JsonElement v : vs) {
                if (v == null) continue;
                array.add(v);
            }
            return this.custom(k, (JsonElement)array);
        }

        public Builder privateCustom(String k, String v) {
            this.addPrivate(k);
            return this.custom(k, v);
        }

        public Builder privateCustom(String k, Number n) {
            this.addPrivate(k);
            return this.custom(k, n);
        }

        public Builder privateCustom(String k, Boolean b) {
            this.addPrivate(k);
            return this.custom(k, b);
        }

        public Builder privateCustom(String k, LDValue v) {
            this.addPrivate(k);
            return this.custom(k, v);
        }

        @Deprecated
        public Builder privateCustom(String k, JsonElement v) {
            this.addPrivate(k);
            return this.custom(k, v);
        }

        public Builder privateCustomString(String k, List<String> vs) {
            this.addPrivate(k);
            return this.customString(k, vs);
        }

        public Builder privateCustomNumber(String k, List<Number> vs) {
            this.addPrivate(k);
            return this.customNumber(k, vs);
        }

        public Builder privateCustomValues(String k, List<JsonElement> vs) {
            this.addPrivate(k);
            return this.customValues(k, vs);
        }

        private void checkCustomAttribute(String key) {
            for (UserAttribute a : UserAttribute.values()) {
                if (!a.name().equals(key)) continue;
                logger.warn("Built-in attribute key: " + key + " added as custom attribute! This custom attribute will be ignored during Feature Flag evaluation");
                return;
            }
        }

        private void addPrivate(String key) {
            if (this.privateAttrNames == null) {
                this.privateAttrNames = new HashSet<String>();
            }
            this.privateAttrNames.add(key);
        }

        public LDUser build() {
            return new LDUser(this);
        }
    }

    static class UserAdapterWithPrivateAttributeBehavior
    extends TypeAdapter<LDUser> {
        private final EventsConfiguration config;

        public UserAdapterWithPrivateAttributeBehavior(EventsConfiguration config) {
            this.config = config;
        }

        public void write(JsonWriter out, LDUser user) throws IOException {
            if (user == null) {
                out.value((String)null);
                return;
            }
            TreeSet<String> privateAttributeNames = new TreeSet<String>(this.config.privateAttrNames);
            out.beginObject();
            out.name("key").value(user.getKeyAsString());
            if (!user.getSecondary().isNull() && !this.checkAndAddPrivate("secondary", user, privateAttributeNames)) {
                out.name("secondary").value(user.getSecondary().stringValue());
            }
            if (!user.getIp().isNull() && !this.checkAndAddPrivate("ip", user, privateAttributeNames)) {
                out.name("ip").value(user.getIp().stringValue());
            }
            if (!user.getEmail().isNull() && !this.checkAndAddPrivate("email", user, privateAttributeNames)) {
                out.name("email").value(user.getEmail().stringValue());
            }
            if (!user.getName().isNull() && !this.checkAndAddPrivate("name", user, privateAttributeNames)) {
                out.name("name").value(user.getName().stringValue());
            }
            if (!user.getAvatar().isNull() && !this.checkAndAddPrivate("avatar", user, privateAttributeNames)) {
                out.name("avatar").value(user.getAvatar().stringValue());
            }
            if (!user.getFirstName().isNull() && !this.checkAndAddPrivate("firstName", user, privateAttributeNames)) {
                out.name("firstName").value(user.getFirstName().stringValue());
            }
            if (!user.getLastName().isNull() && !this.checkAndAddPrivate("lastName", user, privateAttributeNames)) {
                out.name("lastName").value(user.getLastName().stringValue());
            }
            if (!user.getAnonymous().isNull()) {
                out.name("anonymous").value(user.getAnonymous().booleanValue());
            }
            if (!user.getCountry().isNull() && !this.checkAndAddPrivate("country", user, privateAttributeNames)) {
                out.name("country").value(user.getCountry().stringValue());
            }
            this.writeCustomAttrs(out, user, privateAttributeNames);
            this.writePrivateAttrNames(out, privateAttributeNames);
            out.endObject();
        }

        private void writePrivateAttrNames(JsonWriter out, Set<String> names) throws IOException {
            if (names.isEmpty()) {
                return;
            }
            out.name("privateAttrs");
            out.beginArray();
            for (String name : names) {
                out.value(name);
            }
            out.endArray();
        }

        private boolean checkAndAddPrivate(String key, LDUser user, Set<String> privateAttrs) {
            boolean result;
            boolean bl = result = this.config.allAttributesPrivate || this.config.privateAttrNames.contains(key) || user.privateAttributeNames != null && user.privateAttributeNames.contains(key);
            if (result) {
                privateAttrs.add(key);
            }
            return result;
        }

        private void writeCustomAttrs(JsonWriter out, LDUser user, Set<String> privateAttributeNames) throws IOException {
            boolean beganObject = false;
            if (user.custom == null) {
                return;
            }
            for (Map.Entry entry : user.custom.entrySet()) {
                if (this.checkAndAddPrivate((String)entry.getKey(), user, privateAttributeNames)) continue;
                if (!beganObject) {
                    out.name("custom");
                    out.beginObject();
                    beganObject = true;
                }
                out.name((String)entry.getKey());
                JsonHelpers.gsonInstance().toJson(entry.getValue(), LDValue.class, out);
            }
            if (beganObject) {
                out.endObject();
            }
        }

        public LDUser read(JsonReader in) throws IOException {
            return null;
        }
    }
}

