/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.DefaultEventProcessor;
import com.launchdarkly.client.DefaultFeatureRequestor;
import com.launchdarkly.client.DiagnosticAccumulator;
import com.launchdarkly.client.DiagnosticEvent;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.EventProcessorFactory;
import com.launchdarkly.client.EventProcessorFactoryWithDiagnostics;
import com.launchdarkly.client.EventsConfiguration;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.HttpConfigurationImpl;
import com.launchdarkly.client.InMemoryFeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.PollingProcessor;
import com.launchdarkly.client.RedisFeatureStoreBuilder;
import com.launchdarkly.client.StreamProcessor;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.UpdateProcessorFactory;
import com.launchdarkly.client.UpdateProcessorFactoryWithDiagnostics;
import com.launchdarkly.client.integrations.EventProcessorBuilder;
import com.launchdarkly.client.integrations.HttpConfigurationBuilder;
import com.launchdarkly.client.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.client.integrations.PollingDataSourceBuilder;
import com.launchdarkly.client.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.client.interfaces.DiagnosticDescription;
import com.launchdarkly.client.interfaces.HttpAuthentication;
import com.launchdarkly.client.interfaces.HttpConfiguration;
import com.launchdarkly.client.interfaces.PersistentDataStoreFactory;
import com.launchdarkly.client.utils.CachingStoreWrapper;
import com.launchdarkly.client.utils.FeatureStoreCore;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.com.google.common.util.concurrent.Futures;
import com.launchdarkly.shaded.okhttp3.Credentials;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.concurrent.Future;

public abstract class Components {
    private static final FeatureStoreFactory inMemoryFeatureStoreFactory = new InMemoryFeatureStoreFactory();
    private static final EventProcessorFactory defaultEventProcessorFactory = new DefaultEventProcessorFactory();
    private static final EventProcessorFactory nullEventProcessorFactory = new NullEventProcessorFactory();
    private static final UpdateProcessorFactory defaultUpdateProcessorFactory = new DefaultUpdateProcessorFactory();
    private static final NullUpdateProcessorFactory nullUpdateProcessorFactory = new NullUpdateProcessorFactory();

    public static FeatureStoreFactory inMemoryDataStore() {
        return inMemoryFeatureStoreFactory;
    }

    public static PersistentDataStoreBuilder persistentDataStore(PersistentDataStoreFactory storeFactory) {
        return new PersistentDataStoreBuilderImpl(storeFactory);
    }

    @Deprecated
    public static FeatureStoreFactory inMemoryFeatureStore() {
        return inMemoryFeatureStoreFactory;
    }

    @Deprecated
    public static RedisFeatureStoreBuilder redisFeatureStore() {
        return new RedisFeatureStoreBuilder();
    }

    @Deprecated
    public static RedisFeatureStoreBuilder redisFeatureStore(URI redisUri) {
        return new RedisFeatureStoreBuilder(redisUri);
    }

    public static EventProcessorBuilder sendEvents() {
        return new EventProcessorBuilderImpl();
    }

    @Deprecated
    public static EventProcessorFactory defaultEventProcessor() {
        return defaultEventProcessorFactory;
    }

    public static EventProcessorFactory noEvents() {
        return nullEventProcessorFactory;
    }

    @Deprecated
    public static EventProcessorFactory nullEventProcessor() {
        return nullEventProcessorFactory;
    }

    public static StreamingDataSourceBuilder streamingDataSource() {
        return new StreamingDataSourceBuilderImpl();
    }

    public static PollingDataSourceBuilder pollingDataSource() {
        return new PollingDataSourceBuilderImpl();
    }

    @Deprecated
    public static UpdateProcessorFactory defaultUpdateProcessor() {
        return defaultUpdateProcessorFactory;
    }

    public static UpdateProcessorFactory externalUpdatesOnly() {
        return nullUpdateProcessorFactory;
    }

    @Deprecated
    public static UpdateProcessorFactory nullUpdateProcessor() {
        return nullUpdateProcessorFactory;
    }

    public static HttpConfigurationBuilder httpConfiguration() {
        return new HttpConfigurationBuilderImpl();
    }

    public static HttpAuthentication httpBasicAuthentication(String username, String password) {
        return new HttpBasicAuthentication(username, password);
    }

    private static final class PersistentDataStoreBuilderImpl
    extends PersistentDataStoreBuilder
    implements DiagnosticDescription {
        public PersistentDataStoreBuilderImpl(PersistentDataStoreFactory persistentDataStoreFactory) {
            super(persistentDataStoreFactory);
        }

        @Override
        public FeatureStore createFeatureStore() {
            FeatureStoreCore core = this.persistentDataStoreFactory.createPersistentDataStore();
            return CachingStoreWrapper.builder(core).caching(this.caching).cacheMonitor(this.cacheMonitor).build();
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (this.persistentDataStoreFactory instanceof DiagnosticDescription) {
                return ((DiagnosticDescription)((Object)this.persistentDataStoreFactory)).describeConfiguration(config);
            }
            return LDValue.of("?");
        }
    }

    private static final class HttpBasicAuthentication
    implements HttpAuthentication {
        private final String username;
        private final String password;

        HttpBasicAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public String provideAuthorization(Iterable<HttpAuthentication.Challenge> challenges) {
            return Credentials.basic(this.username, this.password);
        }
    }

    private static final class HttpConfigurationBuilderImpl
    extends HttpConfigurationBuilder {
        private HttpConfigurationBuilderImpl() {
        }

        @Override
        public HttpConfiguration createHttpConfiguration() {
            return new HttpConfigurationImpl(this.connectTimeoutMillis, this.proxyHost == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort)), this.proxyAuth, this.socketTimeoutMillis, this.sslSocketFactory, this.trustManager, this.wrapperName == null ? null : (this.wrapperVersion == null ? this.wrapperName : this.wrapperName + "/" + this.wrapperVersion));
        }
    }

    private static final class EventProcessorBuilderImpl
    extends EventProcessorBuilder
    implements EventProcessorFactoryWithDiagnostics,
    DiagnosticDescription {
        private EventProcessorBuilderImpl() {
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config) {
            return this.createEventProcessor(sdkKey, config, null);
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config, DiagnosticAccumulator diagnosticAccumulator) {
            if (config.offline) {
                return new NullEventProcessor();
            }
            return new DefaultEventProcessor(sdkKey, config, new EventsConfiguration(this.allAttributesPrivate, this.capacity, this.baseURI == null ? LDConfig.DEFAULT_EVENTS_URI : this.baseURI, this.flushIntervalSeconds, this.inlineUsersInEvents, this.privateAttrNames, 0, this.userKeysCapacity, this.userKeysFlushIntervalSeconds, this.diagnosticRecordingIntervalSeconds), config.httpConfig, diagnosticAccumulator);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.ALL_ATTRIBUTES_PRIVATE.name, this.allAttributesPrivate).put(DiagnosticEvent.ConfigProperty.CUSTOM_EVENTS_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_EVENTS_URI)).put(DiagnosticEvent.ConfigProperty.DIAGNOSTIC_RECORDING_INTERVAL_MILLIS.name, this.diagnosticRecordingIntervalSeconds * 1000).put(DiagnosticEvent.ConfigProperty.EVENTS_CAPACITY.name, this.capacity).put(DiagnosticEvent.ConfigProperty.EVENTS_FLUSH_INTERVAL_MILLIS.name, this.flushIntervalSeconds * 1000).put(DiagnosticEvent.ConfigProperty.INLINE_USERS_IN_EVENTS.name, this.inlineUsersInEvents).put(DiagnosticEvent.ConfigProperty.SAMPLING_INTERVAL.name, 0).put(DiagnosticEvent.ConfigProperty.USER_KEYS_CAPACITY.name, this.userKeysCapacity).put(DiagnosticEvent.ConfigProperty.USER_KEYS_FLUSH_INTERVAL_MILLIS.name, this.userKeysFlushIntervalSeconds * 1000).build();
        }
    }

    private static final class PollingDataSourceBuilderImpl
    extends PollingDataSourceBuilder
    implements DiagnosticDescription {
        private PollingDataSourceBuilderImpl() {
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
            if (config.offline) {
                return Components.externalUpdatesOnly().createUpdateProcessor(sdkKey, config, featureStore);
            }
            LDClient.logger.info("Disabling streaming API");
            LDClient.logger.warn("You should only disable the streaming API if instructed to do so by LaunchDarkly support");
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(sdkKey, config.httpConfig, this.baseURI == null ? LDConfig.DEFAULT_BASE_URI : this.baseURI, true);
            return new PollingProcessor(requestor, featureStore, this.pollIntervalMillis);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (config.offline) {
                return nullUpdateProcessorFactory.describeConfiguration(config);
            }
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_BASE_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.POLLING_INTERVAL_MILLIS.name, this.pollIntervalMillis).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    private static final class StreamingDataSourceBuilderImpl
    extends StreamingDataSourceBuilder
    implements UpdateProcessorFactoryWithDiagnostics,
    DiagnosticDescription {
        private StreamingDataSourceBuilderImpl() {
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
            return this.createUpdateProcessor(sdkKey, config, featureStore, null);
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore, DiagnosticAccumulator diagnosticAccumulator) {
            URI streamUri;
            if (config.offline) {
                return Components.externalUpdatesOnly().createUpdateProcessor(sdkKey, config, featureStore);
            }
            LDClient.logger.info("Enabling streaming API");
            URI uRI = streamUri = this.baseURI == null ? LDConfig.DEFAULT_STREAM_URI : this.baseURI;
            URI pollUri = this.pollingBaseURI != null ? this.pollingBaseURI : (this.baseURI == null ? LDConfig.DEFAULT_BASE_URI : this.baseURI);
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(sdkKey, config.httpConfig, pollUri, false);
            return new StreamProcessor(sdkKey, config.httpConfig, requestor, featureStore, null, diagnosticAccumulator, streamUri, this.initialReconnectDelayMillis);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (config.offline) {
                return nullUpdateProcessorFactory.describeConfiguration(config);
            }
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, this.pollingBaseURI != null && !this.pollingBaseURI.equals(LDConfig.DEFAULT_BASE_URI) || this.pollingBaseURI == null && this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, this.baseURI != null && !this.baseURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.RECONNECT_TIME_MILLIS.name, this.initialReconnectDelayMillis).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class NullUpdateProcessor
    implements UpdateProcessor {
        NullUpdateProcessor() {
        }

        @Override
        public Future<Void> start() {
            return Futures.immediateFuture(null);
        }

        @Override
        public boolean initialized() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class NullUpdateProcessorFactory
    implements UpdateProcessorFactory,
    DiagnosticDescription {
        private NullUpdateProcessorFactory() {
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
            if (config.offline) {
                LDClient.logger.info("Starting LaunchDarkly client in offline mode");
            } else {
                LDClient.logger.info("LaunchDarkly client will not connect to Launchdarkly for feature flag data");
            }
            return new NullUpdateProcessor();
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, config.dataStoreFactory != null && config.dataStoreFactory != Components.inMemoryDataStore()).build();
        }
    }

    private static final class DefaultUpdateProcessorFactory
    implements UpdateProcessorFactoryWithDiagnostics,
    DiagnosticDescription {
        private DefaultUpdateProcessorFactory() {
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
            return this.createUpdateProcessor(sdkKey, config, featureStore, null);
        }

        @Override
        public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore, DiagnosticAccumulator diagnosticAccumulator) {
            if (config.offline) {
                return Components.externalUpdatesOnly().createUpdateProcessor(sdkKey, config, featureStore);
            }
            if (config.deprecatedStream) {
                StreamingDataSourceBuilderImpl builder = (StreamingDataSourceBuilderImpl)Components.streamingDataSource().baseURI(config.deprecatedStreamURI).pollingBaseURI(config.deprecatedBaseURI).initialReconnectDelayMillis(config.deprecatedReconnectTimeMs);
                return builder.createUpdateProcessor(sdkKey, config, featureStore, diagnosticAccumulator);
            }
            return Components.pollingDataSource().baseURI(config.deprecatedBaseURI).pollIntervalMillis(config.deprecatedPollingIntervalMillis).createUpdateProcessor(sdkKey, config, featureStore);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            if (config.offline) {
                return nullUpdateProcessorFactory.describeConfiguration(config);
            }
            if (config.deprecatedStream) {
                return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, config.deprecatedBaseURI != null && !config.deprecatedBaseURI.equals(LDConfig.DEFAULT_BASE_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, config.deprecatedStreamURI != null && !config.deprecatedStreamURI.equals(LDConfig.DEFAULT_STREAM_URI)).put(DiagnosticEvent.ConfigProperty.RECONNECT_TIME_MILLIS.name, config.deprecatedReconnectTimeMs).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
            }
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticEvent.ConfigProperty.CUSTOM_BASE_URI.name, config.deprecatedBaseURI != null && !config.deprecatedBaseURI.equals(LDConfig.DEFAULT_BASE_URI)).put(DiagnosticEvent.ConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticEvent.ConfigProperty.POLLING_INTERVAL_MILLIS.name, config.deprecatedPollingIntervalMillis).put(DiagnosticEvent.ConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class NullEventProcessor
    implements EventProcessor {
        NullEventProcessor() {
        }

        @Override
        public void sendEvent(Event e) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class NullEventProcessorFactory
    implements EventProcessorFactory {
        private NullEventProcessorFactory() {
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config) {
            return new NullEventProcessor();
        }
    }

    private static final class DefaultEventProcessorFactory
    implements EventProcessorFactoryWithDiagnostics,
    DiagnosticDescription {
        private DefaultEventProcessorFactory() {
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config) {
            return this.createEventProcessor(sdkKey, config, null);
        }

        @Override
        public EventProcessor createEventProcessor(String sdkKey, LDConfig config, DiagnosticAccumulator diagnosticAccumulator) {
            if (config.offline || !config.deprecatedSendEvents) {
                return new NullEventProcessor();
            }
            return new DefaultEventProcessor(sdkKey, config, new EventsConfiguration(config.deprecatedAllAttributesPrivate, config.deprecatedCapacity, config.deprecatedEventsURI == null ? LDConfig.DEFAULT_EVENTS_URI : config.deprecatedEventsURI, config.deprecatedFlushInterval, config.deprecatedInlineUsersInEvents, config.deprecatedPrivateAttrNames, config.deprecatedSamplingInterval, config.deprecatedUserKeysCapacity, config.deprecatedUserKeysFlushInterval, 900), config.httpConfig, diagnosticAccumulator);
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.buildObject().put(DiagnosticEvent.ConfigProperty.ALL_ATTRIBUTES_PRIVATE.name, config.deprecatedAllAttributesPrivate).put(DiagnosticEvent.ConfigProperty.CUSTOM_EVENTS_URI.name, config.deprecatedEventsURI != null && !config.deprecatedEventsURI.equals(LDConfig.DEFAULT_EVENTS_URI)).put(DiagnosticEvent.ConfigProperty.DIAGNOSTIC_RECORDING_INTERVAL_MILLIS.name, 900000).put(DiagnosticEvent.ConfigProperty.EVENTS_CAPACITY.name, config.deprecatedCapacity).put(DiagnosticEvent.ConfigProperty.EVENTS_FLUSH_INTERVAL_MILLIS.name, config.deprecatedFlushInterval * 1000).put(DiagnosticEvent.ConfigProperty.INLINE_USERS_IN_EVENTS.name, config.deprecatedInlineUsersInEvents).put(DiagnosticEvent.ConfigProperty.SAMPLING_INTERVAL.name, config.deprecatedSamplingInterval).put(DiagnosticEvent.ConfigProperty.USER_KEYS_CAPACITY.name, config.deprecatedUserKeysCapacity).put(DiagnosticEvent.ConfigProperty.USER_KEYS_FLUSH_INTERVAL_MILLIS.name, config.deprecatedUserKeysFlushInterval * 1000).build();
        }
    }

    private static final class InMemoryFeatureStoreFactory
    implements FeatureStoreFactory,
    DiagnosticDescription {
        private InMemoryFeatureStoreFactory() {
        }

        @Override
        public FeatureStore createFeatureStore() {
            return new InMemoryFeatureStore();
        }

        @Override
        public LDValue describeConfiguration(LDConfig config) {
            return LDValue.of("memory");
        }
    }
}

