/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.integrations;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.integrations.EvaluationSeriesContext;
import com.launchdarkly.sdk.server.integrations.Hook;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.HashMap;
import java.util.Map;

public class TracingHook
extends Hook {
    static final String PROVIDER_NAME = "LaunchDarkly";
    static final String HOOK_NAME = "LaunchDarkly Tracing Hook";
    static final String INSTRUMENTATION_NAME = "launchdarkly-client";
    static final String DATA_KEY_SPAN = "variationSpan";
    static final String EVENT_NAME = "feature_flag";
    static final String SEMCONV_FEATURE_FLAG_PROVIDER_NAME = "feature_flag.provider.name";
    static final String SEMCONV_FEATURE_FLAG_KEY = "feature_flag.key";
    static final String SEMCONV_FEATURE_FLAG_VALUE = "feature_flag.result.value";
    static final String SEMCONV_FEATURE_FLAG_CONTEXT_ID = "feature_flag.context.id";
    static final String SEMCONV_FEATURE_FLAG_VARIATION_INDEX = "feature_flag.result.variationIndex";
    static final String SEMCONV_FEATURE_FLAG_IN_EXPERIMENT = "feature_flag.result.reason.inExperiment";
    private final boolean withSpans;
    private final boolean withValue;

    TracingHook(boolean withSpans, boolean withValue) {
        super(HOOK_NAME);
        this.withSpans = withSpans;
        this.withValue = withValue;
    }

    public Map<String, Object> beforeEvaluation(EvaluationSeriesContext seriesContext, Map<String, Object> seriesData) {
        return this.beforeEvaluationInternal(GlobalOpenTelemetry.get().getTracer(INSTRUMENTATION_NAME), seriesContext, seriesData);
    }

    Map<String, Object> beforeEvaluationInternal(Tracer tracer, EvaluationSeriesContext seriesContext, Map<String, Object> seriesData) {
        if (!this.withSpans) {
            return seriesData;
        }
        SpanBuilder builder = tracer.spanBuilder(seriesContext.method).setParent(Context.current().with((ImplicitContextKeyed)Span.current()));
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.put(SEMCONV_FEATURE_FLAG_KEY, seriesContext.flagKey);
        attrBuilder.put(SEMCONV_FEATURE_FLAG_PROVIDER_NAME, PROVIDER_NAME);
        attrBuilder.put(SEMCONV_FEATURE_FLAG_CONTEXT_ID, seriesContext.context.getFullyQualifiedKey());
        builder.setAllAttributes(attrBuilder.build());
        Span span = builder.startSpan();
        HashMap<String, Object> retSeriesData = new HashMap<String, Object>(seriesData);
        retSeriesData.put(DATA_KEY_SPAN, span);
        return retSeriesData;
    }

    public Map<String, Object> afterEvaluation(EvaluationSeriesContext seriesContext, Map<String, Object> seriesData, EvaluationDetail<LDValue> evaluationDetail) {
        Object value = seriesData.get(DATA_KEY_SPAN);
        if (value instanceof Span) {
            Span span = (Span)value;
            span.end();
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.put(SEMCONV_FEATURE_FLAG_KEY, seriesContext.flagKey);
        attrBuilder.put(SEMCONV_FEATURE_FLAG_PROVIDER_NAME, PROVIDER_NAME);
        attrBuilder.put(SEMCONV_FEATURE_FLAG_CONTEXT_ID, seriesContext.context.getFullyQualifiedKey());
        if (this.withValue) {
            attrBuilder.put(SEMCONV_FEATURE_FLAG_VALUE, ((LDValue)evaluationDetail.getValue()).toJsonString());
        }
        if (evaluationDetail.getReason().isInExperiment()) {
            attrBuilder.put(SEMCONV_FEATURE_FLAG_IN_EXPERIMENT, true);
        }
        if (evaluationDetail.getVariationIndex() != -1) {
            attrBuilder.put(SEMCONV_FEATURE_FLAG_VARIATION_INDEX, (long)evaluationDetail.getVariationIndex());
        }
        Span.current().addEvent(EVENT_NAME, attrBuilder.build());
        return seriesData;
    }

    public static class Builder {
        private boolean withSpans = false;
        private boolean withValue = false;

        public Builder withSpans() {
            this.withSpans = true;
            return this;
        }

        public Builder withValue() {
            this.withValue = true;
            return this;
        }

        @Deprecated
        public Builder withVariant() {
            this.withValue = true;
            return this;
        }

        public TracingHook build() {
            return new TracingHook(this.withSpans, this.withValue);
        }
    }
}

