/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.BodyDecoderException;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.body.JSONObjectBody;
import com.koushikdutta.async.http.body.MultipartFormDataBody;
import com.koushikdutta.async.http.body.StringBody;
import com.koushikdutta.async.http.body.UrlEncodedFormBody;
import com.koushikdutta.async.http.filter.ChunkedInputFilter;
import com.koushikdutta.async.http.filter.ContentLengthFilter;
import com.koushikdutta.async.http.filter.GZIPInputFilter;
import com.koushikdutta.async.http.filter.InflaterInputFilter;

public class HttpUtil {
    public static AsyncHttpRequestBody getBody(DataEmitter emitter, CompletedCallback reporter, Headers headers) {
        String contentType = headers.get("Content-Type");
        if (contentType != null) {
            String[] values = contentType.split(";");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            for (String ct : values) {
                if ("application/x-www-form-urlencoded".equals(ct)) {
                    return new UrlEncodedFormBody();
                }
                if ("application/json".equals(ct)) {
                    return new JSONObjectBody();
                }
                if ("text/plain".equals(ct)) {
                    return new StringBody();
                }
                if (ct == null || !ct.startsWith("multipart/")) continue;
                return new MultipartFormDataBody(contentType);
            }
        }
        return null;
    }

    public static DataEmitter getBodyDecoder(DataEmitter emitter, Protocol protocol, Headers headers, boolean server) {
        long _contentLength = -1L;
        try {
            String header = headers.get("Content-Length");
            if (header != null) {
                _contentLength = Long.parseLong(header);
            }
        }
        catch (NumberFormatException header) {
            // empty catch block
        }
        long contentLength = _contentLength;
        if (-1L != contentLength) {
            if (contentLength < 0L) {
                EndEmitter ender = EndEmitter.create(emitter.getServer(), new BodyDecoderException("not using chunked encoding, and no content-length found."));
                ender.setDataEmitter(emitter);
                emitter = ender;
                return emitter;
            }
            if (contentLength == 0L) {
                EndEmitter ender = EndEmitter.create(emitter.getServer(), null);
                ender.setDataEmitter(emitter);
                emitter = ender;
                return emitter;
            }
            ContentLengthFilter contentLengthWatcher = new ContentLengthFilter(contentLength);
            contentLengthWatcher.setDataEmitter(emitter);
            emitter = contentLengthWatcher;
        } else if ("chunked".equalsIgnoreCase(headers.get("Transfer-Encoding"))) {
            ChunkedInputFilter chunker = new ChunkedInputFilter();
            chunker.setDataEmitter(emitter);
            emitter = chunker;
        } else if (server) {
            EndEmitter ender = EndEmitter.create(emitter.getServer(), null);
            ender.setDataEmitter(emitter);
            emitter = ender;
            return emitter;
        }
        if ("gzip".equals(headers.get("Content-Encoding"))) {
            GZIPInputFilter gunzipper = new GZIPInputFilter();
            gunzipper.setDataEmitter(emitter);
            emitter = gunzipper;
        } else if ("deflate".equals(headers.get("Content-Encoding"))) {
            InflaterInputFilter inflater = new InflaterInputFilter();
            inflater.setDataEmitter(emitter);
            emitter = inflater;
        }
        return emitter;
    }

    public static boolean isKeepAlive(Protocol protocol, Headers headers) {
        String connection = headers.get("Connection");
        if (connection == null) {
            return protocol == Protocol.HTTP_1_1;
        }
        return "keep-alive".equalsIgnoreCase(connection);
    }

    public static boolean isKeepAlive(String protocol, Headers headers) {
        String connection = headers.get("Connection");
        if (connection == null) {
            return Protocol.get(protocol) == Protocol.HTTP_1_1;
        }
        return "keep-alive".equalsIgnoreCase(connection);
    }

    public static long contentLength(Headers headers) {
        String cl = headers.get("Content-Length");
        if (cl == null) {
            return -1L;
        }
        try {
            return Long.parseLong(cl);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    static class EndEmitter
    extends FilteredDataEmitter {
        private EndEmitter() {
        }

        public static EndEmitter create(AsyncServer server, final Exception e) {
            final EndEmitter ret = new EndEmitter();
            server.post(new Runnable(){

                @Override
                public void run() {
                    ret.report(e);
                }
            });
            return ret;
        }
    }
}

