/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import android.os.Handler;
import android.os.Looper;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;

public class HandlerFuture<T>
extends SimpleFuture<T> {
    Handler handler;

    public HandlerFuture() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        this.handler = new Handler(looper);
    }

    @Override
    public void setCallback(final FutureCallback<T> callback) {
        FutureCallback wrapped = new FutureCallback<T>(){

            @Override
            public void onCompleted(final Exception e, final T result) {
                if (Looper.myLooper() == HandlerFuture.this.handler.getLooper()) {
                    callback.onCompleted(e, result);
                    return;
                }
                HandlerFuture.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        this.onCompleted(e, result);
                    }
                });
            }
        };
        super.setCallback(wrapped);
    }
}

