/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.dns;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.http.Multimap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class DnsResponse {
    public ArrayList<InetAddress> addresses = new ArrayList();
    public ArrayList<String> names = new ArrayList();
    public Multimap txt = new Multimap();
    public InetSocketAddress source;

    private static String parseName(ByteBufferList bb, ByteBuffer backReference) {
        int len;
        bb.order(ByteOrder.BIG_ENDIAN);
        String ret = "";
        while (0 != (len = bb.get() & 0xFF)) {
            if ((len & 0xC0) == 192) {
                int offset = (len & 0x3F) << 8 | bb.get() & 0xFF;
                if (ret.length() > 0) {
                    ret = ret + ".";
                }
                ByteBufferList sub = new ByteBufferList();
                ByteBuffer duplicate = backReference.duplicate();
                duplicate.get(new byte[offset]);
                sub.add(duplicate);
                return ret + DnsResponse.parseName(sub, backReference);
            }
            byte[] bytes = new byte[len];
            bb.get(bytes);
            if (ret.length() > 0) {
                ret = ret + ".";
            }
            ret = ret + new String(bytes);
        }
        return ret;
    }

    public static DnsResponse parse(ByteBufferList bb) {
        ByteBufferList txt2;
        short length;
        int ttl;
        short clazz;
        short type;
        String name;
        int i;
        ByteBuffer b = bb.getAll();
        bb.add(b.duplicate());
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.getShort();
        bb.getShort();
        int questions = bb.getShort();
        int answers = bb.getShort();
        int authorities = bb.getShort();
        int additionals = bb.getShort();
        for (int i2 = 0; i2 < questions; ++i2) {
            DnsResponse.parseName(bb, b);
            bb.getShort();
            bb.getShort();
        }
        DnsResponse response = new DnsResponse();
        for (i = 0; i < answers; ++i) {
            name = DnsResponse.parseName(bb, b);
            type = bb.getShort();
            clazz = bb.getShort();
            ttl = bb.getInt();
            length = bb.getShort();
            try {
                if (type == 1) {
                    byte[] data = new byte[length];
                    bb.get(data);
                    response.addresses.add(InetAddress.getByAddress(data));
                    continue;
                }
                if (type == 12) {
                    response.names.add(DnsResponse.parseName(bb, b));
                    continue;
                }
                if (type == 16) {
                    txt2 = new ByteBufferList();
                    bb.get(txt2, length);
                    response.parseTxt(txt2);
                    continue;
                }
                bb.get(new byte[length]);
                continue;
            }
            catch (Exception txt2) {
                // empty catch block
            }
        }
        for (i = 0; i < authorities; ++i) {
            name = DnsResponse.parseName(bb, b);
            type = bb.getShort();
            clazz = bb.getShort();
            ttl = bb.getInt();
            length = bb.getShort();
            try {
                bb.get(new byte[length]);
                continue;
            }
            catch (Exception txt2) {
                // empty catch block
            }
        }
        for (i = 0; i < additionals; ++i) {
            name = DnsResponse.parseName(bb, b);
            type = bb.getShort();
            clazz = bb.getShort();
            ttl = bb.getInt();
            length = bb.getShort();
            try {
                if (type == 16) {
                    txt2 = new ByteBufferList();
                    bb.get(txt2, length);
                    response.parseTxt(txt2);
                    continue;
                }
                bb.get(new byte[length]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return response;
    }

    void parseTxt(ByteBufferList bb) {
        while (bb.hasRemaining()) {
            int length = bb.get() & 0xFF;
            byte[] bytes = new byte[length];
            bb.get(bytes);
            String string = new String(bytes);
            String[] pair = string.split("=");
            this.txt.add(pair[0], pair[1]);
        }
    }

    public String toString() {
        String ret = "addresses:\n";
        for (InetAddress address : this.addresses) {
            ret = ret + address.toString() + "\n";
        }
        ret = ret + "names:\n";
        for (String name : this.names) {
            ret = ret + name + "\n";
        }
        return ret;
    }
}

