/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.util;

import android.os.Handler;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.callback.ValueCallback;
import com.koushikdutta.async.util.TimeoutBase;
import java.util.ArrayList;
import java.util.List;

public class ThrottleTimeout<T>
extends TimeoutBase {
    ValueCallback<List<T>> callback;
    ArrayList<T> values = new ArrayList();
    ThrottleMode throttleMode = ThrottleMode.Collect;
    Object cancellable;

    public ThrottleTimeout(AsyncServer server, long delay, ValueCallback<List<T>> callback) {
        super(server, delay);
        this.callback = callback;
    }

    public ThrottleTimeout(Handler handler, long delay, ValueCallback<List<T>> callback) {
        super(handler, delay);
        this.callback = callback;
    }

    public void setCallback(ValueCallback<List<T>> callback) {
        this.callback = callback;
    }

    private void runCallback() {
        this.cancellable = null;
        ArrayList<T> v = new ArrayList<T>(this.values);
        this.values.clear();
        this.callback.onResult(v);
    }

    public synchronized void postThrottled(T value) {
        this.handlerish.post(() -> {
            this.values.add(value);
            if (this.throttleMode == ThrottleMode.Collect) {
                this.handlerish.removeAllCallbacks(this.cancellable);
                this.cancellable = this.handlerish.postDelayed(this::runCallback, this.delay);
            } else if (this.cancellable == null) {
                this.runCallback();
                this.cancellable = this.handlerish.postDelayed(this::runCallback, this.delay);
            }
        });
    }

    public void setThrottleMode(ThrottleMode throttleMode) {
        this.throttleMode = throttleMode;
    }

    public static enum ThrottleMode {
        Collect,
        Meter;

    }
}

