/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.WebSocketImpl;
import com.koushikdutta.async.http.server.AsyncHttpRequestBodyProvider;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.HttpServerRequestCallback;
import com.koushikdutta.async.http.server.RouteMatcher;
import com.koushikdutta.async.util.StreamUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AsyncHttpServerRouter
implements RouteMatcher {
    final ArrayList<RouteInfo> routes = new ArrayList();
    static Hashtable<String, String> mContentTypes = new Hashtable();
    static Hashtable<String, Future<Manifest>> AppManifests = new Hashtable();
    private Callback callback;

    public AsyncHttpServerRouter() {
        mContentTypes.put("js", "application/javascript");
        mContentTypes.put("json", "application/json");
        mContentTypes.put("png", "image/png");
        mContentTypes.put("jpg", "image/jpeg");
        mContentTypes.put("jpeg", "image/jpeg");
        mContentTypes.put("html", "text/html");
        mContentTypes.put("css", "text/css");
        mContentTypes.put("mp4", "video/mp4");
        mContentTypes.put("mov", "video/quicktime");
        mContentTypes.put("wmv", "video/x-ms-wmv");
        mContentTypes.put("txt", "text/plain");
        this.callback = new Callback();
    }

    public void removeAction(String action, String regex) {
        for (int i = 0; i < this.routes.size(); ++i) {
            RouteInfo p = this.routes.get(i);
            if (!TextUtils.equals((CharSequence)p.method, (CharSequence)action) || !regex.equals(p.regex.toString())) continue;
            this.routes.remove(i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String action, String regex, HttpServerRequestCallback callback, AsyncHttpRequestBodyProvider bodyCallback) {
        RouteInfo p = new RouteInfo();
        p.regex = Pattern.compile("^" + regex);
        p.callback = callback;
        p.method = action;
        p.bodyCallback = bodyCallback;
        ArrayList<RouteInfo> arrayList = this.routes;
        synchronized (arrayList) {
            this.routes.add(p);
        }
    }

    public void addAction(String action, String regex, HttpServerRequestCallback callback) {
        this.addAction(action, regex, callback, null);
    }

    public void websocket(String regex, AsyncHttpServer.WebSocketRequestCallback callback) {
        this.websocket(regex, null, callback);
    }

    public static WebSocket checkWebSocketUpgrade(String protocol, AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        boolean hasUpgrade = false;
        String connection = request.getHeaders().get("Connection");
        if (connection != null) {
            String[] connections;
            for (String c : connections = connection.split(",")) {
                if (!"Upgrade".equalsIgnoreCase(c.trim())) continue;
                hasUpgrade = true;
                break;
            }
        }
        if (!"websocket".equalsIgnoreCase(request.getHeaders().get("Upgrade")) || !hasUpgrade) {
            return null;
        }
        String peerProtocol = request.getHeaders().get("Sec-WebSocket-Protocol");
        if (!TextUtils.equals((CharSequence)protocol, (CharSequence)peerProtocol)) {
            return null;
        }
        return new WebSocketImpl(request, response);
    }

    public void websocket(String regex, String protocol, AsyncHttpServer.WebSocketRequestCallback callback) {
        this.get(regex, (request, response) -> {
            WebSocket webSocket = AsyncHttpServerRouter.checkWebSocketUpgrade(protocol, request, response);
            if (webSocket == null) {
                response.code(404);
                response.end();
                return;
            }
            callback.onConnected(webSocket, request);
        });
    }

    public void get(String regex, HttpServerRequestCallback callback) {
        this.addAction("GET", regex, callback);
    }

    public void post(String regex, HttpServerRequestCallback callback) {
        this.addAction("POST", regex, callback);
    }

    public static Asset getAssetStream(Context context, String asset) {
        return AsyncHttpServerRouter.getAssetStream(context.getAssets(), asset);
    }

    public static Asset getAssetStream(AssetManager am, String asset) {
        try {
            InputStream is = am.open(asset);
            return new Asset(is.available(), is, asset);
        }
        catch (IOException e) {
            String[] extensions;
            for (String ext : extensions = new String[]{"/index.htm", "/index.html", "index.htm", "index.html", ".htm", ".html"}) {
                try {
                    InputStream is = am.open(asset + ext);
                    return new Asset(is.available(), is, asset + ext);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }
    }

    public static String getContentType(String path) {
        return AsyncHttpServerRouter.tryGetContentType(path);
    }

    public static String tryGetContentType(String path) {
        String e;
        String ct;
        int index = path.lastIndexOf(".");
        if (index != -1 && (ct = mContentTypes.get(e = path.substring(index + 1))) != null) {
            return ct;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Manifest ensureManifest(Context context) {
        Manifest manifest;
        Future<Manifest> future = AppManifests.get(context.getPackageName());
        if (future != null) {
            return future.tryGet();
        }
        ZipFile zip = null;
        SimpleFuture<Manifest> result = new SimpleFuture<Manifest>();
        try {
            zip = new ZipFile(context.getPackageResourcePath());
            ZipEntry entry = zip.getEntry("META-INF/MANIFEST.MF");
            Manifest manifest2 = new Manifest(zip.getInputStream(entry));
            result.setComplete(manifest2);
            manifest = manifest2;
        }
        catch (Exception e) {
            Manifest manifest3;
            try {
                result.setComplete(e);
                manifest3 = null;
            }
            catch (Throwable throwable) {
                StreamUtility.closeQuietly(zip);
                AppManifests.put(context.getPackageName(), result);
                throw throwable;
            }
            StreamUtility.closeQuietly(zip);
            AppManifests.put(context.getPackageName(), result);
            return manifest3;
        }
        StreamUtility.closeQuietly(zip);
        AppManifests.put(context.getPackageName(), result);
        return manifest;
    }

    static boolean isClientCached(Context context, AsyncHttpServerRequest request, AsyncHttpServerResponse response, String assetFileName) {
        Manifest manifest = AsyncHttpServerRouter.ensureManifest(context);
        if (manifest == null) {
            return false;
        }
        try {
            String digest = manifest.getEntries().get("assets/" + assetFileName).getValue("SHA-256-Digest");
            if (TextUtils.isEmpty((CharSequence)digest)) {
                return false;
            }
            String etag = String.format("\"%s\"", digest);
            response.getHeaders().set("ETag", etag);
            String ifNoneMatch = request.getHeaders().get("If-None-Match");
            return TextUtils.equals((CharSequence)ifNoneMatch, (CharSequence)etag);
        }
        catch (Exception e) {
            Log.w((String)AsyncHttpServerRouter.class.getSimpleName(), (String)"Error getting ETag for apk asset", (Throwable)e);
            return false;
        }
    }

    public void directory(Context context, String regex, String assetPath) {
        AssetManager am = context.getAssets();
        this.addAction("GET", regex, (request, response) -> {
            String path = request.getMatcher().replaceAll("");
            Asset pair = AsyncHttpServerRouter.getAssetStream(am, assetPath + path);
            if (pair == null || pair.inputStream == null) {
                response.code(404);
                response.end();
                return;
            }
            if (AsyncHttpServerRouter.isClientCached(context, request, response, pair.path)) {
                StreamUtility.closeQuietly(pair.inputStream);
                response.code(304);
                response.end();
                return;
            }
            response.getHeaders().set("Content-Length", String.valueOf(pair.available));
            response.getHeaders().add("Content-Type", AsyncHttpServerRouter.getContentType(pair.path));
            response.code(200);
            Util.pump(pair.inputStream, pair.available, response, ex -> {
                response.end();
                StreamUtility.closeQuietly(pair.inputStream);
            });
        });
        this.addAction("HEAD", regex, (request, response) -> {
            String path = request.getMatcher().replaceAll("");
            Asset pair = AsyncHttpServerRouter.getAssetStream(am, assetPath + path);
            if (pair == null || pair.inputStream == null) {
                response.code(404);
                response.end();
                return;
            }
            StreamUtility.closeQuietly(pair.inputStream);
            if (AsyncHttpServerRouter.isClientCached(context, request, response, pair.path)) {
                response.code(304);
            } else {
                response.getHeaders().set("Content-Length", String.valueOf(pair.available));
                response.getHeaders().add("Content-Type", AsyncHttpServerRouter.getContentType(pair.path));
                response.code(200);
            }
            response.end();
        });
    }

    public void directory(String regex, File directory) {
        this.directory(regex, directory, false);
    }

    public void directory(String regex, final File directory, final boolean list) {
        assert (directory.isDirectory());
        this.addAction("GET", regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, final AsyncHttpServerResponse response) {
                String path = request.getMatcher().replaceAll("");
                File file = new File(directory, path);
                if (file.isDirectory() && list) {
                    ArrayList<File> dirs = new ArrayList<File>();
                    ArrayList<File> files = new ArrayList<File>();
                    for (File f : file.listFiles()) {
                        if (f.isDirectory()) {
                            dirs.add(f);
                            continue;
                        }
                        files.add(f);
                    }
                    Comparator<File> c = new Comparator<File>(){

                        @Override
                        public int compare(File lhs, File rhs) {
                            return lhs.getName().compareTo(rhs.getName());
                        }
                    };
                    Collections.sort(dirs, c);
                    Collections.sort(files, c);
                    files.addAll(0, dirs);
                    StringBuilder builder = new StringBuilder();
                    for (File f : files) {
                        String p = new File(request.getPath(), f.getName()).getAbsolutePath();
                        builder.append(String.format("<div><a href='%s'>%s</a></div>", p, f.getName()));
                    }
                    response.send(builder.toString());
                    return;
                }
                if (!file.isFile()) {
                    response.code(404);
                    response.end();
                    return;
                }
                try {
                    FileInputStream is = new FileInputStream(file);
                    response.code(200);
                    Util.pump(is, is.available(), response, new CompletedCallback(){

                        @Override
                        public void onCompleted(Exception ex) {
                            response.end();
                        }
                    });
                }
                catch (IOException ex) {
                    response.code(404);
                    response.end();
                }
            }
        });
    }

    public HttpServerRequestCallback getCallback() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteMatch route(String method, String path) {
        ArrayList<RouteInfo> arrayList = this.routes;
        synchronized (arrayList) {
            for (RouteInfo p : this.routes) {
                Matcher m;
                if (!TextUtils.equals((CharSequence)method, (CharSequence)p.method) && p.method != null || !(m = p.regex.matcher(path)).matches()) continue;
                if (p.callback instanceof RouteMatcher) {
                    String subPath = m.group(1);
                    return ((RouteMatcher)((Object)p.callback)).route(method, subPath);
                }
                return new RouteMatch(method, path, m, p.callback, p.bodyCallback);
            }
        }
        return null;
    }

    class Callback
    implements HttpServerRequestCallback,
    RouteMatcher {
        Callback() {
        }

        @Override
        public void onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
            RouteMatch match = this.route(request.getMethod(), request.getPath());
            if (match == null) {
                response.code(404);
                response.end();
                return;
            }
            match.callback.onRequest(request, response);
        }

        @Override
        public RouteMatch route(String method, String path) {
            return AsyncHttpServerRouter.this.route(method, path);
        }
    }

    abstract class AsyncHttpServerRequestImpl
    extends com.koushikdutta.async.http.server.AsyncHttpServerRequestImpl {
        Matcher matcher;

        AsyncHttpServerRequestImpl() {
        }

        @Override
        public Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        public void setMatcher(Matcher matcher) {
            this.matcher = matcher;
        }
    }

    public static class RouteMatch {
        public final String method;
        public final String path;
        public final Matcher matcher;
        public final HttpServerRequestCallback callback;
        public final AsyncHttpRequestBodyProvider bodyCallback;

        private RouteMatch(String method, String path, Matcher matcher, HttpServerRequestCallback callback, AsyncHttpRequestBodyProvider bodyCallback) {
            this.method = method;
            this.path = path;
            this.matcher = matcher;
            this.callback = callback;
            this.bodyCallback = bodyCallback;
        }
    }

    public static class Asset {
        public int available;
        public InputStream inputStream;
        public String path;

        public Asset(int available, InputStream inputStream, String path) {
            this.available = available;
            this.inputStream = inputStream;
            this.path = path;
        }
    }

    private static class RouteInfo {
        String method;
        Pattern regex;
        HttpServerRequestCallback callback;
        AsyncHttpRequestBodyProvider bodyCallback;

        private RouteInfo() {
        }
    }
}

