/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.filter;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.PushParser;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.http.filter.InflaterInputFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.zip.CRC32;
import java.util.zip.Inflater;

public class GZIPInputFilter
extends InflaterInputFilter {
    private static final int FCOMMENT = 16;
    private static final int FEXTRA = 4;
    private static final int FHCRC = 2;
    private static final int FNAME = 8;
    boolean mNeedsHeader = true;
    protected CRC32 crc = new CRC32();

    static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public GZIPInputFilter() {
        super(new Inflater(true));
    }

    public static int unsignedToBytes(byte b) {
        return b & 0xFF;
    }

    @Override
    public void onDataAvailable(final DataEmitter emitter, ByteBufferList bb) {
        if (this.mNeedsHeader) {
            final PushParser parser = new PushParser(emitter);
            parser.readByteArray(10, new PushParser.ParseCallback<byte[]>(){
                int flags;
                boolean hcrc;

                @Override
                public void parsed(byte[] header) {
                    short magic = GZIPInputFilter.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN);
                    if (magic != -29921) {
                        GZIPInputFilter.this.report(new IOException(String.format(Locale.ENGLISH, "unknown format (magic number %x)", magic)));
                        emitter.setDataCallback(new DataCallback.NullDataCallback());
                        return;
                    }
                    this.flags = header[3];
                    boolean bl = this.hcrc = (this.flags & 2) != 0;
                    if (this.hcrc) {
                        GZIPInputFilter.this.crc.update(header, 0, header.length);
                    }
                    if ((this.flags & 4) != 0) {
                        parser.readByteArray(2, new PushParser.ParseCallback<byte[]>(){

                            @Override
                            public void parsed(byte[] header) {
                                if (hcrc) {
                                    GZIPInputFilter.this.crc.update(header, 0, 2);
                                }
                                int length = GZIPInputFilter.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
                                parser.readByteArray(length, new PushParser.ParseCallback<byte[]>(){

                                    @Override
                                    public void parsed(byte[] buf) {
                                        if (hcrc) {
                                            GZIPInputFilter.this.crc.update(buf, 0, buf.length);
                                        }
                                        this.next();
                                    }
                                });
                            }
                        });
                    } else {
                        this.next();
                    }
                }

                private void next() {
                    PushParser parser2 = new PushParser(emitter);
                    DataCallback summer = new DataCallback(){

                        @Override
                        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                            if (hcrc) {
                                while (bb.size() > 0) {
                                    ByteBuffer b = bb.remove();
                                    GZIPInputFilter.this.crc.update(b.array(), b.arrayOffset() + b.position(), b.remaining());
                                    ByteBufferList.reclaim(b);
                                }
                            }
                            bb.recycle();
                            this.done();
                        }
                    };
                    if ((this.flags & 8) != 0) {
                        parser2.until((byte)0, summer);
                        return;
                    }
                    if ((this.flags & 0x10) != 0) {
                        parser2.until((byte)0, summer);
                        return;
                    }
                    this.done();
                }

                private void done() {
                    if (this.hcrc) {
                        parser.readByteArray(2, new PushParser.ParseCallback<byte[]>(){

                            @Override
                            public void parsed(byte[] header) {
                                short crc16 = GZIPInputFilter.peekShort(header, 0, ByteOrder.LITTLE_ENDIAN);
                                if ((short)GZIPInputFilter.this.crc.getValue() != crc16) {
                                    GZIPInputFilter.this.report(new IOException("CRC mismatch"));
                                    return;
                                }
                                GZIPInputFilter.this.crc.reset();
                                GZIPInputFilter.this.mNeedsHeader = false;
                                GZIPInputFilter.this.setDataEmitter(emitter);
                            }
                        });
                    } else {
                        GZIPInputFilter.this.mNeedsHeader = false;
                        GZIPInputFilter.this.setDataEmitter(emitter);
                    }
                }
            });
        } else {
            super.onDataAvailable(emitter, bb);
        }
    }
}

