/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.ThenFutureCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Futures {
    public static <T> Future<List<T>> waitAll(final List<Future<T>> futures) {
        final ArrayList results = new ArrayList();
        final SimpleFuture ret = new SimpleFuture();
        if (futures.isEmpty()) {
            ret.setComplete(results);
            return ret;
        }
        FutureCallback cb = new FutureCallback<T>(){
            int count = 0;

            @Override
            public void onCompleted(Exception e, T result) {
                results.add(result);
                ++this.count;
                if (this.count < futures.size()) {
                    ((Future)futures.get(this.count)).setCallback(this);
                } else {
                    ret.setComplete(results);
                }
            }
        };
        futures.get(0).setCallback(cb);
        return ret;
    }

    public static <T> Future<List<T>> waitAll(Future<T> ... futures) {
        return Futures.waitAll(Arrays.asList(futures));
    }

    private static <T, F> void loopUntil(Iterator<F> values, ThenFutureCallback<T, F> callback, SimpleFuture<T> ret, Exception lastException) {
        while (values.hasNext()) {
            try {
                callback.then(values.next()).success(ret::setComplete).fail(e -> Futures.loopUntil(values, callback, ret, e));
                return;
            }
            catch (Exception e2) {
                lastException = e2;
            }
        }
        if (lastException == null) {
            ret.setComplete(new Exception("empty list"));
        } else {
            ret.setComplete(lastException);
        }
    }

    public static <T, F> Future<T> loopUntil(Iterable<F> values, ThenFutureCallback<T, F> callback) {
        SimpleFuture ret = new SimpleFuture();
        Futures.loopUntil(values.iterator(), callback, ret, null);
        return ret;
    }

    public static <T, F> Future<T> loopUntil(F[] values, ThenFutureCallback<T, F> callback) {
        return Futures.loopUntil(Arrays.asList(values), callback);
    }
}

