/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import com.koushikdutta.async.AsyncDatagramSocket;
import com.koushikdutta.async.AsyncNetworkSocket;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.ChannelWrapper;
import com.koushikdutta.async.HostnameResolutionException;
import com.koushikdutta.async.SelectorWrapper;
import com.koushikdutta.async.ServerSocketChannelWrapper;
import com.koushikdutta.async.ThreadQueue;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.callback.SocketCreateCallback;
import com.koushikdutta.async.callback.ValueFunction;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.util.StreamUtility;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncServer {
    public static final String LOGTAG = "NIO";
    static AsyncServer mInstance;
    private SelectorWrapper mSelector;
    String mName;
    private static ExecutorService synchronousWorkers;
    boolean killed;
    int postCounter = 0;
    PriorityQueue<Scheduled> mQueue = new PriorityQueue<Scheduled>(1, Scheduler.INSTANCE);
    private static final Comparator<InetAddress> ipSorter;
    private static ExecutorService synchronousResolverWorkers;
    private static final ThreadLocal<AsyncServer> threadServer;
    Thread mAffinity;
    private static final long QUEUE_EMPTY = Long.MAX_VALUE;

    public static void post(Handler handler, Runnable runnable) {
        ThreadQueue threadQueue;
        RunnableWrapper wrapper = new RunnableWrapper();
        wrapper.threadQueue = threadQueue = ThreadQueue.getOrCreateThreadQueue(handler.getLooper().getThread());
        wrapper.handler = handler;
        wrapper.runnable = runnable;
        threadQueue.add(wrapper);
        handler.post((Runnable)wrapper);
        threadQueue.queueSemaphore.release();
    }

    public static AsyncServer getDefault() {
        return mInstance;
    }

    public boolean isRunning() {
        return this.mSelector != null;
    }

    public AsyncServer() {
        this(null);
    }

    public AsyncServer(String name) {
        if (name == null) {
            name = "AsyncServer";
        }
        this.mName = name;
    }

    private static void wakeup(SelectorWrapper selector) {
        synchronousWorkers.execute(() -> {
            try {
                selector.wakeupOnce();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            this.killed = true;
        }
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable postDelayed(Runnable runnable, long delay) {
        Scheduled s;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (this.killed) {
                return SimpleCancellable.CANCELLED;
            }
            long time = delay > 0L ? SystemClock.elapsedRealtime() + delay : (delay == 0L ? (long)this.postCounter++ : (this.mQueue.size() > 0 ? Math.min(0L, this.mQueue.peek().time - 1L) : 0L));
            s = new Scheduled(this, runnable, time);
            this.mQueue.add(s);
            if (this.mSelector == null) {
                this.run();
            }
            if (!this.isAffinityThread()) {
                AsyncServer.wakeup(this.mSelector);
            }
        }
        return s;
    }

    public Cancellable postImmediate(Runnable runnable) {
        if (Thread.currentThread() == this.getAffinity()) {
            runnable.run();
            return null;
        }
        return this.postDelayed(runnable, -1L);
    }

    public Cancellable post(Runnable runnable) {
        return this.postDelayed(runnable, 0L);
    }

    public Cancellable post(CompletedCallback callback, Exception e) {
        return this.post(() -> callback.onCompleted(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable runnable) {
        Semaphore semaphore;
        if (Thread.currentThread() == this.mAffinity) {
            this.post(runnable);
            AsyncServer.lockAndRunQueue(this, this.mQueue);
            return;
        }
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (this.killed) {
                return;
            }
            semaphore = new Semaphore(0);
            this.post(() -> {
                runnable.run();
                semaphore.release();
            });
        }
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"run", (Throwable)e);
        }
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean wait) {
        Semaphore semaphore;
        boolean isAffinityThread;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            isAffinityThread = this.isAffinityThread();
            final SelectorWrapper currentSelector = this.mSelector;
            if (currentSelector == null) {
                return;
            }
            semaphore = new Semaphore(0);
            this.mQueue.add(new Scheduled(this, new Runnable(){

                @Override
                public void run() {
                    AsyncServer.shutdownEverything(currentSelector);
                    semaphore.release();
                }
            }, 0L));
            synchronousWorkers.execute(() -> {
                try {
                    currentSelector.wakeupOnce();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            AsyncServer.shutdownKeys(currentSelector);
            this.mQueue = new PriorityQueue<Scheduled>(1, Scheduler.INSTANCE);
            this.mSelector = null;
            this.mAffinity = null;
        }
        try {
            if (!isAffinityThread && wait) {
                semaphore.acquire();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onDataReceived(int transmitted) {
    }

    protected void onDataSent(int transmitted) {
    }

    public AsyncServerSocket listen(final InetAddress host, final int port, final ListenCallback handler) {
        final ObjectHolder holder = new ObjectHolder();
        this.run(new Runnable(){

            @Override
            public void run() {
                ServerSocketChannel closeableServer = null;
                ServerSocketChannelWrapper closeableWrapper = null;
                try {
                    closeableServer = ServerSocketChannel.open();
                    closeableWrapper = new ServerSocketChannelWrapper(closeableServer);
                    final ServerSocketChannel server = closeableServer;
                    final ServerSocketChannelWrapper wrapper = closeableWrapper;
                    InetSocketAddress isa = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                    server.socket().bind(isa);
                    final SelectionKey key = wrapper.register(AsyncServer.this.mSelector.getSelector());
                    key.attach(handler);
                    holder.held = new AsyncServerSocket(){

                        @Override
                        public int getLocalPort() {
                            return server.socket().getLocalPort();
                        }

                        @Override
                        public void stop() {
                            StreamUtility.closeQuietly(wrapper);
                            try {
                                key.cancel();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    handler.onListening((AsyncServerSocket)holder.held);
                }
                catch (IOException e) {
                    Log.e((String)AsyncServer.LOGTAG, (String)"wtf", (Throwable)e);
                    StreamUtility.closeQuietly(closeableWrapper, closeableServer);
                    handler.onCompleted(e);
                }
            }
        });
        return (AsyncServerSocket)holder.held;
    }

    public Cancellable connectResolvedInetSocketAddress(InetSocketAddress address, ConnectCallback callback) {
        return this.connectResolvedInetSocketAddress(address, callback, null);
    }

    public ConnectFuture connectResolvedInetSocketAddress(final InetSocketAddress address, final ConnectCallback callback, final SocketCreateCallback createCallback) {
        final ConnectFuture cancel = new ConnectFuture();
        assert (!address.isUnresolved());
        this.post(new Runnable(){

            @Override
            public void run() {
                if (cancel.isCancelled()) {
                    return;
                }
                cancel.callback = callback;
                SelectionKey ckey = null;
                SocketChannel socket = null;
                try {
                    socket = cancel.socket = SocketChannel.open();
                    socket.configureBlocking(false);
                    ckey = socket.register(AsyncServer.this.mSelector.getSelector(), 8);
                    ckey.attach(cancel);
                    if (createCallback != null) {
                        createCallback.onSocketCreated(socket.socket().getLocalPort());
                    }
                    socket.connect(address);
                }
                catch (Throwable e) {
                    if (ckey != null) {
                        ckey.cancel();
                    }
                    StreamUtility.closeQuietly(socket);
                    cancel.setComplete(new RuntimeException(e));
                }
            }
        });
        return cancel;
    }

    public Cancellable connectSocket(final InetSocketAddress remote, final ConnectCallback callback) {
        if (!remote.isUnresolved()) {
            return this.connectResolvedInetSocketAddress(remote, callback);
        }
        final SimpleFuture ret = new SimpleFuture();
        Future<InetAddress> lookup = this.getByName(remote.getHostName());
        ret.setParent(lookup);
        lookup.setCallback(new FutureCallback<InetAddress>(){

            @Override
            public void onCompleted(Exception e, InetAddress result) {
                if (e != null) {
                    callback.onConnectCompleted(e, null);
                    ret.setComplete(e);
                    return;
                }
                ret.setComplete((ConnectFuture)AsyncServer.this.connectResolvedInetSocketAddress(new InetSocketAddress(result, remote.getPort()), callback));
            }
        });
        return ret;
    }

    public Cancellable connectSocket(String host, int port, ConnectCallback callback) {
        return this.connectSocket(InetSocketAddress.createUnresolved(host, port), callback);
    }

    private static ExecutorService newSynchronousWorkers(String prefix) {
        NamedThreadFactory tf = new NamedThreadFactory(prefix);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(0, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tf);
        return tpe;
    }

    public Future<InetAddress[]> getAllByName(final String host) {
        final SimpleFuture<InetAddress[]> ret = new SimpleFuture<InetAddress[]>();
        synchronousResolverWorkers.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final InetAddress[] result = InetAddress.getAllByName(host);
                    Arrays.sort(result, ipSorter);
                    if (result == null || result.length == 0) {
                        throw new HostnameResolutionException("no addresses for host");
                    }
                    AsyncServer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            ret.setComplete(null, result);
                        }
                    });
                }
                catch (Exception e) {
                    AsyncServer.this.post(new Runnable(){

                        @Override
                        public void run() {
                            ret.setComplete(e, null);
                        }
                    });
                }
            }
        });
        return ret;
    }

    public Future<InetAddress> getByName(String host) {
        return this.getAllByName(host).thenConvert(addresses -> addresses[0]);
    }

    private void handleSocket(AsyncNetworkSocket handler) throws ClosedChannelException {
        ChannelWrapper sc = handler.getChannel();
        SelectionKey ckey = sc.register(this.mSelector.getSelector());
        ckey.attach(handler);
        handler.setup(this, ckey);
    }

    public AsyncDatagramSocket connectDatagram(final String host, final int port) throws IOException {
        final DatagramChannel socket = DatagramChannel.open();
        final AsyncDatagramSocket handler = new AsyncDatagramSocket();
        handler.attach(socket);
        this.run(new Runnable(){

            @Override
            public void run() {
                try {
                    InetSocketAddress remote = new InetSocketAddress(host, port);
                    AsyncServer.this.handleSocket(handler);
                    socket.connect(remote);
                }
                catch (IOException e) {
                    Log.e((String)AsyncServer.LOGTAG, (String)"Datagram error", (Throwable)e);
                    StreamUtility.closeQuietly(socket);
                }
            }
        });
        return handler;
    }

    public AsyncDatagramSocket openDatagram() {
        return this.openDatagram(null, 0, false);
    }

    public Cancellable createDatagram(String address, int port, boolean reuseAddress, FutureCallback<AsyncDatagramSocket> callback) {
        return this.createDatagram(() -> InetAddress.getByName(address), port, reuseAddress, callback);
    }

    public Cancellable createDatagram(InetAddress address, int port, boolean reuseAddress, FutureCallback<AsyncDatagramSocket> callback) {
        return this.createDatagram(() -> address, port, reuseAddress, callback);
    }

    private Cancellable createDatagram(ValueFunction<InetAddress> inetAddressValueFunction, int port, boolean reuseAddress, FutureCallback<AsyncDatagramSocket> callback) {
        SimpleFuture<AsyncDatagramSocket> ret = new SimpleFuture<AsyncDatagramSocket>();
        ret.setCallback(callback);
        this.post(() -> {
            DatagramChannel socket = null;
            try {
                socket = DatagramChannel.open();
                AsyncDatagramSocket handler = new AsyncDatagramSocket();
                handler.attach(socket);
                InetSocketAddress address = inetAddressValueFunction == null ? new InetSocketAddress(port) : new InetSocketAddress((InetAddress)inetAddressValueFunction.getValue(), port);
                if (reuseAddress) {
                    socket.socket().setReuseAddress(reuseAddress);
                }
                socket.socket().bind(address);
                this.handleSocket(handler);
                if (!ret.setComplete(handler)) {
                    socket.close();
                }
            }
            catch (Exception e) {
                StreamUtility.closeQuietly(socket);
                ret.setComplete(e);
            }
        });
        return ret;
    }

    public AsyncDatagramSocket openDatagram(InetAddress host, int port, boolean reuseAddress) {
        AsyncDatagramSocket handler = new AsyncDatagramSocket();
        Runnable runnable = () -> {
            DatagramChannel socket;
            try {
                socket = DatagramChannel.open();
            }
            catch (Exception e) {
                return;
            }
            try {
                handler.attach(socket);
                InetSocketAddress address = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                if (reuseAddress) {
                    socket.socket().setReuseAddress(reuseAddress);
                }
                socket.socket().bind(address);
                this.handleSocket(handler);
            }
            catch (IOException e) {
                Log.e((String)LOGTAG, (String)"Datagram error", (Throwable)e);
                StreamUtility.closeQuietly(socket);
            }
        };
        if (this.getAffinity() != Thread.currentThread()) {
            this.run(runnable);
            return handler;
        }
        runnable.run();
        return handler;
    }

    public AsyncDatagramSocket connectDatagram(SocketAddress remote) throws IOException {
        AsyncDatagramSocket handler = new AsyncDatagramSocket();
        DatagramChannel socket = DatagramChannel.open();
        handler.attach(socket);
        Runnable runnable = () -> {
            try {
                this.handleSocket(handler);
                socket.connect(remote);
            }
            catch (IOException e) {
                StreamUtility.closeQuietly(socket);
            }
        };
        if (this.getAffinity() != Thread.currentThread()) {
            this.run(runnable);
            return handler;
        }
        runnable.run();
        return handler;
    }

    public static AsyncServer getCurrentThreadServer() {
        return threadServer.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        PriorityQueue<Scheduled> queue;
        SelectorWrapper selector;
        AsyncServer asyncServer = this;
        synchronized (asyncServer) {
            if (this.mSelector == null) {
                PriorityQueue<Scheduled> queue2;
                SelectorWrapper selector2;
                try {
                    selector2 = this.mSelector = new SelectorWrapper(SelectorProvider.provider().openSelector());
                    queue2 = this.mQueue;
                }
                catch (IOException e) {
                    throw new RuntimeException("unable to create selector?", e);
                }
                this.mAffinity = new Thread(this.mName){

                    @Override
                    public void run() {
                        try {
                            threadServer.set(AsyncServer.this);
                            AsyncServer.run(AsyncServer.this, selector2, queue2);
                        }
                        finally {
                            threadServer.remove();
                        }
                    }
                };
                this.mAffinity.start();
                return;
            }
            selector = this.mSelector;
            queue = this.mQueue;
        }
        try {
            AsyncServer.runLoop(this, selector, queue);
        }
        catch (AsyncSelectorException e) {
            Log.i((String)LOGTAG, (String)"Selector closed", (Throwable)e);
            try {
                selector.getSelector().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void run(AsyncServer server, SelectorWrapper selector, PriorityQueue<Scheduled> queue) {
        while (true) {
            try {
                AsyncServer.runLoop(server, selector, queue);
            }
            catch (AsyncSelectorException e) {
                if (!(e.getCause() instanceof ClosedSelectorException)) {
                    Log.i((String)LOGTAG, (String)"Selector exception, shutting down", (Throwable)e);
                }
                StreamUtility.closeQuietly(selector);
            }
            AsyncServer asyncServer = server;
            synchronized (asyncServer) {
                if (!selector.isOpen() || selector.keys().size() <= 0 && queue.size() <= 0) break;
            }
        }
        {
            AsyncServer.shutdownEverything(selector);
            if (server.mSelector != selector) return;
            server.mQueue = new PriorityQueue<Scheduled>(1, Scheduler.INSTANCE);
            server.mSelector = null;
            server.mAffinity = null;
            return;
        }
    }

    private static void shutdownKeys(SelectorWrapper selector) {
        try {
            for (SelectionKey key : selector.keys()) {
                StreamUtility.closeQuietly(key.channel());
                try {
                    key.cancel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void shutdownEverything(SelectorWrapper selector) {
        AsyncServer.shutdownKeys(selector);
        StreamUtility.closeQuietly(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long lockAndRunQueue(AsyncServer server, PriorityQueue<Scheduled> queue) {
        long wait = Long.MAX_VALUE;
        while (true) {
            Scheduled run = null;
            AsyncServer asyncServer = server;
            synchronized (asyncServer) {
                long now = SystemClock.elapsedRealtime();
                if (queue.size() > 0) {
                    Scheduled s = (Scheduled)queue.remove();
                    if (s.time <= now) {
                        run = s;
                    } else {
                        wait = s.time - now;
                        queue.add(s);
                    }
                }
            }
            if (run == null) break;
            run.run();
        }
        server.postCounter = 0;
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLoop(AsyncServer server, SelectorWrapper selector, PriorityQueue<Scheduled> queue) throws AsyncSelectorException {
        boolean needsSelect = true;
        long wait = AsyncServer.lockAndRunQueue(server, queue);
        try {
            AsyncServer asyncServer = server;
            synchronized (asyncServer) {
                int readyNow = selector.selectNow();
                if (readyNow == 0) {
                    if (selector.keys().size() == 0 && wait == Long.MAX_VALUE) {
                        return;
                    }
                } else {
                    needsSelect = false;
                }
            }
            if (needsSelect) {
                if (wait == Long.MAX_VALUE) {
                    selector.select();
                } else {
                    selector.select(wait);
                }
            }
        }
        catch (Exception e) {
            throw new AsyncSelectorException(e);
        }
        Set<SelectionKey> readyKeys = selector.selectedKeys();
        for (SelectionKey key : readyKeys) {
            try {
                AsyncNetworkSocket handler;
                if (key.isAcceptable()) {
                    ServerSocketChannel nextReady = (ServerSocketChannel)key.channel();
                    SocketChannel sc = null;
                    SelectionKey ckey = null;
                    try {
                        sc = nextReady.accept();
                        if (sc == null) continue;
                        sc.configureBlocking(false);
                        ckey = sc.register(selector.getSelector(), 1);
                        ListenCallback serverHandler = (ListenCallback)key.attachment();
                        AsyncNetworkSocket handler2 = new AsyncNetworkSocket();
                        handler2.attach(sc, (InetSocketAddress)sc.socket().getRemoteSocketAddress());
                        handler2.setup(server, ckey);
                        ckey.attach(handler2);
                        serverHandler.onAccepted(handler2);
                    }
                    catch (IOException e) {
                        StreamUtility.closeQuietly(sc);
                        if (ckey == null) continue;
                        ckey.cancel();
                    }
                    continue;
                }
                if (key.isReadable()) {
                    handler = (AsyncNetworkSocket)key.attachment();
                    int transmitted = handler.onReadable();
                    server.onDataReceived(transmitted);
                    continue;
                }
                if (key.isWritable()) {
                    handler = (AsyncNetworkSocket)key.attachment();
                    handler.onDataWritable();
                    continue;
                }
                if (key.isConnectable()) {
                    AsyncNetworkSocket newHandler;
                    ConnectFuture cancel = (ConnectFuture)key.attachment();
                    SocketChannel sc = (SocketChannel)key.channel();
                    key.interestOps(1);
                    try {
                        sc.finishConnect();
                        newHandler = new AsyncNetworkSocket();
                        newHandler.setup(server, key);
                        newHandler.attach(sc, (InetSocketAddress)sc.socket().getRemoteSocketAddress());
                        key.attach(newHandler);
                    }
                    catch (IOException ex) {
                        key.cancel();
                        StreamUtility.closeQuietly(sc);
                        if (!cancel.setComplete(ex)) continue;
                        cancel.callback.onConnectCompleted(ex, null);
                        continue;
                    }
                    if (!cancel.setComplete(newHandler)) continue;
                    cancel.callback.onConnectCompleted(null, newHandler);
                    continue;
                }
                Log.i((String)LOGTAG, (String)"wtf");
                throw new RuntimeException("Unknown key state.");
            }
            catch (CancelledKeyException cancelledKeyException) {
            }
        }
        readyKeys.clear();
    }

    public void dump() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (AsyncServer.this.mSelector == null) {
                    Log.i((String)AsyncServer.LOGTAG, (String)"Server dump not possible. No selector?");
                    return;
                }
                Log.i((String)AsyncServer.LOGTAG, (String)("Key Count: " + AsyncServer.this.mSelector.keys().size()));
                for (SelectionKey key : AsyncServer.this.mSelector.keys()) {
                    Log.i((String)AsyncServer.LOGTAG, (String)("Key: " + key));
                }
            }
        });
    }

    public Thread getAffinity() {
        return this.mAffinity;
    }

    public boolean isAffinityThread() {
        return this.mAffinity == Thread.currentThread();
    }

    public boolean isAffinityThreadOrStopped() {
        Thread affinity = this.mAffinity;
        return affinity == null || affinity == Thread.currentThread();
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 8) {
                System.setProperty("java.net.preferIPv4Stack", "true");
                System.setProperty("java.net.preferIPv6Addresses", "false");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mInstance = new AsyncServer();
        synchronousWorkers = AsyncServer.newSynchronousWorkers("AsyncServer-worker-");
        ipSorter = new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress lhs, InetAddress rhs) {
                if (lhs instanceof Inet4Address && rhs instanceof Inet4Address) {
                    return 0;
                }
                if (lhs instanceof Inet6Address && rhs instanceof Inet6Address) {
                    return 0;
                }
                if (lhs instanceof Inet4Address && rhs instanceof Inet6Address) {
                    return -1;
                }
                return 1;
            }
        };
        synchronousResolverWorkers = AsyncServer.newSynchronousWorkers("AsyncServer-resolver-");
        threadServer = new ThreadLocal();
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class AsyncSelectorException
    extends IOException {
        public AsyncSelectorException(Exception e) {
            super(e);
        }
    }

    private class ConnectFuture
    extends SimpleFuture<AsyncNetworkSocket> {
        SocketChannel socket;
        ConnectCallback callback;

        private ConnectFuture() {
        }

        @Override
        protected void cancelCleanup() {
            super.cancelCleanup();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ObjectHolder<T> {
        T held;

        private ObjectHolder() {
        }
    }

    static class Scheduler
    implements Comparator<Scheduled> {
        public static Scheduler INSTANCE = new Scheduler();

        private Scheduler() {
        }

        @Override
        public int compare(Scheduled s1, Scheduled s2) {
            if (s1.time == s2.time) {
                return 0;
            }
            if (s1.time > s2.time) {
                return 1;
            }
            return -1;
        }
    }

    private static class Scheduled
    implements Cancellable,
    Runnable {
        public AsyncServer server;
        public Runnable runnable;
        public long time;
        boolean cancelled;

        public Scheduled(AsyncServer server, Runnable runnable, long time) {
            this.server = server;
            this.runnable = runnable;
            this.time = time;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            AsyncServer asyncServer = this.server;
            synchronized (asyncServer) {
                return !this.cancelled && !this.server.mQueue.contains(this);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            AsyncServer asyncServer = this.server;
            synchronized (asyncServer) {
                this.cancelled = this.server.mQueue.remove(this);
                return this.cancelled;
            }
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        boolean hasRun;
        Runnable runnable;
        ThreadQueue threadQueue;
        Handler handler;

        private RunnableWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunnableWrapper runnableWrapper = this;
            synchronized (runnableWrapper) {
                if (this.hasRun) {
                    return;
                }
                this.hasRun = true;
            }
            try {
                this.runnable.run();
            }
            finally {
                this.threadQueue.remove(this);
                this.handler.removeCallbacks((Runnable)this);
                this.threadQueue = null;
                this.handler = null;
                this.runnable = null;
            }
        }
    }
}

