/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.util;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class LruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private long size;
    private long maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(long maxSize) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        V mapValue;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            mapValue = this.map.get(key);
            if (mapValue != null) {
                ++this.hitCount;
                return mapValue;
            }
            ++this.missCount;
        }
        V createdValue = this.create(key);
        if (createdValue == null) {
            return null;
        }
        LruCache lruCache2 = this;
        synchronized (lruCache2) {
            ++this.createCount;
            mapValue = this.map.put(key, createdValue);
            if (mapValue != null) {
                this.map.put(key, mapValue);
            } else {
                this.size += this.safeSizeOf(key, createdValue);
            }
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            return mapValue;
        }
        this.trimToSize(this.maxSize);
        return createdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V previous;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            ++this.putCount;
            this.size += this.safeSizeOf(key, value);
            previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(long maxSize) {
        while (true) {
            V value;
            K key;
            LruCache lruCache = this;
            synchronized (lruCache) {
                if (this.size < 0L || this.map.isEmpty() && this.size != 0L) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> toEvict = this.map.entrySet().iterator().next();
                key = toEvict.getKey();
                value = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.safeSizeOf(key, value);
                ++this.evictionCount;
            }
            this.entryRemoved(true, key, value, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K key) {
        Object previous;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private long safeSizeOf(K key, V value) {
        long result = this.sizeOf(key, value);
        if (result < 0L) {
            throw new IllegalStateException("Negative size: " + key + "=" + value);
        }
        return result;
    }

    protected long sizeOf(K key, V value) {
        return 1L;
    }

    public final void evictAll() {
        this.trimToSize(-1L);
    }

    public final synchronized long size() {
        return this.size;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public final synchronized long maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
        return String.format(Locale.ENGLISH, "LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, hitPercent);
    }
}

